<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%-- Page:        statsPage.jsp
  -- Created:     10/20/2003
  -- Controller:  db/adm/schm/TableController.java
  --
  -- Description: Shows table stats and their values.
  --%>


<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>
<%@ page import="oracle.sysman.emo.adm.schema.table.TableConst" %>

<uix:renderingContext id="renderingContext">
<uix:bundle name="partMsgs" class="oracle.sysman.db.rsc.schm.PartitionsMsg"/>
<uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>
<oem:setURLEncoder id="renderingContext"/>
<uix:document>
  
<%-- HTML Page Title --%>
<%-- Fix Bug 4080599, for future release
<%@ include file="/oemTitle.jspf" %>
--%>
<uix:metaContainer>
  <uix:head titleBinding="STATS@partMsg"/>
</uix:metaContainer>

<uix:body>
<%-- HTML Form --%>

<db:form name="tblForm" 
         method="post" 
         destinationBinding="destination@objectBean@servletRequest"
         copyParams="target,type,cancelURL,sname,oname,otype" >

<uix:formValue name="pageName" value="<%= SchemaPages.TBL_STATS_PG %>"/>
<uix:pageLayout titleBinding="header@objectBean@servletRequest">

  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/global.jspf" %>

  <%-- Warning/Error display --%>
  <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error" 
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>

  <%-- Create/Edit/View Header --%>
  <uix:subTabLayout>
    
    <%-- Table SubTabs --%>
    <uix:subTabs>
      <jsp:include page="/database/schema/table/subTabsInclude.jsp" />
      <uix:ref refID="subTabsInclude" />
    </uix:subTabs>

    <%-- START: TABLE GENERAL PAGE starts here --%>
    <uix:stackLayout>
    <uix:spacer height="5" />
    <jsp:include page="/database/schema/table/statsInclude.jsp" />
    <uix:ref refID="statsInclude" />
    <uix:spacer height="5" />
    </uix:stackLayout>
    <%-- END: TABLE GENERAL PAGE ends here --%>   
        
  </uix:subTabLayout>  

  <%-- Table Buttons --%>
  <uix:pageButtons>
  <uix:pageButtonBar>
    <jsp:include page="/database/schema/pageButtonInclude.jsp" />
    <uix:ref refID="pageButtonInclude" />
  </uix:pageButtonBar>
  </uix:pageButtons>

</uix:pageLayout>
</db:form>
<%-- END: HTML Form --%>
</uix:body>

</uix:document>
</uix:renderingContext>
<%-- END: Content --%>


