<%--
  -- Copyright (c) 2007, 2009, Oracle and/or its affiliates. 
  -- All rights reserved. 
  -- Page:       storagePage.jsp
  -- Controller: db/adm/schm/TableController.java
  --
  -- Description: The Storage tab for Table.  
  --              This tab allows the user to see/edit 
  --              their table's storage parameters.
  --  MODIFIED    (MM/DD/YY)
  --   chanchan    07/09/09 - Support new compression GUI (ER bug 8669360)
  --   chanchan    05/01/09 - Add columnar compression supports (ER bug #8276145)
  --%>
<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>

<uix:renderingContext id="renderingContext">
  <uix:bundle name="msgs"
              class="oracle.sysman.db.rsc.schm.PartitionsMsg"/>
<oem:setURLEncoder id="renderingContext"/>

<uix:document>
  
<%-- HTML Page Title --%>
<%-- Fix Bug 4080599, for future release
<%@ include file="/oemTitle.jspf" %>
--%>
<uix:metaContainer>
  <uix:head titleBinding="STORAGE_TITLE@uixTableBundle@servletRequest"/>
</uix:metaContainer>

<uix:body>
<%-- HTML Form --%>
<db:form name="tblForm" 
         method="post" 
         destinationBinding="destination@objectBean@servletRequest"
         copyParams="target,type,cancelURL,sname,oname,otype">
<uix:formValue name="pageName" value="<%= SchemaPages.TBL_STORAGE_PG %>"/>
<uix:pageLayout titleBinding="header@objectBean@servletRequest">

  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/global.jspf" %>

  <%-- Warning/Error display --%>
  <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error" 
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>

  <%-- Create/Edit/View Header --%>
  <uix:subTabLayout>
    
    <%-- Table SubTabs --%>
    <uix:subTabs>
      <jsp:include page="/database/schema/table/subTabsInclude.jsp" />
      <uix:ref refID="subTabsInclude" />
    </uix:subTabs>

    <%-- If partitioned, storage is default partition storage --%>
    <uix:switcher childNameBinding="creating@objectBean@servletRequest">
      <uix:case name="false"> 
        <uix:stackLayout renderedBinding="partitioned@objectBean@servletRequest">
          <uix:spacer height="5" />
          <uix:styledText styleClass="OraInstructionText" 
                          textBinding="DESC_DEF_OPTS@msgs" />
        </uix:stackLayout>
      </uix:case>
    </uix:switcher>        

    <%-- START: TABLE STORAGE PAGE starts here --%>
    <uix:dataScope currentDataBinding="tblSegment@servletRequest">
      <jsp:include page="/database/schema/utilities/storageContextInclude.jsp" />
      <uix:ref refID="storageInclude" />
    <%-- END: TABLE STORAGE PAGE ends here --%>

   <uix:switcher childNameBinding="IOT@objectBean@servletRequest">
    <uix:case name="false"> 
     <uix:switcher childNameBinding="showCompress@tblSegment@servletRequest">
      <uix:case name="true"> 
        <%-- START: Compress Options starts here --%>
        <jsp:include page="/database/schema/compressOptionsInclude.jsp" />
        <uix:ref refID="compressInclude" />
        <%-- END: Compress Options ends here --%>
      </uix:case>
     </uix:switcher>        
    </uix:case> 
   </uix:switcher>        
   </uix:dataScope>

  </uix:subTabLayout>
    
  <%-- Table Buttons --%>
  <uix:pageButtons>
  <uix:pageButtonBar>
    <jsp:include page="/database/schema/pageButtonInclude.jsp" />
    <uix:ref refID="pageButtonInclude" />
  </uix:pageButtonBar>
  </uix:pageButtons>

</uix:pageLayout>
</db:form>
<%-- END: HTML Form --%>
</uix:body>

</uix:document>
</uix:renderingContext>
<%-- END: Content --%>
