<%--
  -- Page:       subTabsInclude.jsp
  -- Controller: db/adm/schm/TableController.java
  -- 
  -- Description: This handles all of the table subtabs.
  --              All events should be named: subTab<tabName>.
  --              In onEvent any event that starts with "subTab"
  --              will be forwarded to the onSubTab function where
  --              it will be handled.
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:buildTree nodeID="subTabsInclude">

<%-- Define Msg Bundles --%>
<uix:dataScope>
<uix:bundle name="partMsgs" class="oracle.sysman.db.rsc.schm.PartitionsMsg"/>

<uix:subTabBar selectedIndexBinding="selectedTab@objectBean@servletRequest">

  <%-- General Tab --%>
  <db:link textBinding="GENERAL@uixDBObjectBundle@servletRequest"
           shortDescBinding="GENERAL@uixDBObjectBundle@servletRequest"
           onClick="submitForm('tblForm', true, {event:'subTabGeneral'})"
           copyParams="target,type,cancelURL,sname,oname,otype" />

  <%-- Constraints Tab --%>
  <db:link textBinding="CONSTRAINTS@uixTableBundle@servletRequest" 
           shortDescBinding="CONSTRAINTS@uixTableBundle@servletRequest"
           renderedBinding="showConstraintsTab@objectBean@servletRequest"
           onClick="submitForm('tblForm', true, {event:'subTabConstraints'})" 
           copyParams="target,type,cancelURL,sname,oname,otype" />

  <%-- Cluster Columns Tab --%>
  <%-- comment out for future development .... -%>
  <%-- Use renderedBinding instead of switcher it stops empty space between tabs -%>
  <%-- NOTE: Use this as a place holder, otherwise all of tables tabs get messed up --%>
  <db:link textBinding="CLUSTER_COLUMNS@uixSchemaBundle@servletRequest"
           shortDescBinding="CLUSTER_COLUMNS@uixSchemaBundle@servletRequest"
           onClick="submitForm('tblForm', true, {event:'subTabClusterColumns'})"
           copyParams="target,type,cancelURL,sname,oname,otype"
           rendered="false" />
  <%-- 
  <uix:switcher childNameBinding="creating@objectBean@servletRequest">
    <uix:case name="true">
      <db:link textBinding="CLUSTER_COLUMNS@uixSchemaBundle@servletRequest"
               shortDescBinding="CLUSTER_COLUMNS@uixSchemaBundle@servletRequest"
               onClick="submitForm('tblForm', true, {event:'subTabClusterColumns'})"
               copyParams="target,type,cancelURL,sname,oname,otype" />
    </uix:case>
    <uix:case name="false">
      <db:link textBinding="CLUSTER_COLUMNS@uixSchemaBundle@servletRequest"
               shortDescBinding="CLUSTER_COLUMNS@uixSchemaBundle@servletRequest"
               renderedBinding="showClusterColumnsTab@objectBean@servletRequest"
               onClick="submitForm('tblForm', true, {event:'subTabClusterColumns'})"
               copyParams="target,type,cancelURL,sname,oname,otype" />
    </uix:case>
  </uix:switcher>
  --%>

  <%-- Segments Tab --%>
  <db:link textBinding="SEGMENTS@uixSchemaBundle@servletRequest"
           shortDescBinding="SEGMENTS@uixSchemaBundle@servletRequest"
           renderedBinding="showSegmentsTab@objectBean@servletRequest"
           onClick="submitForm('tblForm', true, {event:'subTabSpaceUsage'})" 
           copyParams="target,type,cancelURL,sname,oname,otype" />

  <%-- Storage Tab --%>
  <uix:switcher childNameBinding="temporary@objectBean@servletRequest">
    <uix:case name="false">
      <db:link textBinding="STORAGE@uixDBObjectBundle@servletRequest"
               shortDescBinding="STORAGE@uixDBObjectBundle@servletRequest"
               onClick="submitForm('tblForm', true, {event:'subTabStorage'})" 
               copyParams="target,type,cancelURL,sname,oname,otype" />
    </uix:case>
  </uix:switcher>

  <%-- Options Tab --%>
  <db:link textBinding="OPTIONS@uixDBObjectBundle@servletRequest"
           shortDescBinding="OPTIONS@uixDBObjectBundle@servletRequest"
           renderedBinding="showOptionsTab@objectBean@servletRequest"
           onClick="submitForm('tblForm', true, {event:'subTabOptions'})" 
           copyParams="target,type,cancelURL,sname,oname,otype" />

  <%-- Partitions Tab --%>
  <db:link textBinding="PARTITIONS@uixSchemaBundle@servletRequest"
           shortDescBinding="PARTITIONS@uixSchemaBundle@servletRequest"
           renderedBinding="partitioned@objectBean@servletRequest"
           onClick="submitForm('tblForm', true, {event:'subTabPartitions'})" 
           copyParams="target,type,cancelURL,sname,oname,otype" />

  <%-- IOT Tab --%>
  <db:link textBinding="IOT_PROPERTIES@uixDBObjectBundle@servletRequest"
           shortDescBinding="IOT_PROPERTIES@uixDBObjectBundle@servletRequest"
           onClick="submitForm('tblForm', true, {event:'subTabIOT'})" 
           renderedBinding="IOT@objectBean@servletRequest" 
           copyParams="target,type,cancelURL,sname,oname,otype" />

  <%-- Stats Tab --%>
  <db:link textBinding="STATS@partMsgs"
           shortDescBinding="STATS@partMsgs"
           onClick="submitForm('tblForm', true, {event:'subTabStats'})" 
           renderedBinding="showStatsTab@objectBean@servletRequest" 
           copyParams="target,type,cancelURL,sname,oname,otype" />

  <%-- Indexes Tab --%>
  <uix:switcher childNameBinding="creating@objectBean@servletRequest">
    <uix:case name="false">
      <db:link textBinding="INDEXES@uixDBObjectBundle@servletRequest"
               shortDescBinding="INDEXES@uixDBObjectBundle@servletRequest" 
               onClick="submitForm('tblForm', true, {event:'subTabIndexes'})" 
               renderedBinding="hasIndex@indexesDS@servletRequest" 
               copyParams="target,type,cancelURL,sname,oname,otype" />
    </uix:case>           
  </uix:switcher>           
</uix:subTabBar>
</uix:dataScope>
</uix:buildTree>

