<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>

<uix:buildTree nodeID="tableIndexesInclude">
      <uix:table id="indexesUITable"
                 alternateTextBinding="NO_OBJECT_FOUND@dbMsgs"
                 formSubmitted="true"
                 width="100%"
                 tableDataBinding="rowData"
                 minValue="1"
                 valueBinding="startIndex"
                 maxValueBinding="numRows"
                 blockSizeBinding="blockSize"
                 summaryBinding="INDEXES@dbMsgs">
        <uix:tableFormat tableBanding="rowBanding"/>
          <uix:column>
            <uix:columnHeader>
              <uix:sortableHeader textBinding="SCHEMA_INDEX@indMsgs" 
                                  sortableBinding="sortIndex"/>
            </uix:columnHeader>
            <uix:columnFormat columnDataFormat="textFormat"/>
            <uix:link textBinding="indexName" destinationBinding="indexNameDest"/>
          </uix:column>

          <uix:column>
            <uix:columnHeader>
              <uix:sortableHeader textBinding="INDEXED_COLUMNS@dbMsgs"/>
            </uix:columnHeader>
            <uix:columnFormat columnDataFormat="testFormat"/>
            <uix:styledText textBinding="columnName"/>
          </uix:column>

          <uix:column>
            <uix:columnHeader> 
              <uix:sortableHeader textBinding="COLUMN_POSITION@indMsgs"/>
            </uix:columnHeader> 
            <uix:columnFormat columnDataFormat="textFormat"/>
            <uix:styledText textBinding="columnPosition"/>
          </uix:column>

        </uix:table>

        <uix:rowLayout>
          <uix:spacer height="10"/>
        </uix:rowLayout>
</uix:buildTree>
<%-- END: Content --%>
