<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
 <uix:document>
 
<uix:metaContainer>
  <uix:head titleBinding="header@objectBean@servletRequest"/>
</uix:metaContainer>

  <uix:body>
<db:form name="foo" method="post" 
                destinationBinding="destination@servletRequest"  
		copyParams="target,type,oname,otype,cancelURL,sname">
<uix:formValue name="pageName" value="/database/schema/table/tableStorageLayout"/>
<uix:pageLayout titleBinding="header@objectBean@servletRequest">

  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/global.jspf" %>

  <%-- Warning/Error display --%>
  <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error" 
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>

       <uix:tableLayout width="100%">
	<uix:rowLayout hAlign="right">
         <uix:submitButton textBinding="displayModeText@defaultBean@servletRequest" 
		   	   name="event" 
			   value="switchDisplayMode" />
	</uix:rowLayout>
       </uix:tableLayout>

     <%-- ...... which display mode we are on ......--%>

   <uix:header textBinding="topologyHeaderText@defaultBean@servletRequest" size="1">

     <uix:switcher childNameBinding="defaultDisplayMode@defaultBean@servletRequest">
      <uix:case name="true">
	<%@ include file="/database/storage/topologyHgridViewer.jsp" %>
      </uix:case>
      <uix:case name="false">
       <jsp:include page="/database/storage/topologyViewer.jsp" />
       <uix:ref refID="sharedTopology" />
      </uix:case>
     </uix:switcher>

   </uix:header>

</uix:pageLayout>
</db:form>
</uix:body>
</uix:document>
</uix:renderingContext>

