<%--
  -- Copyright (c) 2007, 2009, Oracle and/or its affiliates. 
  -- All rights reserved. 
  -- Page:        tblOrgPage.jsp
  -- Controller:  db/adm/schm/TableGeneralController.java
  --
  -- Description: Page for defining what table organization you want.
  --              Includes options like, standard, IOT, clustered, etc.
  --
  --  MODIFIED    (MM/DD/YY)
  --   chanchan    09/23/08 - Add columnar compression support
  --%>

<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>
<%@ page import="oracle.sysman.emo.adm.schema.table.TableConst" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>
<uix:document>
  
<%-- HTML Page Title --%>
<%-- Fix Bug 4080599, for future release
<%@ include file="/oemTitle.jspf" %>
--%>
<uix:metaContainer>
  <uix:head titleBinding="TBL_ORG@uixTableBundle@servletRequest"/>
  <db:script src="/database/utils.js"/>
</uix:metaContainer>


<uix:body>
<%-- HTML Form --%>
<db:form name="tblForm"
         method="post"
         destinationBinding="destination@objectBean@servletRequest"
         copyParams="target,type,cancelURL,sname,oname,otype">
<uix:formValue name="pageName" value="<%= SchemaPages.TBL_ORGANIZATION_PG %>"/>
<uix:pageLayout titleBinding="TBL_ORG@uixTableBundle@servletRequest">

  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/global.jspf" %>

  <%-- Warning/Error display --%>
  <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error" 
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>

  <%-- START: TABLE ORGANIZATION CONTENTS starts here --%>
  <uix:pageStatus>
        <uix:styledText styleClass="OraInstructionText"
                        textBinding="TBL_ORG_TIP1@uixTableBundle@servletRequest" />
  </uix:pageStatus>
  <uix:stackLayout>
     <%-- Standard, Heap Organized --%>
     <oem:radioButton name="organization"
                      textBinding="STNDRD_OPT@uixTableBundle@servletRequest"
                      value="<%= TableConst.ORG_STANDARD %>"
                      selectedValueBinding="organization@objectBean@servletRequest" />
     
     <%-- Standard, Temporary --%>
     <uix:flowLayout>
       <uix:spacer width="15" height="1" />
       <uix:checkBox name="temporary"
                     textBinding="TEMP_OPT@uixTableBundle@servletRequest"
                     checkedBinding="temporary@objectBean@servletRequest" />
     </uix:flowLayout>
  
     <%-- IOT --%>
     <oem:radioButton name="organization"
                      textBinding="IOT_OPT@uixTableBundle@servletRequest"
                      value="<%= TableConst.ORG_IOT %>"
                      selectedValueBinding="organization@objectBean@servletRequest" />
		      
     <%-- Clustered --%>
     <%-- 
     <uix:radioButton name="tblOrg"
                      textBinding="CLUSTERED_OPT@uixTableBundle@servletRequest"
                      value="clustered"
                      selectedValue="stndrdHeap" />
     --%>

     <%-- External --%>
     <%--
     <uix:radioButton name="tblOrg"
                      textBinding="EXTERNAL_OPT@uixTableBundle@servletRequest"
                      value="external"
                      selectedValue="stndrdHeap" />
     --%>

      <%-- Tip --%>
      <%-- 
    <uix:spacer height="5"/>
     <uix:tip>
        <uix:styledText styleClass="OraTipText"
                        textBinding="TBL_ORG_TIP@uixTableBundle@servletRequest" />
     </uix:tip>
    --%>

  </uix:stackLayout>
  <%-- END: TABLE ORGANIZATION CONTENTS ends here --%>   
        
  <%-- OK/CANCEL Button --%>
  <uix:pageButtons>
  <uix:pageButtonBar>

    <%-- CANCEL BUTTON --%>
    <uix:submitButton textBinding="CANCEL@uixDBObjectBundle@servletRequest" 
                      shortDescBinding="CANCEL@uixDBObjectBundle@servletRequest" 
                      name="event" 
                      value="<%= TableConst.J_TBL_ORG_CANCEL %>" />

    <%-- OK BUTTON --%>
    <uix:submitButton textBinding="CONTINUE@uixDBObjectBundle@servletRequest" 
                      shortDescBinding="CONTINUE@uixDBObjectBundle@servletRequest" 
                      name="event" 
                      value="<%= TableConst.J_TBL_ORG_OK %>" />

  </uix:pageButtonBar>
  </uix:pageButtons>

</uix:pageLayout>
</db:form>
<%-- END: HTML Form --%>
</uix:body>

</uix:document>
</uix:renderingContext>
<%-- END: Content --%> 
