<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Copyright (c) 2007, 2009, Oracle and/or its affiliates. 
  -- All rights reserved. 
  -- Page:        viewTable.jsp
  -- Created:     06/05/2002
  -- Controller:  db/adm/schm/TableController.java
  --
  -- Description: A summary of this table definition.
  --              Intended for printing.
  --        NOTE: If a table tab changes, this needs
  --              to be updated.  Otherwise, worst
  --              case, it will break, best case,
  --              it's out of date.                   
  --  MODIFIED    (MM/DD/YY)
  --   chanchan    07/08/09 - Support new compression GUI
  --   chanchan    05/01/09 - Add columnar compression supports (ER bug #8276145)
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>
<%@ page import="oracle.sysman.emo.adm.schema.table.TableConst" %>
<%@ page import="oracle.sysman.emo.adm.schema.table.TableColumns" %>

  <uix:renderingContext id="renderingContext">
  <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>
  <uix:bundle name="indMsgs" class="oracle.sysman.db.rsc.schm.IndexMsg"/>
  <uix:bundle name="msgs" class="oracle.sysman.db.rsc.schm.PartitionsMsg"/>
  <uix:bundle name="tableMsgs" class="oracle.sysman.db.rsc.schm.TableMsg"/>
<oem:setURLEncoder id="renderingContext"/>
<uix:document>
  
<%-- HTML Page Title --%>
<%-- Fix Bug 4080599, for future release
<%@ include file="/oemTitle.jspf" %>
--%>
<uix:metaContainer>
  <uix:head titleBinding="VIEW_TITLE@uixTableBundle@servletRequest"/>
</uix:metaContainer>
<NOSCRIPT>
A browser with Javascript enabled is required for this page to operate properly.
</NOSCRIPT>

<%-- HTML Form --%>
<db:form name="tblForm" 
         method="post" 
         destinationBinding="destination@objectBean@servletRequest"
         copyParams="target,type,cancelURL,sname,oname,otype,guid,version,initMethod">
<uix:formValue name="pageName" value="<%= SchemaPages.TBL_VIEW_PG %>"/>
<uix:pageLayout titleBinding="header@objectBean@servletRequest">

  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/global.jspf" %>

  <%-- Warning/Error display --%>
  <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error" 
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>

  <%-- START: TABLE VIEW PAGE starts here --%>


  <%-- GENERAL TAB --%>
  <uix:header textBinding="GENERAL@uixDBObjectBundle@servletRequest">
  <uix:labeledFieldLayout>

      <%-- Name --%>
      <uix:messagePrompt promptBinding="NAME@uixDBObjectBundle@servletRequest" />
      <uix:styledText styleClass="OraDataText"
                      textBinding="tableName@objectBean@servletRequest" />

      <%-- Schema --%>
      <uix:messagePrompt promptBinding="SCHEMA@uixDBObjectBundle@servletRequest"/>
      <uix:styledText styleClass="OraDataText"
                      textBinding="schemaName@objectBean@servletRequest" />

      <%-- Tablespace --%>
      <uix:messagePrompt promptBinding="TABLESPACE@uixDBObjectBundle@servletRequest"/>
      <uix:styledText styleClass="OraDataText"
                      textBinding="tablespace@objectBean@servletRequest" />

      <%-- Organization --%>
      <uix:messagePrompt promptBinding="ORG@uixTableBundle@servletRequest"/>
      <uix:styledText styleClass="OraDataText"
                      textBinding="organizationHeader@objectBean@servletRequest" />

      <%-- Temporary Date --%>
      <uix:messagePrompt promptBinding="TEMPORARY@uixTableBundle@servletRequest"
                         renderedBinding="temporary@objectBean@servletRequest" />
      <uix:styledText styleClass="OraDataText"
                      textBinding="tempTypeText@objectBean@servletRequest" 
                      renderedBinding="temporary@objectBean@servletRequest" />


       <%-- Encryption --%>
 
      <uix:messageStyledText renderedBinding="version102Algo@objectBean@servletRequest"
                      prompt="Encryption Algorithm" textBinding="encryptAlgo@objectBean@servletRequest" 
                      vAlign="middle" contentStyleClass="OraDataText"/>

  </uix:labeledFieldLayout>  
  </uix:header>
  <%-- End: General Info --%>


  <%-- COLUMNS --%>
   <uix:switcher childNameBinding="defineUsing@objectBean@servletRequest" defaultCase="defCase">
        <uix:case name="<%= TableConst.DEF_XML_TYPE %>">
             <jsp:include page="/database/schema/table/viewXmlTypeTableInclude.jsp" />
             <uix:ref refID="viewXmlTypeInclude" />
        </uix:case>
        <uix:case name="defCase">
            <uix:dataScope currentDataBinding="tableColumnBean@servletRequest">

                <jsp:include page="/database/schema/table/generalColumnInclude.jsp" />
                <uix:ref refID="generalColumnInclude" />
             </uix:dataScope>
        </uix:case>
      </uix:switcher>
  


  

  <%-- CONSTRAINTS TAB --%>
  <uix:header textBinding="CONSTRAINTS@uixTableBundle@servletRequest">
    <oem:table name="constraintsTableUI" 
               beanKey="tableConstraintBean"
               destinationBinding="destination@tableColumnBean@servletRequest" 
               formSubmitted="true" 
               dataSourceProp="constraintsTableUI" 
               width="100%"
               summaryBinding="CONSTRAINTS@uixTableBundle@servletRequest"
               alternateTextBinding="NO_CONSTRAINTS@uixTableBundle@servletRequest" 
               copyParams="target,type,cancelURL,sname,oname,otype,guid,version,initMethod" />
  </uix:header>

  <%-- INDEXES INFO --%>
  <uix:switcher childNameBinding="xmlInitialized@objectBean@servletRequest">
   <uix:case name="false">
    <uix:header textBinding="INDEXES@dbMsgs"
                renderedBinding="hasIndexes@indexesDS@servletRequest">
     <uix:dataScope currentDataBinding="indexesDS@servletRequest">
      <uix:tableLayout cellSpacing="10" width="100%">
        <uix:labeledFieldLayout columns="1">
        <uix:messageStyledText 
            promptBinding="NUMBER_OF_INDEXES@uixDBObjectBundle@servletRequest"
            shortDescBinding="NUMBER_OF_INDEXES@uixDBObjectBundle@servletRequest"
            textBinding="numIndexes@"
            contentStyleClass="OraDataText"/>
        </uix:labeledFieldLayout> 
        <uix:spacer height="10"/>
        <jsp:include page="/database/schema/table/tableIndexesInclude.jsp"/>
        <uix:ref refID="tableIndexesInclude"/>
      </uix:tableLayout> 
     </uix:dataScope> 
    </uix:header>
   </uix:case>
  </uix:switcher>

  <%-- PARTITIONS TAB --%>
  <uix:header textBinding="PARTITIONS@uixSchemaBundle@servletRequest" 
              renderedBinding="partitioned@objectBean@servletRequest" >
    <jsp:include page="/database/schema/table/partitionsViewInclude.jsp" />
    <uix:ref refID="partitionsViewInclude" />
  </uix:header>



  <%-- STORAGE TAB --%>
  <uix:switcher childNameBinding="partitioned@objectBean@servletRequest">
    <uix:case name="false">
      <uix:header textBinding="STORAGE@uixDBObjectBundle@servletRequest">
        <uix:dataScope currentDataBinding="tblSegment@servletRequest">
          <jsp:include page="/database/schema/utilities/viewStorageContextInclude.jsp" />
          <uix:ref refID="viewStorageInclude" />
        </uix:dataScope>
      </uix:header>
    </uix:case>
  </uix:switcher> 




  <%-- OPTIONS TAB --%>
  <uix:header textBinding="OPTIONS@uixDBObjectBundle@servletRequest"
              renderedBinding="showOptionsTab@objectBean@servletRequest">
  <uix:labeledFieldLayout>    

       <%-- Parallel Degree --%>
       <uix:messagePrompt promptBinding="PARALLEL_DEGREE@uixTableBundle@servletRequest"/>
       <uix:switcher childNameBinding="parallel@objectBean@servletRequest">
         <uix:case name="true">
           <uix:switcher childNameBinding="defaultDegree@objectBean@servletRequest">
           <uix:case name="true">
               <uix:styledText styleClass="OraDataText"
                               textBinding="DEFAULT@uixDBObjectBundle@servletRequest" />
           </uix:case>
           <uix:case name="false">
               <uix:styledText styleClass="OraDataText"
                               textBinding="degree@objectBean@servletRequest" />
           </uix:case>
           </uix:switcher>
         </uix:case>
         <uix:case name="false">
           <uix:styledText styleClass="OraDataText"
                           textBinding="DISABLED@uixDBObjectBundle@servletRequest" />
         </uix:case>
       </uix:switcher>

       <%-- Row Movement --%>
       <uix:messagePrompt promptBinding="ROW_MOVEMENT@uixTableBundle@servletRequest"/>
       <uix:styledText styleClass="OraDataText"
                       textBinding="rowMovementOption@objectBean@servletRequest" />

       <%-- Compress --%>
         <uix:switcher childNameBinding="showCompress@tblSegment@servletRequest">
           <uix:case name="true"> 
             <uix:messagePrompt promptBinding="COMPRESSION@msgs"/>
           </uix:case> 
         </uix:switcher>
         <uix:switcher childNameBinding="showCompress@tblSegment@servletRequest">
           <uix:case name="true"> 
            <uix:dataScope currentDataBinding="tblSegment@servletRequest">
             <uix:switcher childNameBinding="compress@">
               <uix:case name="<%= TableConst.COMPRESSION_OPTION_DISABLED %>"> 
	         <uix:styledText styleClass="OraDataText"
                           textBinding="NO_COMPRESSION@tableMsgs" />
               </uix:case> 
               <uix:case name="<%= TableConst.COMPRESSION_OPTION_ENABLED_DIRECT %>"> 
	         <uix:styledText styleClass="OraDataText"
                           textBinding="BASIC_COMPRESSION@tableMsgs" />
               </uix:case> 
               <uix:case name="<%= TableConst.COMPRESSION_OPTION_ENABLED_ALL %>"> 
	         <uix:styledText styleClass="OraDataText"
                           textBinding="OLTP_COMPRESSION@tableMsgs" />
               </uix:case> 
               <uix:case name="<%= TableConst.COMPRESSION_OPTION_QUERY_HIGH %>"> 
	         <uix:styledText styleClass="OraDataText" textBinding="DATA_WAREHOUSE_COMPRESSION@tableMsgs" />
               </uix:case> 
               <uix:case name="<%= TableConst.COMPRESSION_OPTION_QUERY_LOW %>"> 
	         <uix:styledText styleClass="OraDataText" textBinding="DATA_WAREHOUSE_COMPRESSION@tableMsgs" />
               </uix:case> 
               <uix:case name="<%= TableConst.COMPRESSION_OPTION_ARCHIVE %>"> 
	         <uix:styledText styleClass="OraDataText" textBinding="ARCHIVE_COMPRESSION@tableMsgs" />
               </uix:case> 
             </uix:switcher>
            </uix:dataScope>
           </uix:case> 
         </uix:switcher>

       <%-- Cache --%>
       <uix:switcher childNameBinding="cache@objectBean@servletRequest">
         <uix:case name="true">
           <uix:messageStyledText promptBinding="CACHE@dbMsgs"
                       shortDescBinding="CACHE@dbMsgs"
                       textBinding="ENABLED@dbMsgs" 
                       contentStyleClass="OraDataText"/>
         </uix:case>
         <uix:case name="false">
           <uix:messageStyledText promptBinding="CACHE@dbMsgs"
                       shortDescBinding="CACHE@dbMsgs"
                       textBinding="DISABLED@dbMsgs" 
                       contentStyleClass="OraDataText"/>
         </uix:case>
       </uix:switcher>

       <%-- Monitoring --%>
       <uix:messagePrompt promptBinding="MONITORING@uixTableBundle@servletRequest" 
                          renderedBinding="monitoringAvailable@objectBean@servletRequest" />
       <uix:switcher childNameBinding="monitoring@objectBean@servletRequest">
         <uix:case name="true">
           <uix:styledText styleClass="OraDataText"
                           textBinding="ENABLED@uixDBObjectBundle@servletRequest" 
                           renderedBinding="monitoringAvailable@objectBean@servletRequest" />
         </uix:case>
         <uix:case name="false">
           <uix:styledText styleClass="OraDataText"
                           textBinding="DISABLED@uixDBObjectBundle@servletRequest" 
                           renderedBinding="monitoringAvailable@objectBean@servletRequest" />
         </uix:case>
       </uix:switcher>

  </uix:labeledFieldLayout>
  </uix:header>




  <%-- IOT --%>
  <uix:header textBinding="IOT_PROPERTIES@uixDBObjectBundle@servletRequest"
              renderedBinding="organizationIOT@objectBean@servletRequest">
  <uix:labeledFieldLayout>

    <%-- Parallel Degree --%>
    <uix:messagePrompt promptBinding="COMPRESS@uixDBObjectBundle@servletRequest" />
    <uix:switcher childNameBinding="compress@tableIOT@objectBean@servletRequest">
      <uix:case name="true">
        <uix:styledText styleClass="OraDataText"
                        textBinding="IOTCompress@tableIOT@objectBean@servletRequest" />
      </uix:case>
      <uix:case name="false">
        <uix:styledText styleClass="OraDataText"
                        textBinding="DEFAULT_NONE@uixSchemaBundle@servletRequest" />
      </uix:case>
    </uix:switcher>

    <%-- Use Mapping --%>
    <uix:messagePrompt promptBinding="MAPPING_TABLE@uixSchemaBundle@servletRequest" 
                       renderedBinding="versionEqualOrHigher90@objectBean@servletRequest"/>
    <uix:styledText styleClass="OraDataText"
                    textBinding="useMappingTable@tableIOT@objectBean@servletRequest" 
                    renderedBinding="versionEqualOrHigher90@objectBean@servletRequest" />

    <%-- Use Overflow Segment--%>
    <uix:messagePrompt promptBinding="USE_OVERFLOW_DATA_SEGMENT@uixDBObjectBundle@servletRequest" />
    <uix:styledText styleClass="OraDataText"
                    textBinding="overflow@tableIOT@objectBean@servletRequest" />

    <%-- Threshold --%>
    <uix:messagePrompt promptBinding="PERCENT_THRESHOLD@uixDBObjectBundle@servletRequest" 
                       renderedBinding="overflow@tableIOT@objectBean@servletRequest" />
    <uix:styledText styleClass="OraDataText"
                    textBinding="pctThreshold@tableIOT@objectBean@servletRequest" 
                    renderedBinding="overflow@tableIOT@objectBean@servletRequest" />

    <%-- Including Column --%>
    <uix:messagePrompt promptBinding="INCLUDING_COLUMN@uixDBObjectBundle@servletRequest" 
                       renderedBinding="overflow@tableIOT@objectBean@servletRequest" />
    <uix:styledText styleClass="OraDataText"
                    textBinding="includingCol@tableIOT@objectBean@servletRequest" 
                    renderedBinding="overflow@tableIOT@objectBean@servletRequest" />

    <%-- Tablespace --%>
    <uix:messagePrompt promptBinding="TABLESPACE@uixDBObjectBundle@servletRequest" 
                       renderedBinding="overflow@tableIOT@objectBean@servletRequest" />
    <uix:styledText styleClass="OraDataText"
                    textBinding="overflowTablespace@tableIOT@objectBean@servletRequest"
                    renderedBinding="overflow@tableIOT@objectBean@servletRequest" />

  </uix:labeledFieldLayout>
  </uix:header> 




  <%-- Statistics Page --%>
  <uix:header textBinding="STATS@msgs" renderedBinding="showStatsTab@objectBean@servletRequest">
    <jsp:include page="/database/schema/table/statsInclude.jsp" />
    <uix:ref refID="statsInclude" />
  </uix:header>



  <%-- END: TABLE VIEW PAGE ends here --%>   
        
  <%-- Table Buttons --%>
  <uix:pageButtons>
  <uix:pageButtonBar>
    <uix:switcher childNameBinding="xmlInitialized@objectBean@servletRequest">
      <uix:case name="false">
       <jsp:include page="/database/schema/pageButtonViewInclude.jsp" />
       <uix:ref refID="pageButtonViewInclude" />
      </uix:case>
      <uix:case name="true">
       <%-- OK Button --%>			
       <%@ include file="/database/changemgr/cmEMOViewPageButtons.jspf" %>
      </uix:case>
    </uix:switcher>
  </uix:pageButtonBar>
  </uix:pageButtons>

</uix:pageLayout>
</db:form>
<%-- END: HTML Form --%>

</uix:document>
</uix:renderingContext>
<%-- END: Content --%>
