<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        samplePage.jsp
  -- Controller:  db/adm/schm/SampleController.java
  --
  -- Description: Short Description of the page.
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>
<db:script src="/database/LOV.js"/>
<db:script src="/database/utils.js"/>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>

<uix:renderingContext id="renderingContext">
<uix:bundle name="dbMsgs"
            class="oracle.sysman.db.rsc.DBObjectMsg"/>
<uix:bundle name="tblTypeMsgs"
            class="oracle.sysman.db.rsc.schm.TableTypeMsg"/>
<oem:setURLEncoder id="renderingContext"/>
<uix:document>
<%@ include file="/oemTitle.jspf" %>

<%-- HTML Page Title --%>
<uix:metaContainer>
  <uix:head titleBinding="title@objectBean@servletRequest"/>
</uix:metaContainer>
<uix:body>    

<%-- HTML Form --%>
<db:form name="foo" 
         method="post" 
         destinationBinding="destination@objectBean@servletRequest"
         copyParams="target,type,cancelURL,sname,oname,otype">
<uix:formValue name="pageName" value="/database/schema/tabletype/mainTableTypePage"/>
<uix:pageLayout titleBinding="header@objectBean@servletRequest">

  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/global.jspf" %>

  <%-- Warning/Error display --%>
  <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error" 
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>

    <%-- START: TAB CONTENTS starts here --%>


              <uix:header textBinding="GENERAL@dbMsgs">

              <uix:contents>
                <uix:switcher childNameBinding="creatingObject@objectBean@servletRequest">
                <uix:case name="true">
                <%-- name --%>
                <uix:tableLayout cellSpacing="5">
                <uix:rowLayout>
                  <uix:contents>
                    <uix:cellFormat hAlign="right">
                      <uix:contents>
                        <uix:messagePrompt labeledNodeId="NAME" promptBinding="NAME@dbMsgs" required="yes"/>
                      </uix:contents>
                    </uix:cellFormat>
                    <uix:cellFormat>
                      <uix:stackLayout>
                        <uix:contents>
                          <uix:textInput id="NAME" name="objectName" textBinding="objectName@objectBean@servletRequest" columns="30"/>
                          <uix:messageText messageBinding="objectName@errors@servletRequest" messageType="error"/>
                        </uix:contents>
                      </uix:stackLayout>
                    </uix:cellFormat>
                  </uix:contents>
                </uix:rowLayout>
                <%-- schema name --%>
                <uix:rowLayout>
                  <uix:contents>
                    <uix:cellFormat hAlign="right">
                      <uix:contents>
                        <uix:messagePrompt labeledNodeId="SCHEMA" promptBinding="SCHEMA@dbMsgs" required="yes"/>
                      </uix:contents>
                    </uix:cellFormat>
                    <uix:cellFormat>
                      <uix:stackLayout>
                        <uix:contents>
                          <uix:lovField name="schemaName" 
                                        id="SCHEMA"
                                        shortDescBinding="SCHEMA@dbMsgs"
                                        searchDescBinding="SCHEMA@dbMsgs"
                                        textBinding="schemaName@objectBean@servletRequest" 
                                        onClick="startLov('schemaName','ListSchema')"/>
                          <uix:messageText messageBinding="schemaName@errors@servletRequest" messageType="error"/>
                        </uix:contents>
                      </uix:stackLayout>
                    </uix:cellFormat>
                  </uix:contents>
                </uix:rowLayout>
                 </uix:tableLayout>
                </uix:case> 
                <uix:case name="false">

                <%-- name --%>
                <uix:tableLayout cellSpacing="5">
                <uix:rowLayout>
                  <uix:contents>
                    <uix:cellFormat hAlign="right">
                      <uix:contents>
                        <uix:messagePrompt promptBinding="NAME@dbMsgs"/>
                      </uix:contents>
                    </uix:cellFormat>
                    <uix:cellFormat>
                     <uix:styledText styleClass="OraDataText" textBinding="objectName@objectBean@servletRequest"/>
                    </uix:cellFormat>
                  </uix:contents>
                </uix:rowLayout>
                <%-- schema name --%>
                <uix:rowLayout>
                    <uix:cellFormat hAlign="right">
                      <uix:contents>
                        <uix:messagePrompt promptBinding="SCHEMA@dbMsgs"/>
                      </uix:contents>
                    </uix:cellFormat>
                    <uix:cellFormat>
                     <uix:styledText styleClass="OraDataText" textBinding="schemaName@objectBean@servletRequest"/>
                    </uix:cellFormat>
                </uix:rowLayout>
               </uix:tableLayout>

                </uix:case>
                </uix:switcher>
               

             <uix:rowLayout hAlign="right">
                <uix:switcher childNameBinding="areErrors@objectBean@servletRequest">
                <uix:case name="true">             
                  <uix:rowLayout hAlign="right">
                    <uix:submitButton textBinding="SHOW_ERRORS@dbMsgs"
                        name="event" value="showErrors"/>   
                  </uix:rowLayout>
                </uix:case>
                </uix:switcher>
            </uix:rowLayout>

          
           </uix:contents>
           </uix:header>

            <uix:header textBinding="DATATYPE@tblTypeMsgs">
						<uix:tableLayout cellSpacing="5">
            	<uix:contents>
               

              <%-- predefined types--%>
                <uix:rowLayout>
                  <uix:contents>
                     <oem:radioButton
                    	name="userType" value="false"
                      textBinding="CHOOSE_PREDEF_TYPE@tblTypeMsgs"
                      selectedValueBinding="userType@objectBean@servletRequest"/>
                  </uix:contents>
                </uix:rowLayout>

              </uix:contents>
            </uix:tableLayout>
            <uix:tableLayout cellSpacing="5">
              <uix:contents>

              <%-- type name --%>
                <uix:rowLayout>
                  <uix:contents>
                    <uix:cellFormat width="20">
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="right">
                      <uix:contents>
                        <uix:messagePrompt labeledNodeId="TYPE" promptBinding="TYPE@tblTypeMsgs"/>
                      </uix:contents>
                    </uix:cellFormat>
                    <uix:cellFormat>
                     <uix:contents>
                      <oem:choice name="typeName"
                           id="TYPE"
                           selectedValueBinding="typeName@objectBean@servletRequest" optionsBinding="predefinedTypes@objectBean@servletRequest"/> 
                     </uix:contents>
                    </uix:cellFormat>
                  </uix:contents>
                </uix:rowLayout>


 							  <%-- type length --%>

                <uix:rowLayout>
                  <uix:contents>
                    <uix:cellFormat width="20">
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="right">
                      <uix:contents>
                        <uix:messagePrompt labeledNodeId="LENGTH" prompt="true" promptBinding="LENGTH@tblTypeMsgs"/>
                      </uix:contents>
                    </uix:cellFormat>
                    <uix:cellFormat>
                    <uix:contents>
                    <uix:stackLayout>
                     <uix:contents>
                      <uix:textInput name="typeLength" 
                                     id="LENGTH"
                                     textBinding="typeLength@objectBean@servletRequest"
                                     columns="30"/>
                      <uix:styledText styleClass="OraInlineInfoText"  textBinding="APPLIES_LENGTH@tblTypeMsgs"/>
                     </uix:contents>
                    </uix:stackLayout>
                    </uix:contents>
                    </uix:cellFormat>
                    <uix:cellFormat>
                    <uix:messageText messageBinding="typeLength@errors@servletRequest" messageType="error"/>
                    </uix:cellFormat>
                  </uix:contents> 
                </uix:rowLayout>

                
                  <%-- precision --%>
                <uix:rowLayout>
                  <uix:contents>
 		    <uix:cellFormat width="20">
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="left">
                      <uix:contents>
                        <uix:messagePrompt labeledNodeId="PRECISION" promptBinding="PRECISION@tblTypeMsgs"/>
                      </uix:contents>
                    </uix:cellFormat>
                    <uix:cellFormat>
                    <uix:contents>
                    <uix:stackLayout>
                     <uix:contents>
                      <uix:textInput name="typePrecision"  
                                     id="PRECISION"
                                     textBinding="typePrecision@objectBean@servletRequest"
                                     columns="30"/>
                      <uix:styledText styleClass="OraInlineInfoText" textBinding="APPLIES_NUMBER@tblTypeMsgs"/>
                    </uix:contents>
                   </uix:stackLayout>
                   </uix:contents>
                   </uix:cellFormat>
                   <uix:cellFormat>
                  <uix:messageText messageBinding="typePrecision@errors@servletRequest" messageType="error"/>
                  </uix:cellFormat>
                  </uix:contents>
                </uix:rowLayout>
         
              </uix:contents>
            </uix:tableLayout>
            <uix:tableLayout cellSpacing="5">
              <uix:contents>
              <%-- user types--%>
                <uix:rowLayout>
                  <uix:contents>
                     <oem:radioButton 
                    	name="userType" value="true"
                      textBinding="CHOOSE_USER_TYPE@tblTypeMsgs"
                      selectedValueBinding="userType@objectBean@servletRequest"/>
                  </uix:contents>
                </uix:rowLayout>

              </uix:contents>
            </uix:tableLayout>
            <uix:tableLayout cellSpacing="5">
              <uix:contents>

                 <%-- type name --%>
                <uix:rowLayout>
                  <uix:contents>
                    <uix:cellFormat width="20">
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="right"> 
                      <uix:messagePrompt labeledNodeId="USERTYPE" promptBinding="TYPE@tblTypeMsgs"/>
                    </uix:cellFormat>
                    <uix:cellFormat>
                      <uix:stackLayout>
                        <uix:contents>
                      
                          <uix:formValue name="schemaName" valueBinding="schemaName@objectBean@servletRequest"/>

                          <uix:lovField name="fullObjectName" 
                                 id="USERTYPE"
                                 shortDescBinding="TYPE@tblTypeMsgs"
                                 searchDescBinding="TYPE@tblTypeMsgs"
                                 textBinding="fullObjectName@objectBean@servletRequest" 
                                 onClick="setSearchFilter('schemaName');startLov('fullObjectName','ListObjecttype')"/>
                          <uix:messageText messageBinding="schemaName@errors@servletRequest" messageType="error"/>
                        </uix:contents>
                      </uix:stackLayout>
                    </uix:cellFormat>
                  </uix:contents>
                </uix:rowLayout>

              <%-- ref --%>
                <uix:rowLayout>
            	 <uix:contents>
 		            <uix:cellFormat width="20">
                    </uix:cellFormat>
                  <uix:cellFormat hAlign="right">
               	  <uix:checkBox name="typeRef" 
                                shortDescBinding="TYPE_REF@tblTypeMsgs"
                                checkedBinding="typeRef@objectBean@servletRequest"/>
                  </uix:cellFormat>
                  <uix:cellFormat>
                   <uix:contents>
                    <uix:messagePrompt promptBinding="TYPE_REF@tblTypeMsgs"/>
                   </uix:contents>
                  </uix:cellFormat>
                 </uix:contents>
                </uix:rowLayout>


              </uix:contents>
            </uix:tableLayout>
            
            
            </uix:header>
           
              


    <%-- END: TAB CONTENTS ends here --%>   
        

  <%-- Create/Edit Buttons --%>
  <uix:pageButtons>
  <uix:pageButtonBar>
    <jsp:include page="/database/schema/pageButtonInclude.jsp" />
    <uix:ref refID="pageButtonInclude" />
  </uix:pageButtonBar>
  </uix:pageButtons>

</uix:pageLayout>
</db:form>
<%-- END: HTML Form --%>
</uix:body>
</uix:document>
</uix:renderingContext>
<%-- END: Content --%> 




