<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        samplePage.jsp
  -- Controller:  db/adm/schm/SampleController.java
  --
  -- Description: Short Description of the page.
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>
<uix:document>
<%@ include file="/oemTitle.jspf" %>

<%-- HTML Page Title --%>
<uix:metaContainer>
  <uix:head titleBinding="title@objectBean@servletRequest"/>
</uix:metaContainer>
<uix:body>    

<%-- HTML Form --%>
<db:form name="foo"
         method="post" 
         destinationBinding="destination@objectBean@servletRequest"
         copyParams="target,type,cancelURL,sname,oname,otype" >
<uix:formValue name="pageName" value="/database/schema/tabletype/viewTableTypePage"/>
<uix:pageLayout titleBinding="header@objectBean@servletRequest">

  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/global.jspf" %>

  <%-- Warning/Error display --%>
  <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error" 
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>

    <%-- START: TAB CONTENTS starts here --%>

            <uix:header textBinding="GENERAL@uixDBObjectBundle@servletRequest">
              <uix:tableLayout cellSpacing="5">
                  <%-- name --%>
                  <uix:rowLayout>
                      <uix:cellFormat hAlign="right">
                          <uix:messagePrompt promptBinding="NAME@uixDBObjectBundle@servletRequest"/>
                      </uix:cellFormat>
                      <uix:styledText styleClass="OraDataText" textBinding="objectName@objectBean@servletRequest"/>
                  </uix:rowLayout>
                  <%-- schema name --%>
                  <uix:rowLayout>
                      <uix:cellFormat hAlign="right">
                          <uix:messagePrompt promptBinding="SCHEMA@uixDBObjectBundle@servletRequest"/>
                      </uix:cellFormat>
                      <uix:styledText styleClass="OraDataText" textBinding="schemaName@objectBean@servletRequest"/>
                  </uix:rowLayout>
              </uix:tableLayout>
            </uix:header>
            
            <uix:header textBinding="DATATYPE@uixTabletypeBundle@servletRequest">
              <uix:tableLayout cellSpacing="5">
                  <%-- user defined types--%>
                      <%-- TYPE --%>
                      <uix:rowLayout renderedBinding="userType@objectBean@servletRequest">
                          <uix:messagePrompt promptBinding="TYPE@uixTabletypeBundle@servletRequest"/>
                          <uix:spacer width="5"/>
                          <uix:styledText styleClass="OraDataText" textBinding="fullObjectName@objectBean@servletRequest"/>
                      </uix:rowLayout>
                       <%-- space --%>
                      <uix:rowLayout renderedBinding="userType@objectBean@servletRequest">
                          <uix:spacer height="5"/>
                      </uix:rowLayout>
                      <%-- REF --%>
                          <uix:rowLayout renderedBinding="typeRef@objectBean@servletRequest">
                              <uix:messagePrompt promptBinding="TYPE_REF@uixTabletypeBundle@servletRequest"/>
                          </uix:rowLayout>

                     <uix:rowLayout renderedBinding="noneUserType@objectBean@servletRequest">
                          <uix:cellFormat hAlign="right">
                            <uix:messagePrompt promptBinding="TYPE@uixTabletypeBundle@servletRequest"/>
                          </uix:cellFormat>
                          <uix:styledText styleClass="OraDataText" textBinding="typeName@objectBean@servletRequest"/>
                      </uix:rowLayout>
                      <%-- type length --%>
                      <uix:switcher childNameBinding="lengthType@objectBean@servletRequest">
                        <uix:case name="true">
                          <uix:rowLayout>
                              <uix:cellFormat hAlign="right">
                                <uix:messagePrompt promptBinding="LENGTH@uixTabletypeBundle@servletRequest"/>
                              </uix:cellFormat>
                              <uix:styledText styleClass="OraDataText" textBinding="typeLength@objectBean@servletRequest"/>
                          </uix:rowLayout>
                        </uix:case>
                      </uix:switcher>
                      <%-- precision --%>
                      <uix:switcher childNameBinding="precisionType@objectBean@servletRequest">
                        <uix:case name="true">
                          <uix:rowLayout>
                              <uix:cellFormat hAlign="right">
                                <uix:messagePrompt promptBinding="PRECISION@uixTabletypeBundle@servletRequest"/>
                              </uix:cellFormat>
                              <uix:styledText styleClass="OraDataText" textBinding="typePrecision@objectBean@servletRequest"/>
                          </uix:rowLayout>
                        </uix:case>
                      </uix:switcher>

                  
              </uix:tableLayout>
            </uix:header>


    <%-- END: TAB CONTENTS ends here --%>   
        

  <%-- Create/Edit Buttons --%>
  <uix:pageButtons>
  <uix:pageButtonBar>
    <jsp:include page="/database/schema/pageButtonViewInclude.jsp" />
    <uix:ref refID="pageButtonViewInclude" />
  </uix:pageButtonBar>
  </uix:pageButtons>

</uix:pageLayout>
</db:form>
<%-- END: HTML Form --%>
</uix:body>
</uix:document>
</uix:renderingContext>
<%-- END: Content --%> 




