<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        samplePage.jsp
  -- Controller:  db/adm/schm/SampleController.java
  --
  -- Description: Short Description of the page.
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>
<jsp:useBean id="objectBean" scope="request"
   type="oracle.sysman.emo.adm.schema.srctype.trigger.Trigger"/>

<db:script src="/database/utils.js"/>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>

<uix:renderingContext id="renderingContext">
  <uix:bundle name="dbMsgs"
              class="oracle.sysman.db.rsc.DBObjectMsg"/>
<oem:setURLEncoder id="renderingContext"/>
<uix:document>
  
<%-- HTML Page Title --%>
<uix:metaContainer>
  <uix:head titleBinding="title@objectBean@servletRequest"/>
</uix:metaContainer>
<uix:body>

<%-- HTML Form --%>
<db:form name="foo"
         method="post" 
         destinationBinding="destination@objectBean@servletRequest"
         copyParams="target,type,cancelURL,sname,oname,otype" >
<uix:formValue name="pageName" value="/database/schema/trigger/triggerAdvancedPage"/>
<uix:formValue name="source" />
<uix:formValue name="value" />
<uix:pageLayout titleBinding="header@objectBean@servletRequest">

  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/global.jspf" %>

  <%-- Warning/Error display --%>
  <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error" 
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>

  <%-- Create/Edit/View Header --%>
  <uix:subTabLayout>
    
    <%-- SubTabs --%>
    <uix:subTabs>
                <uix:switcher childNameBinding="tableOrViewObjType@objectBean@servletRequest">
                  <uix:case name="true">
                    <uix:subTabBar selectedIndex="2">
                      <uix:contents>
                        <db:link textBinding="GENERAL@dbMsgs"
                                 onClick="submitForm('foo', true, {event:'gotoValue1'})"
                                 copyParams="target,type,cancelURL,sname,oname,otype" />
                        <db:link textBinding="EVENT@dbMsgs"
                                 onClick="submitForm('foo', true, {event:'gotoValue2'})"
                                 copyParams="target,type,cancelURL,sname,oname,otype" />
                        <db:link textBinding="ADVANCED@dbMsgs"
                                 copyParams="target,type,cancelURL,sname,oname,otype" />
                      </uix:contents>
                    </uix:subTabBar>
                  </uix:case>
                  <uix:case name="false">
                    <uix:subTabBar selectedIndex="2">
                      <uix:contents>
                        <db:link textBinding="GENERAL@dbMsgs"
                                 onClick="submitForm('foo', true, {event:'gotoValue1'})"
                                 copyParams="target,type,cancelURL,sname,oname,otype" />
                        <db:link textBinding="EVENT@dbMsgs"
                                 onClick="submitForm('foo', true, {event:'gotoValue2'})"
                                 copyParams="target,type,cancelURL,sname,oname,otype" />
                        <db:link textBinding="ADVANCED@dbMsgs"
                                 copyParams="target,type,cancelURL,sname,oname,otype" />
                      </uix:contents>
                    </uix:subTabBar>
                  </uix:case>
                </uix:switcher>
    </uix:subTabs>

    <%-- START: TAB CONTENTS starts here --%>

            <uix:stackLayout>
              <uix:spacer height="10"/>
              <uix:rowLayout>
                <uix:checkBox name="forEachRow" 
                              textBinding="TRIGGER_FOR_EACH_ROW@uixTriggerBundle@servletRequest" 
                              checkedBinding="forEachRow@objectBean@servletRequest"/>
<%--
                <uix:spacer width="8"/>
                <uix:submitButton textBinding="GO@uixDBObjectBundle@servletRequest"
                              name="event" value="triggerForRow"/>
--%>
              </uix:rowLayout>

<%--
              <uix:switcher childNameBinding="forEachRow">
                <uix:case name="true">
--%>
              <uix:tableLayout cellSpacing="5">
              <uix:rowLayout>
                <uix:cellFormat width="5"> 
                </uix:cellFormat> 
                <uix:cellFormat>
              <uix:header textBinding="REFERENCING@uixTriggerBundle@servletRequest" 
                          size="1">
                <uix:tableLayout cellSpacing="5">
                <uix:rowLayout>
                  <uix:contents>
                    <uix:cellFormat>
                      <uix:contents>
                        <uix:messagePrompt labeledNodeId="oldRef"
                                           promptBinding="OLD_AS@uixTriggerBundle@servletRequest"/>
                      </uix:contents>
                    </uix:cellFormat>
                    <uix:textInput id="oldRef"
                                   name="oldRef" 
                                   textBinding="oldRef@objectBean@servletRequest"
                                   columns="60"/>
                  </uix:contents>
                </uix:rowLayout>
                <uix:rowLayout>
                  <uix:contents>
                    <uix:cellFormat>
                      <uix:contents>
                        <uix:messagePrompt labeledNodeId="newRef"
                                           promptBinding="NEW_AS@uixTriggerBundle@servletRequest"/>
                      </uix:contents>
                    </uix:cellFormat>
                    <uix:textInput id="newRef"
                                   name="newRef" 
                                   textBinding="newRef@objectBean@servletRequest"
                                   columns="60"/>
                  </uix:contents>
                </uix:rowLayout>
                </uix:tableLayout>
              </uix:header>
              <uix:switcher childNameBinding="objectType@objectBean@servletRequest">
                <uix:case name="TABLE">
                  <uix:header textBinding="CONDITION@uixTriggerBundle@servletRequest" size="1"> 
                    <uix:rowLayout>
                      <uix:contents>
                        <uix:textInput name="condition" 
                                       textBinding="condition@objectBean@servletRequest"
                                       columns="80" 
                                       rows="10"
                                       shortDescBinding="CONDITION@uixTriggerBundle@servletRequest"/>
                      </uix:contents>
                    </uix:rowLayout>
                  </uix:header>
                </uix:case>
              </uix:switcher>
              </uix:cellFormat>
              </uix:rowLayout>
              </uix:tableLayout>
<%--
             </uix:case>
             </uix:switcher>
--%>
            </uix:stackLayout>

    <%-- END: TAB CONTENTS ends here --%>   
        
  </uix:subTabLayout>  

  <%-- Create/Edit Buttons --%>
  <uix:pageButtons>
  <uix:pageButtonBar>
    <jsp:include page="/database/schema/pageButtonInclude.jsp" />
    <uix:ref refID="pageButtonInclude" />
  </uix:pageButtonBar>
  </uix:pageButtons>

</uix:pageLayout>
</db:form>
<%-- END: HTML Form --%>

</uix:body>
</uix:document>
</uix:renderingContext>
<%-- END: Content --%> 




