<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        samplePage.jsp
  -- Controller:  db/adm/schm/SampleController.java
  --
  -- Description: Short Description of the page.
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ page import="oracle.sysman.emo.adm.schema.srctype.trigger.Trigger" %>

<jsp:useBean id="objectBean" scope="request"
   type="oracle.sysman.emo.adm.schema.srctype.trigger.Trigger"/>

<db:script src="/database/LOV.js"/>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>

<uix:renderingContext id="renderingContext">
<uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>
<oem:setURLEncoder id="renderingContext"/>
<uix:document>
  
<%-- HTML Page Title --%>
<uix:metaContainer>
  <uix:head titleBinding="title@objectBean@servletRequest"/>
</uix:metaContainer>
<uix:body>

<%-- HTML Form --%>
<db:form name="foo" 
         method="post"
         destinationBinding="destination@objectBean@servletRequest"
         copyParams="target,type,cancelURL,sname,oname,otype" >
<uix:formValue name="pageName" value="/database/schema/trigger/triggerEventPage"/>
<uix:formValue name="schemaName" valueBinding="schemaName@objectBean@servletRequest"/>
<uix:formValue name="source" />
<uix:formValue name="value" />
<uix:pageLayout titleBinding="header@objectBean@servletRequest">

  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/global.jspf" %>

  <%-- Warning/Error display --%>
  <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error" 
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>

  <%-- Create/Edit/View Header --%>
  <uix:subTabLayout>
    
    <%-- SubTabs --%>
    <uix:subTabs>
           <uix:switcher childNameBinding="tableOrViewObjType@objectBean@servletRequest">
              <uix:case name="true">
                <uix:subTabBar selectedIndex="1">
                  <db:link textBinding="GENERAL@dbMsgs"
                           onClick="submitForm('foo', true, {event:'gotoValue1'})"
                           copyParams="target,type,cancelURL,sname,oname,otype" />
                  <db:link textBinding="EVENT@dbMsgs"
                           copyParams="target,type,cancelURL,sname,oname,otype" />
                  <db:link textBinding="ADVANCED@dbMsgs"
                           onClick="submitForm('foo', true, {event:'gotoValue3'})"
                           copyParams="target,type,cancelURL,sname,oname,otype" />
                </uix:subTabBar>
              </uix:case>
            
              <%-- schema or database--%>
              <uix:case name="false">
                <uix:subTabBar selectedIndex="1">
                  <db:link textBinding="GENERAL@dbMsgs"
                           onClick="submitForm('foo', true, {event:'gotoValue1'})"
                           copyParams="target,type,cancelURL,sname,oname,otype" />
                  <db:link textBinding="EVENT@dbMsgs"
                           copyParams="target,type,cancelURL,sname,oname,otype" />
                </uix:subTabBar>
              </uix:case>
            </uix:switcher>
    </uix:subTabs>

    <%-- START: TAB CONTENTS starts here --%>


      <uix:tableLayout cellSpacing="5">
        <uix:rowLayout>
          <uix:cellFormat hAlign="right" width="80">
            <uix:messagePrompt  
                               promptBinding="TRIGGER_ON@uixTriggerBundle@servletRequest"/>
          </uix:cellFormat>

            <uix:spacer width="5"/> 
              <uix:switcher childNameBinding="editing@objectBean@servletRequest">
                <uix:case name="true">
                  <uix:cellFormat> 
                    <uix:styledText styleClass="OraDataText" textBinding="objectType@objectBean@servletRequest"/>
                  </uix:cellFormat> 
                </uix:case>
                <uix:case name="false">
                  <uix:rowLayout>

                    <uix:choice name="objectType"
                                shortDescBinding="TRIGGER_ON@uixTriggerBundle@servletRequest"
                                onChange="submitForm('foo', true, {'event':'changeType'})"
                                selectedValueBinding="objectType@objectBean@servletRequest">
                      <!-- uix:contents childDataBinding="objectTypesMap@objectBean@servletRequest" -->
                        <!-- uix:option textBinding="textKey"
                                    valueBinding="valueKey"/-->
                      <!-- /uix:contents --> 
                      <uix:option textBinding="TABLE@dbMsgs"
                                  value="<%= Trigger.TABLE %>" />
                      <uix:option textBinding="VIEW_BUTTON@dbMsgs"
                                  value="<%= Trigger.VIEW %>" />
                      <uix:option textBinding="SCHEMA@dbMsgs"
                                  value="<%= Trigger.SCHEMA %>" />
                      <uix:option textBinding="DATABASE@dbMsgs"
                                  value="<%= Trigger.DATABASE %>" />
                    </uix:choice>

                    <uix:spacer width="5"/>
                  </uix:rowLayout>
                </uix:case>
              </uix:switcher> 
        </uix:rowLayout>

          <uix:spacer height="5"/>

          <uix:switcher childNameBinding="objectType@objectBean@servletRequest">
            <uix:case name="TABLE">
              <uix:tableLayout cellSpacing="5">
                <uix:rowLayout>
                  <uix:switcher childNameBinding="creating@objectBean@servletRequest">
                    <uix:case name="true">
                      <uix:tableLayout>
                        <uix:rowLayout>
                          <uix:cellFormat>
                            <uix:messagePrompt labeledNodeId="SCHEMA_TABLE"
                                               promptBinding="SCHEMA_TABLE_LABEL@dbMsgs"
                                               required="<%= objectBean.isRequired()%>"/>
  
                          </uix:cellFormat> 
                          <uix:spacer width="5"/>
                          <uix:cellFormat vAlign="top">
                            <uix:stackLayout>
                              <uix:lovField name="onSchemaAndObject"
                                            id="SCHEMA_TABLE"
                                            shortDescBinding="SCHEMA_TABLE_LABEL@dbMsgs"
                                            searchDescBinding="SCHEMA_TABLE_LABEL@dbMsgs"
                                            textBinding="onSchemaAndObject@objectBean@servletRequest" 
                                            columns="60"
                                            onClick="setSearchFilter('schemaName');startLov('onSchemaAndObject','ListSchemaTable')"/>
                              <uix:messageText messageBinding="onSchemaAndObject@errors@servletRequest" messageType="error"/>
                            </uix:stackLayout>
                          </uix:cellFormat>
                        </uix:rowLayout>
                      </uix:tableLayout>
                    </uix:case>
                    <uix:case name="false">
                      <uix:tableLayout cellSpacing="5">
                        <uix:rowLayout>
                          <uix:cellFormat hAlign="right" width="80">
                            <uix:messagePrompt labeledNodeId="schema"
                                               promptBinding="SCHEMA@dbMsgs"/>
                          </uix:cellFormat>
                          <uix:textInput id="schema"
                                         name="schema" 
                                         disabled="true" 
                                         columns="60" 
                                         textBinding="onSchema@objectBean@servletRequest"/>
                        </uix:rowLayout>
                        <uix:rowLayout>
                          <uix:cellFormat hAlign="right" width="80">
                            <uix:messagePrompt labeledNodeId="object"
                                               promptBinding="TABLE@dbMsgs"/>
                          </uix:cellFormat>
                          <uix:textInput id="object"
                                         name="object" 
                                         disabled="true" 
                                         columns="60" 
                                         textBinding="onObject@objectBean@servletRequest"/>
                        </uix:rowLayout>
	              </uix:tableLayout>
	            </uix:case>
                  </uix:switcher>
                  <uix:messageText messageBinding="changeSchemaAndObject@errors@servletRequest" messageType="error"/>
                </uix:rowLayout>
              </uix:tableLayout>
            </uix:case>
            <%-- end TABLE --%>

            <uix:case name="VIEW">
              <uix:tableLayout cellSpacing="5">
                <uix:rowLayout>
                  <uix:cellFormat> 
                    <uix:messagePrompt labeledNodeId="SCHEMA_VIEW" promptBinding="SCHEMA_VIEW_LABEL@dbMsgs"
                                       required="<%=objectBean.isRequired()%>"/>
                  </uix:cellFormat>
                  <uix:spacer width="5"/>
                  <uix:cellFormat>
                    <uix:stackLayout>
                      <uix:lovField name="onSchemaAndObject"
                                    id="SCHEMA_VIEW"
                                    shortDescBinding="SCHEMA_VIEW_LABEL@dbMsgs"
                                    searchDescBinding="SCHEMA_VIEW_LABEL@dbMsgs"
                                    textBinding="onSchemaAndObject@objectBean@servletRequest" 
                                    columns="30"
                                    onClick="setSearchFilter('schemaName');startLov('onSchemaAndObject','ListView')"/>
                      <uix:messageText messageBinding="onSchemaAndObject@errors@servletRequest" messageType="error"/>
                    </uix:stackLayout>
                  </uix:cellFormat>
                </uix:rowLayout>
              </uix:tableLayout> 
            </uix:case>

            <uix:case name="SCHEMA">
              <uix:tableLayout cellSpacing="5">
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right" width="80">
                    <uix:messagePrompt promptBinding="SCHEMA@dbMsgs"
                                       labeledNodeId="ON_SCHEMA"
                                       required="<%=objectBean.isRequired()%>"/>
                  </uix:cellFormat>
                  <uix:spacer width="5"/>
                  <uix:cellFormat>
                    <uix:stackLayout>
                      <uix:lovField name="onSchema"
                                    id="ON_SCHEMA"
                                    shortDescBinding="SCHEMA@dbMsgs"
                                    searchDescBinding="SCHEMA@dbMsgs"
                                    textBinding="onSchema@objectBean@servletRequest" columns="30"
                                    onClick="startLov('onSchema','ListSchema')"/>
                      <uix:messageText  messageBinding="onSchema@errors@servletRequest" messageType="error"/>
                    </uix:stackLayout>
                  </uix:cellFormat>
                </uix:rowLayout>
              </uix:tableLayout>
            </uix:case>
          </uix:switcher>

          <uix:switcher childNameBinding="objectType@objectBean@servletRequest">
            <uix:case name="TABLE">
              <uix:rowLayout>
                <uix:tableLayout cellSpacing="5">
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right" width="80">
                      <uix:messagePrompt promptBinding="FIRE_TRIGGER@uixTriggerBundle@servletRequest"/>
                    </uix:cellFormat>
          
                    <oem:radioButton name="beforeAfterInsteadof" value="0" textBinding="BEFORE@uixTriggerBundle@servletRequest" 
		                     shortDescBinding="BEFORE@uixTriggerBundle@servletRequest"
		                     selectedValueBinding="beforeAfterInsteadof@objectBean@servletRequest"/>
                    <oem:radioButton name="beforeAfterInsteadof" value="1" textBinding="AFTER@uixTriggerBundle@servletRequest" 
		                     shortDescBinding="AFTER@uixTriggerBundle@servletRequest"
		                     selectedValueBinding="beforeAfterInsteadof@objectBean@servletRequest"/>
                  </uix:rowLayout>
                </uix:tableLayout>
              </uix:rowLayout>
            </uix:case>
          </uix:switcher>

          <uix:switcher childNameBinding="schemaOrDatabaseObjType@objectBean@servletRequest">
            <uix:case name="true">
                <uix:tableLayout cellSpacing="5">
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right" width="80">
                      <uix:messagePrompt promptBinding="FIRE_TRIGGER@uixTriggerBundle@servletRequest"/>
                    </uix:cellFormat>
                    <oem:radioButton name="beforeAfterInsteadof" value="0" textBinding="BEFORE@uixTriggerBundle@servletRequest"
		                     shortDescBinding="BEFORE@uixTriggerBundle@servletRequest"
                                     onClick="submitForm('foo', true, {'event':'changeBeforeAfterInsteadof'})"
		                     selectedValueBinding="beforeAfterInsteadof@objectBean@servletRequest"/>
                    <oem:radioButton name="beforeAfterInsteadof" value="1" textBinding="AFTER@uixTriggerBundle@servletRequest"
		                     shortDescBinding="AFTER@uixTriggerBundle@servletRequest"
                                     onClick="submitForm('foo', true, {'event':'changeBeforeAfterInsteadof'})"
		                     selectedValueBinding="beforeAfterInsteadof@objectBean@servletRequest"/>
                  </uix:rowLayout>
                </uix:tableLayout>
            </uix:case>
          </uix:switcher>

          <uix:switcher childNameBinding="objectType@objectBean@servletRequest">
            <uix:case name="TABLE">
              <uix:rowLayout>
                <uix:tableLayout cellSpacing="5">
                  <uix:rowLayout>
                    <uix:cellFormat vAlign="top" hAlign="right" width="80">
                      <uix:messagePrompt promptBinding="EVENT@uixTriggerBundle@servletRequest"/>
                    </uix:cellFormat>
                    <uix:cellFormat vAlign="top" >
                      <uix:rowLayout>
                        <uix:checkBox name="insert" value="true" textBinding="INSERT@uixTriggerBundle@servletRequest" 
                                      checkedBinding="insert@objectBean@servletRequest"/>
                      </uix:rowLayout>
                      <uix:rowLayout>
                        <uix:checkBox name="delete" value="true" textBinding="DELETE@uixTriggerBundle@servletRequest" 
                                      checkedBinding="delete@objectBean@servletRequest"/>
                      </uix:rowLayout>
                      <uix:rowLayout>
                        <uix:checkBox name="update" value="true" textBinding="UPDATE_OF_COLUMNS@uixTriggerBundle@servletRequest" 
                                      onClick="submitForm('foo', true, {'event':'changeUpdate'})"
                                      checkedBinding="update@objectBean@servletRequest"/>
                        <!-- uix:spacer width="5"/ -->
                        <!-- uix:submitButton text="Go" name="event" value="changeUpdate"/-->
                      </uix:rowLayout>
                    </uix:cellFormat>
                  </uix:rowLayout>
                </uix:tableLayout>
              </uix:rowLayout>
            </uix:case>

            <uix:case name="VIEW">
              <uix:rowLayout>
                <uix:tableLayout cellSpacing="5">
                  <uix:rowLayout>
                    <uix:cellFormat vAlign="top" hAlign="right">
                      <uix:messagePrompt promptBinding="FIRE_TRIGGER_ON_EVENT@uixTriggerBundle@servletRequest" 
                                         required="<%=objectBean.isRequired()%>"/>
                    </uix:cellFormat>
                    <uix:cellFormat vAlign="top" >
                      <uix:stackLayout>
                        <uix:checkBox name="insert" value="true"
                                      textBinding="INSERT@uixTriggerBundle@servletRequest" checkedBinding="insert@objectBean@servletRequest"/>
                        <uix:checkBox name="delete" value="true"
                                      textBinding="DELETE@uixTriggerBundle@servletRequest" checkedBinding="delete@objectBean@servletRequest"/>
                        <uix:checkBox name="update" value="true"
                                      textBinding="UPDATE@uixTriggerBundle@servletRequest" checkedBinding="update@objectBean@servletRequest"/>
                        <uix:messageText messageBinding="fireTrigger@errors@servletRequest" messageType="error"/>
                      </uix:stackLayout>
                    </uix:cellFormat> 
                  </uix:rowLayout>
                </uix:tableLayout>
              </uix:rowLayout>
            </uix:case>
          </uix:switcher>

          <uix:switcher childNameBinding="update@objectBean@servletRequest">
            <uix:case name="true">
              <uix:switcher childNameBinding="objectType@objectBean@servletRequest">
                <uix:case name="TABLE">
                  <uix:rowLayout>
                    <uix:tableLayout >
                      <uix:rowLayout width="100%">
                        <uix:cellFormat width="90">
                        </uix:cellFormat>
                        <oem:table name="fireTriggerOnUpdColumnUI" 
                                   beanKey="objectBean"
                                   formSubmitted="true"
                                   dataSourceProp="fireTriggerOnUpdColumnUI" blockSize="25"
                                   alternateTextBinding="NO_ITEMS_FOUND@dbMsgs"
                                   summaryBinding="UPDATE@uixTriggerBundle@servletRequest"
                                   copyParams="target,type,cancelURL,sname,oname,otype" />
                      </uix:rowLayout>
                    </uix:tableLayout>
                  </uix:rowLayout>
                </uix:case>
              </uix:switcher>
            </uix:case>
          </uix:switcher>

          <uix:switcher childNameBinding="schemaOrDatabaseObjType@objectBean@servletRequest">
            <uix:case name="true">
                <uix:tableLayout >
                  <uix:rowLayout width="100%">
                    <uix:cellFormat width="80">
                    </uix:cellFormat>
                    <uix:messageText messageBinding="triggerEvent@errors@servletRequest" messageType="error"/>
                  </uix:rowLayout>
                  <uix:rowLayout width="100%">
                    <uix:cellFormat width="90">
                    </uix:cellFormat>
                    <oem:table name="fireTriggerEventUI" 
                               beanKey="objectBean"
                               destinationBinding="destination@objectBean@servletRequest" formSubmitted="true"
                               dataSourceProp="fireTriggerEventUI" width="100%" blockSize="25"
                               alternateTextBinding="NO_ITEMS_FOUND@dbMsgs"
                               summaryBinding="FIRE_TRIGGER_ON_EVENT@uixTriggerBundle@servletRequest"
                               copyParams="target,type,cancelURL,sname,oname,otype" />
                  </uix:rowLayout>
                </uix:tableLayout>
            </uix:case>
          </uix:switcher>
        </uix:tableLayout>


    <%-- END: TAB CONTENTS ends here --%>   
        
  </uix:subTabLayout>  

  <%-- Create/Edit Buttons --%>
  <uix:pageButtons>
  <uix:pageButtonBar>
    <jsp:include page="/database/schema/pageButtonInclude.jsp" />
    <uix:ref refID="pageButtonInclude" />
  </uix:pageButtonBar>
  </uix:pageButtons>

</uix:pageLayout>
</db:form>
<%-- END: HTML Form --%>

</uix:body>
</uix:document>
</uix:renderingContext>
<%-- END: Content --%> 




