<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        samplePage.jsp
  -- Controller:  db/adm/schm/SampleController.java
  --
  -- Description: Short Description of the page.
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>
<jsp:useBean id="objectBean" scope="request"
   type="oracle.sysman.emo.adm.schema.srctype.trigger.Trigger"/>

<db:script src="/database/LOV.js"/>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>

<uix:renderingContext id="renderingContext">
<uix:bundle name="dbMsgs"
            class="oracle.sysman.db.rsc.DBObjectMsg"/>
<oem:setURLEncoder id="renderingContext"/>
<uix:document>
  
<%-- HTML Page Title --%>
<uix:metaContainer>
  <uix:head titleBinding="title@objectBean@servletRequest"/>
</uix:metaContainer>
<uix:body>

<%-- HTML Form --%>
<db:form name="foo" 
         method="post"
         destinationBinding="destination@objectBean@servletRequest"
         copyParams="target,type,cancelURL,sname,oname,otype" >
<uix:formValue name="pageName" value="/database/schema/trigger/triggerGeneralPage"/>
<uix:formValue name="source" />
<uix:formValue name="value" />
<uix:pageLayout titleBinding="header@objectBean@servletRequest">

  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/global.jspf" %>

  <%-- Warning/Error display --%>
  <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error" 
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>

  <%-- Create/Edit/View Header --%>
  <uix:subTabLayout>
    
    <%-- SubTabs --%>
    <uix:subTabs>
       <uix:switcher childNameBinding="tableOrViewObjType@objectBean@servletRequest">
          <uix:case name="true">
            <uix:subTabBar selectedIndex="0">
              <db:link textBinding="GENERAL@dbMsgs"
                       copyParams="target,type,cancelURL,sname,oname,otype" />
              <db:link textBinding="EVENT@dbMsgs"  
                       onClick="submitForm('foo', true, {event:'gotoValue2'})"
                       copyParams="target,type,cancelURL,sname,oname,otype" />
              <db:link textBinding="ADVANCED@dbMsgs" 
                       onClick="submitForm('foo', true, {event:'gotoValue3'})"
                       copyParams="target,type,cancelURL,sname,oname,otype" />
            </uix:subTabBar>
          </uix:case>
          <uix:case name="false">
            <uix:subTabBar selectedIndex="0">
              <db:link textBinding="GENERAL@dbMsgs"
                       copyParams="target,type,cancelURL,sname,oname,otype" />
              <db:link textBinding="EVENT@dbMsgs" 
                       onClick="submitForm('foo', true, {event:'gotoValue2'})"
                       copyParams="target,type,cancelURL,sname,oname,otype" />
            </uix:subTabBar>
          </uix:case>
        </uix:switcher>
    </uix:subTabs>

    <%-- START: TAB CONTENTS starts here --%>

    <%-- General --%>
      <uix:tableLayout cellSpacing="5">

        <%-- Trigger Name --%>
        <uix:rowLayout>
          <uix:cellFormat hAlign="right" width="80" wrappingDisabled="true">
            <uix:messagePrompt labeledNodeId="triggerName"
                               required="<%= objectBean.isRequired()%>" 
                               promptBinding="NAME@dbMsgs"/>
          </uix:cellFormat>

          <uix:cellFormat vAlign="top"> 
            <uix:stackLayout>
              <uix:textInput id="triggerName"
                             name="triggerName"
                             shortDescBinding="NAME@dbMsgs"
                             textBinding="triggerName@objectBean@servletRequest" 
                             columns="60"/>
              <uix:messageText messageBinding="triggerName@errors@servletRequest" messageType="error"/>
            </uix:stackLayout>
          </uix:cellFormat>
        </uix:rowLayout>

        <%-- Schema Name --%>
        <uix:rowLayout>
          <uix:cellFormat hAlign="right" width="80" wrappingDisabled="true">
            <uix:messagePrompt labeledNodeId="schemaName"
                               required="<%= objectBean.isRequired()%>" 
                               promptBinding="SCHEMA@dbMsgs"/>
          </uix:cellFormat>

          <uix:cellFormat vAlign="top">
            <uix:switcher childNameBinding="creating@objectBean@servletRequest">
              <uix:case name="true">
                <uix:stackLayout>
                  <uix:lovField name="schemaName" 
                                shortDescBinding="SCHEMA@dbMsgs"
                                searchDescBinding="SCHEMA@dbMsgs"
                                textBinding="schemaName@objectBean@servletRequest" 
                                id="schemaName" 
                                onClick="startLov('schemaName','ListSchema')"/>
                  <uix:messageText messageBinding="Schema@errors@servletRequest" messageType="error"/>
                </uix:stackLayout>
              </uix:case>
              <uix:case name="false">
                <uix:textInput id="schemaName"
                               name="schemaName"
                               disabled="true" 
                               textBinding="schemaName@objectBean@servletRequest" 
                               columns="60"/>
              </uix:case>
            </uix:switcher>
          </uix:cellFormat>
        </uix:rowLayout>

        <uix:switcher childNameBinding="creating@objectBean@servletRequest">
          <uix:case name="false">
            <uix:rowLayout>
              <uix:cellFormat hAlign="right" width="80">
                <uix:messagePrompt promptBinding="STATUS@dbMsgs"/>
              </uix:cellFormat>
              <uix:styledText styleClass="OraDataText" textBinding="status@objectBean@servletRequest"/>
            </uix:rowLayout>
          </uix:case>
        </uix:switcher>
        <uix:switcher childNameBinding="creating@objectBean@servletRequest">
          <uix:case name="true">
            <uix:rowLayout>
              <uix:cellFormat hAlign="right">
                <uix:messagePrompt prompt=" "/>
              </uix:cellFormat>
              <uix:cellFormat> 
                <uix:checkBox name="replace" value="true" textBinding="REPLACE_IF_EXISTS@uixTriggerBundle@servletRequest" 
                              checkedBinding="replace@objectBean@servletRequest"/>
                <uix:checkBox name="enable" value="true" textBinding="ENABLE@uixTriggerBundle@servletRequest" 
                              checkedBinding="enable@objectBean@servletRequest"
                              disabled="true"/>
              </uix:cellFormat>
            </uix:rowLayout>
          </uix:case>
          <uix:case name="false">
            <uix:rowLayout>
              <uix:cellFormat hAlign="right">
                <uix:messagePrompt prompt=" "/>
              </uix:cellFormat>
              <uix:cellFormat> 
                <uix:checkBox name="replace" value="true" textBinding="REPLACE_IF_EXISTS@uixTriggerBundle@servletRequest" 
                              checkedBinding="replace@objectBean@servletRequest"
                              disabled="true"/>
                <uix:checkBox name="enable" value="true" textBinding="ENABLE@uixTriggerBundle@servletRequest"
                              checkedBinding="enable@objectBean@servletRequest"/>
              </uix:cellFormat>
            </uix:rowLayout>
          </uix:case>
        </uix:switcher>

        <%-- Trigger Body --%>
        <uix:rowLayout>
          <uix:cellFormat hAlign="right" vAlign="top" wrappingDisabled="true">
            <uix:messagePrompt labeledNodeId="triggerBody"
                               required="<%= objectBean.isRequired()%>"
                               promptBinding="TRIGGER_BODY@uixTriggerBundle@servletRequest"/>
          </uix:cellFormat>
          <uix:cellFormat vAlign="top">
            <uix:stackLayout>
              <uix:textInput id="triggerBody"
                             name="triggerBody"
                             shortDescBinding="TRIGGER_BODY@uixTriggerBundle@servletRequest"
                             textBinding="triggerBody@objectBean@servletRequest" 
                             columns="100" 
                             rows="10"/>
              <uix:messageText messageBinding="triggerBody@errors@servletRequest" messageType="error"/>
            </uix:stackLayout>
          </uix:cellFormat> 
        </uix:rowLayout>
        <uix:switcher childNameBinding="creating@objectBean@servletRequest">
          <uix:case name="false">
            <uix:rowLayout>
              <uix:messagePrompt prompt = " "/>
              <uix:cellFormat hAlign="right">
                <uix:submitButton textBinding="COMPILE@dbMsgs" name="event"
                      value="compile"/>
                <uix:spacer width="5"/>
                <uix:submitButton textBinding = "errorButtonName@objectBean@servletRequest" 
                                  name="event" value="showErrors"
                                  disabled="<%= objectBean.isValid() %>"/>
              </uix:cellFormat>
            </uix:rowLayout>
          </uix:case>
        </uix:switcher>
        <uix:switcher childName="<%= objectBean.getShowErrors() %>" >
          <uix:case name = "true">
            <uix:rowLayout>
              <uix:cellFormat hAlign="right" vAlign="top">
                <uix:messagePrompt labeledNodeId="errors"
                                   promptBinding="ERRORS@dbMsgs"/>
              </uix:cellFormat>
              <uix:textInput id="errors"
                             name="errors"
                             textBinding="errors@objectBean@servletRequest" 
                             columns="100" 
                             rows="5" 
                             readOnly="true"/>
            </uix:rowLayout>
          </uix:case>
        </uix:switcher>
      </uix:tableLayout>

    <%-- END: TAB CONTENTS ends here --%>   
        
  </uix:subTabLayout>  

  <%-- Create/Edit Buttons --%>
  <uix:pageButtons>
  <uix:pageButtonBar>
    <jsp:include page="/database/schema/pageButtonInclude.jsp" />
    <uix:ref refID="pageButtonInclude" />
  </uix:pageButtonBar>
  </uix:pageButtons>

</uix:pageLayout>
</db:form>
<%-- END: HTML Form --%>

</uix:body>
</uix:document>
</uix:renderingContext>
<%-- END: Content --%> 




