<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        samplePage.jsp
  -- Controller:  db/adm/schm/SampleController.java
  --
  -- Description: Short Description of the page.
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>

<uix:renderingContext id="renderingContext">
<uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>
<uix:bundle name="trigMsgs" class="oracle.sysman.db.rsc.schm.TriggerMsg"/>
<oem:setURLEncoder id="renderingContext"/>
<uix:document>
  
<%-- HTML Page Title --%>
<uix:metaContainer>
  <uix:head titleBinding="title@objectBean@servletRequest"/>
</uix:metaContainer>
<uix:body>

<%-- HTML Form --%>
<db:form name="foo"
         method="post" 
         destinationBinding="destination@objectBean@servletRequest" 
         copyParams="target,type,cancelURL,sname,oname,otype" >
<uix:formValue name="pageName" value="/database/schema/trigger/triggerViewPage"/>
<uix:pageLayout titleBinding="header@objectBean@servletRequest">

  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/global.jspf" %>

  <%-- Warning/Error display --%>
  <oem:messageBox messageType="info"
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error"
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>


    <%-- START: TAB CONTENTS starts here --%>


      <uix:tableLayout cellSpacing="5">

        <uix:rowLayout>
          <uix:cellFormat hAlign="right">
            <uix:messagePrompt promptBinding="NAME@uixDBObjectBundle@servletRequest"/>
          </uix:cellFormat>
          <uix:styledText 
                styleClass="OraDataText" textBinding="triggerName@objectBean@servletRequest"/>
        </uix:rowLayout>

        <uix:rowLayout>
          <uix:cellFormat hAlign="right">
            <uix:messagePrompt promptBinding="SCHEMA@uixDBObjectBundle@servletRequest"/>
          </uix:cellFormat>
          <uix:styledText styleClass="OraDataText" textBinding="schemaName@objectBean@servletRequest"/>
        </uix:rowLayout>

        <uix:switcher childNameBinding="xmlInitialized@objectBean@servletRequest">
          <uix:case name="false">
            <uix:rowLayout>
              <uix:cellFormat hAlign="right">
                <uix:messagePrompt promptBinding="STATUS@uixDBObjectBundle@servletRequest"/>
              </uix:cellFormat>
              <uix:styledText styleClass="OraDataText" textBinding="status@objectBean@servletRequest"/>
            </uix:rowLayout>
          </uix:case>
        </uix:switcher/>
    
        <uix:rowLayout>
          <uix:cellFormat hAlign="right">
            <uix:messagePrompt promptBinding="ENABLE@uixTriggerBundle@servletRequest"/>
          </uix:cellFormat>
          <uix:styledText styleClass="OraDataText" textBinding="enable@objectBean@servletRequest"/>
        </uix:rowLayout>

        <uix:rowLayout>
          <uix:cellFormat hAlign="right" vAlign="top">
            <uix:messagePrompt labeledNodeId="triggerBody"
                               promptBinding="TRIGGER_BODY@uixTriggerBundle@servletRequest"/>
          </uix:cellFormat>
            <uix:textInput id="triggerBody"
                           name="triggerBody"
                           textBinding="triggerBody@objectBean@servletRequest" 
                           columns="60" 
                           rows="10" 
                           readOnly="true"/>
        </uix:rowLayout>

        <uix:switcher childNameBinding="objectType@objectBean@servletRequest">
        <uix:case name="TABLE">
          <uix:rowLayout>
            <uix:cellFormat hAlign="right">
            <uix:messagePrompt promptBinding="TRIGGER_ON@uixTriggerBundle@servletRequest"/>
            </uix:cellFormat> 
            <uix:cellFormat hAlign="left">
              <uix:styledText styleClass="OraDataText" textBinding="ON_TABLE@trigMsgs"/>
              <uix:styledText styleClass="OraDataText" textBinding="onSchemaAndObject@objectBean@servletRequest" />
            </uix:cellFormat> 
          </uix:rowLayout>
        </uix:case>
        <uix:case name="VIEW">
          <uix:rowLayout>
            <uix:cellFormat hAlign="right">
              <uix:messagePrompt promptBinding="TRIGGER_ON@uixTriggerBundle@servletRequest"/>
            </uix:cellFormat> 
            <uix:cellFormat hAlign="left">
              <uix:styledText styleClass="OraDataText" textBinding="ON_VIEW@trigMsgs"/>
              <uix:styledText styleClass="OraDataText" textBinding="onSchemaAndObject@objectBean@servletRequest"/>
            </uix:cellFormat>
          </uix:rowLayout>
        </uix:case>
        <uix:case name="SCHEMA">
          <uix:rowLayout>
            <uix:cellFormat hAlign="right">
              <uix:messagePrompt promptBinding="TRIGGER_ON@uixTriggerBundle@servletRequest"/>
            </uix:cellFormat> 
            <uix:cellFormat hAlign="left">
              <uix:styledText styleClass="OraDataText" textBinding="ON_SCHEMA@trigMsgs"/>
              <uix:styledText styleClass="OraDataText" textBinding="onSchema@objectBean@servletRequest"/>
            </uix:cellFormat>
          </uix:rowLayout>
        </uix:case>
        <uix:case name="DATABASE">
          <uix:rowLayout>
            <uix:cellFormat hAlign="right">
              <uix:messagePrompt promptBinding="TRIGGER_ON@uixTriggerBundle@servletRequest"/>
            </uix:cellFormat> 
            <uix:cellFormat hAlign="left">
              <uix:styledText styleClass="OraDataText" textBinding="DATABASE@dbMsgs"/>
            </uix:cellFormat>
          </uix:rowLayout>
        </uix:case>
      </uix:switcher>

      <uix:rowLayout>
        <uix:cellFormat hAlign="right" vAlign="top">
          <uix:messagePrompt promptBinding="WHEN@uixTriggerBundle@servletRequest"/>
        </uix:cellFormat>
        <uix:cellFormat>
          <uix:styledText styleClass="OraDataText" textBinding="beforeAfterInsteadofString@objectBean@servletRequest"/>
          <uix:spacer width="2"/>
          <uix:styledText styleClass="OraDataText" textBinding="insertDeleteUpdateString@objectBean@servletRequest"/>
          <uix:styledText styleClass="OraDataText" textBinding="eventsString@objectBean@servletRequest"/>
        </uix:cellFormat>
      </uix:rowLayout>

      <uix:rowLayout renderedBinding="tableOrViewObjType@objectBean@servletRequest">
        <uix:messagePrompt promptBinding="TRIGGER_FOR_EACH_ROW@uixTriggerBundle@servletRequest"/>
        <uix:styledText styleClass="OraDataText" textBinding="forEachRow@objectBean@servletRequest"/>
      </uix:rowLayout>

      <%-- determine if we should show the Ref. old etc. Trigger for each row details --%>
      <uix:rowLayout renderedBinding="hasForEachRowOption@objectBean@servletRequest"> 
        <uix:messagePrompt promptBinding="REFNG_OLD_AS@uixTriggerBundle@servletRequest"/>
        <uix:styledText styleClass="OraDataText" textBinding="oldRef@objectBean@servletRequest"/>
      </uix:rowLayout>

      <uix:rowLayout renderedBinding="hasForEachRowOption@objectBean@servletRequest">
        <uix:messagePrompt promptBinding="REFNG_NEW_AS@uixTriggerBundle@servletRequest"/>
        <uix:styledText styleClass="OraDataText" textBinding="newRef@objectBean@servletRequest"/>
      </uix:rowLayout>

      <uix:rowLayout renderedBinding="hasConditionOption@objectBean@servletRequest">
        <uix:cellFormat vAlign="top" hAlign="right">
          <uix:messagePrompt labeledNodeId="condition"
                             promptBinding="CONDITION@uixTriggerBundle@servletRequest"/>
        </uix:cellFormat>
        <uix:textInput id="condition"
                       name="condition"
                       textBinding="condition@objectBean@servletRequest" 
                       columns="60" 
                       rows="10" 
                       readOnly="true"/>
      </uix:rowLayout>
      <%-- end trigger for each row related contents --%>

    </uix:tableLayout>

    <%-- END: TAB CONTENTS ends here --%>   
  
  <%-- Create/Edit Buttons --%>
    <uix:pageButtons>
      <uix:pageButtonBar>
        <uix:switcher childNameBinding="xmlInitialized@objectBean@servletRequest">
          <uix:case name="false">
            <jsp:include page="/database/schema/pageButtonViewInclude.jsp" />
            <uix:ref refID="pageButtonViewInclude" />
          </uix:case>
          <uix:case name="true">
          <%-- OK Button --%>
          <%@ include file="/database/changemgr/cmEMOViewPageButtons.jspf" %>
          </uix:case>
        </uix:switcher>
      </uix:pageButtonBar>
    </uix:pageButtons>

</uix:pageLayout>
</db:form>
<%-- END: HTML Form --%>

</uix:body>
</uix:document>
</uix:renderingContext>
<%-- END: Content --%> 




