<%-- Name:        iotInclude.jsp 
  -- Type:        JSP Include 
  -- Description: This page contains the UI for iot. IOT Overflow Storage 
  --              is handled via a button that should lead to the standard storage include.
  --              If you support IOT overflow then call your IOT object to get the 
  --              IOTSegment.  That should be your bean for the storage page.  See
  --              em/database/schema/table/iotPage.jsp and iotStoragePage.jsp for 
  --              an example.
  --
  -- EMO Beans:  You provide the name of your instance of the 
  --             IOT bean.  Your instance of the IOT bean will contain the instance
  --             of the IOTSegment bean you need for storage (see above).
  --         
  --             Messages are  expected to be in: uixDBObjectBundle@servlet request
  --             which should point to an instance of the DBObjectMsg bundle.
  -- 
  -- JSP Changes: To use this page, add the following to your jsp file:
  --
  --  <uix:dataScope currentDataBinding="<your iot bean>@servletRequest">
  --    <jsp:include page="/database/schema/utilities/iotInclude.jsp" />
  --    <uix:ref refID="iotInclude" />
  --  </uix:dataScope>
  --
  -- Controller Changes:  
  --             Make your controller instaniate the emo beans listed
  --             above.  The name of the bean can be whatever you need.
  --             Make sure your controller calls beanUtils with your bean
  --             when submit form is called.
  --
  -- Initializer Changes:
  --             You must create a SegmentInitializer that extents from 
  --             IOTInitializer - see Table for an example.
  --
  -- Getting Storage To Initialize on CREATE:
  --             Currently you must override IOT.java and then 
  --             override the getInitializer function to save your own 
  --             initializer.
  --             See TableIOT.java for an example.
  --             To make the page initialize everytime a tablespace changes,
  --             you must set the objects initialized variable to false
  --             whenever the tablespace changes.
  --%> 

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<%@ page import="oracle.sysman.emo.adm.schema.utilities.UtilConst" %>

<%-- STORAGE PAGE CONTENT --%>
<uix:buildTree nodeID="iotInclude">

  <uix:tableLayout cellSpacing="10" width="100%">
    
      <%-- Tip --%>
      <uix:rowLayout>
      <uix:cellFormat>
          <uix:tip renderedBinding="noPrimaryKey@">
            <uix:styledText styleClass="OraTipText" 
                            textBinding="IOT_TIP@uixDBObjectBundle@servletRequest" />
            <uix:spacer width="5"/>
            <uix:link textBinding="ADD_PRIMARY_KEY_LINK@uixDBObjectBundle@servletRequest"
                      onClick="submitForm('tblForm', true, {event:'addConstraint'})"/>
          </uix:tip>
      </uix:cellFormat>
      </uix:rowLayout>
        
  </uix:tableLayout> 
  
  <uix:tableLayout width="100%">      

    <uix:labeledFieldLayout>

      <%--Compress --%>
      <uix:messagePrompt promptBinding="COMPRESS@uixDBObjectBundle@servletRequest" labeledNodeId="COMPRESS"/>
      <oem:choice name="IOTCompress"
                  optionsBinding="compressOptions@"
                  selectedValueBinding="IOTCompress@"
                  id="COMPRESS"
                  disabledBinding="editing@" />

      <%-- Mapping Table --%>
      <uix:checkBox name="iotMapping"
                    checkedBinding="useMappingTable@" 
                    textBinding="MAPPING_TABLE@uixSchemaBundle@servletRequest" 
                    renderedBinding="versionEqualOrHigher90@"
                    disabledBinding="mappingDisabled@"/>

    </uix:labeledFieldLayout>
    
    <%-- Overflow Options --%>
    <uix:header textBinding="OVERFLOW_OPTIONS@uixDBObjectBundle@servletRequest">

      <uix:checkBox name="overflow"
                    checkedBinding="overflow@"
                    textBinding="USE_OVERFLOW_DATA_SEGMENT@uixDBObjectBundle@servletRequest"
                    readOnlyBinding="overflowDisabled@"
                    onClick="submitForm(document.forms[0], true, {event:'overflowClicked'})" /> 

      <uix:rowLayout>

        <uix:spacer width="20" />

        <uix:tableLayout cellSpacing="5" >
        <uix:contents>

          <%--pctThreshold --%>
          <uix:rowLayout>
            <uix:cellFormat hAlign="right" vAlign="top">
               <uix:messagePrompt promptBinding="PERCENT_THRESHOLD@uixDBObjectBundle@servletRequest" labeledNodeId="PERCENT_THRESHOLD"/>
            </uix:cellFormat>
            <uix:cellFormat hAlign="left">
              <uix:stackLayout>
                <uix:textInput name="pctThreshold" 
                               textBinding="pctThreshold@"
                               id="PERCENT_THRESHOLD" shortDescBinding="PERCENT_THRESHOLD@uixDBObjectBundle@servletRequest"
                               columns="10"
                               disabledBinding="overflowOptionsDisabled@"/>
                <uix:styledText styleClass="OraInlineInfoText" 
                                textBinding="PERCENT_THR_HINT@uixDBObjectBundle@servletRequest"/>
              </uix:stackLayout>
            </uix:cellFormat>
          </uix:rowLayout>

          <%-- Including Column--%>
          <uix:rowLayout>
          <uix:contents>
            <uix:cellFormat hAlign="right" vAlign="top">
              <uix:messagePrompt promptBinding="INCLUDING_COLUMN@uixDBObjectBundle@servletRequest" labeledNodeId="INCLUDING_COLUMN"/>
            </uix:cellFormat>
            <uix:cellFormat hAlign="left">
              <uix:stackLayout>
                <oem:choice name="includingCol" 
                            optionsBinding="includingColumns@" 
                            selectedValueBinding="includingCol@"
                            id="INCLUDING_COLUMN"
                            disabledBinding="overflowOptionsDisabled@">
                </oem:choice>
                <uix:styledText styleClass="OraInlineInfoText"  
                                textBinding="INCLUDING_COLUMN_HINT@uixDBObjectBundle@servletRequest"/>
              </uix:stackLayout>
            </uix:cellFormat>
          </uix:contents>
          </uix:rowLayout>

          <%-- Tablespace Name--%>
          <uix:rowLayout>
          <uix:contents>
            <uix:cellFormat hAlign="right" vAlign="top">
              <uix:messagePrompt promptBinding="TABLESPACE@uixDBObjectBundle@servletRequest" labeledNodeId="TABLESPACE"/>
            </uix:cellFormat>
            
            <uix:cellFormat hAlign="left">
              <uix:stackLayout>
              <uix:rowLayout>
              <uix:contents>
              
		<uix:messageLovField name="overflowTablespace" 
	            		textBinding="overflowTablespace@"
                        id="TABLESPACE"
	             		shortDescBinding="CLICKTOSELECTTABLESPACE@uixDBObjectBundle@servletRequest"
                        searchDescBinding="CLICKTOSELECTTABLESPACE@uixDBObjectBundle@servletRequest"
                     	onClick = "startLov('overflowTablespace','ListTablespaceAll')"
                        disabledBinding="overflowTablespaceDisabled@" />

                <uix:submitButton textBinding="OVERFLOWSTORAGE@uixDBObjectBundle@servletRequest"
                                  shortDescBinding="OVERFLOWSTORAGE@uixDBObjectBundle@servletRequest"
                                  name="event"
                                  value="<%= UtilConst.IOT_OVERFLOW_STORAGE %>"
                                  disabledBinding="overflowOptionsDisabled@" />                                         
              </uix:contents>
              </uix:rowLayout>

              <uix:styledText styleClass="OraInlineInfoText"
                              textBinding="TABLESPACE_CONTROL_HINT@uixDBObjectBundle@servletRequest"/>

              </uix:stackLayout>
            </uix:cellFormat>

          </uix:contents>
          </uix:rowLayout>

        </uix:contents>
        </uix:tableLayout>
        
      </uix:rowLayout>

    </uix:header>

  </uix:tableLayout>

</uix:buildTree>

