<%-- Name:        jobInclude.jsp 
  -- Type:        OEM JSP Include 
  -- Description: This page contains the complete UI for scheduling a job.
  --              There is supposed to be a generic job page that can be
  --              shared, but until that is finished, this can be used 
  --              for the schema objects.
  --
  -- JSP Changes: To use this page,  include this page on your job schedule page.
  -- EMO Changes: Add a function to your bean that will return the job bean.
  -- Controller Changes:  
  --%> 

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:buildTree nodeID="jobInclude">

<uix:dataScope>
<uix:bundle name="dbMsgs"
              class="oracle.sysman.db.rsc.DBObjectMsg"/>
<uix:bundle name="schmMsgs"
              class="oracle.sysman.db.rsc.schm.SchemaMsg"/>

<uix:stackLayout>

    <%-- Intro Text --%>
    <uix:spacer height="5" width="1" />
    <uix:styledText styleClass="OraInstructionText" 
                    textBinding="JOB_INSTR@schmMsgs" />
    <uix:spacer height="10" width="1"/>

    <%-- Job Name, Description --%>    
    <uix:labeledFieldLayout labelWidth="15%">
      <uix:messagePrompt promptBinding="JOB_NAME@schmMsgs"
                         required="yes"
                         labeledNodeId="jobName"/>
      <uix:textInput  id="jobName" 
                      name="jobName"
                      textBinding="jobName@"
                      columns="60"/>
      <uix:messagePrompt promptBinding="JOB_DESC@schmMsgs"
                         labeledNodeId="jobDescription"/>
      <uix:textInput id="jobDescription"
                     name="jobDescription"
                     textBinding="jobDescription@"
                     columns="60"/>
    </uix:labeledFieldLayout>  
    
    <%-- Host Credentials --%>
     <uix:header textBinding="HOST_CRED_HDR@schmMsgs" size="2">
            <uix:rowLayout>
              <uix:contents>
                    <uix:styledText styleClass="OraInstructionText" textBinding="STEP4_INTRO2@uixAnalyzeBundle@servletRequest"/>
              </uix:contents>
            </uix:rowLayout>
            <uix:spacer height="5"/>
            <%@ include file="/credentials.jspf"%>
      </uix:header>
    
    <uix:tableLayout renderedBinding="showDBCreds@" width="100%" cellSpacing="2">          
                <uix:rowLayout vAlign="top">
                  <uix:header textBinding="DATABASE_CRED_HDR@schmMsgs">
                    <uix:contents>
                      <uix:labeledFieldLayout labelWidth="25%">
                        <uix:contents>
                          <uix:messagePrompt
                              labeledNodeId="targetUserName"
                              promptBinding="USERNAME@schmMsgs"
                              required="yes"/>
                          <uix:textInput
                              id="targetUserName"
                              name="targetUserName"
                              textBinding="targetUserName@"
                              noAutoComplete="true"
                              columns="30"/>
                          <uix:messagePrompt
                              labeledNodeId="targetPassword"
                              promptBinding="PASSWORD@schmMsgs"
                              required="yes"/>
                          <uix:textInput
                              id="targetPassword"
                              name="secretTargetPassword"
                              textBinding="secretTargetPassword@"
                              noAutoComplete="true"
                              secret="true"
                              columns="30"/>
                       </uix:contents>
                      </uix:labeledFieldLayout>
                    </uix:contents>
                  </uix:header>
           
                </uix:rowLayout>
        </uix:tableLayout>
    <uix:spacer height="10" width="1"/> 

    <%-- Scheduling Option --%>
     <uix:header textBinding="SCHED_OPT_HDR@schmMsgs">
          <%@ include file="/sdk/schedule/start.jspf" %>
    </uix:header>
    
</uix:stackLayout>

</uix:dataScope>
</uix:buildTree>
