<%@ include file="/sdk/oemTop.jspf" %>
<%-- Name:        jobPage.jsp 
  -- Type:        OEM Job Page
  -- Description: This page is a standalone job page for scheduling a job.
  --              There is supposed to be a generic job page that can be
  --              shared, but until that is finished, this can be used 
  --              for the schema objects.
  --
  -- JSP Changes: To use this page,  include this page on your job schedule page.
  -- EMO Changes: Add a function to your bean that will return the job bean.
  -- Controller Changes:  
  --%> 

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>

<uix:renderingContext id="renderingContext">
  <uix:bundle name="dbMsg"
              class="oracle.sysman.db.rsc.DBObjectMsg"/>
<oem:setURLEncoder id="renderingContext"/>
<uix:document>

<%-- HTML Page Title --%>
<uix:metaContainer>
  <uix:head titleBinding="title@objectBean@servletRequest"/>
</uix:metaContainer>

<uix:body>
<%-- <uix:dataScope currentDataBinding="shrinkBean@servletRequest"> --%>

<%-- HTML Form --%>
<%-- Used 'destination' instead of 'destinationBinding' for 'Submit Job' button fix --%>
<db:form name="shrinkForm" 
         method="post"
		 destinationBinding="destination@objectBean@servletRequest"
         copyParams="sname,oname,target,type,cancelURL,otype" >
<uix:formValue name="pageName" value="<%= SchemaPages.UTIL_JOB_PG %>"/>
<uix:pageLayout titleBinding="SCHEDULE_JOB@dbMsg">

  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/global.jspf" %>

  <%-- Warning/Error display --%>
  <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error" 
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>

  <%-- START: SCHEDULE JOB CONTENTS starts here --%>
  <uix:stackLayout>
  <uix:dataScope currentDataBinding="objectBean@servletRequest">
    <jsp:include page="/database/schema/utilities/jobInclude.jsp" />
    <uix:ref refID="jobInclude" />
  </uix:dataScope>        
  </uix:stackLayout>
  <%-- END: SCHEUDLE JOB CONTENTS ends here --%>   
        
  <%-- Show SQL, OK, and Schedule Buttons --%>
  <uix:pageButtons>
  <uix:pageButtonBar>

    <%-- CANCEL BUTTON --%>
    <uix:button textBinding="CANCEL@uixDBObjectBundle@servletRequest" 
                      destinationBinding="backURL@servletRequest" />
  
    <%-- OK BUTTON --%>
    <uix:submitButton textBinding="OK@uixDBObjectBundle@servletRequest" 
                      name="event" 
                      value="applyJobSubmit" />

  </uix:pageButtonBar>
  </uix:pageButtons>

</uix:pageLayout>
</db:form>
<%-- END: HTML Form --%>
<%-- </uix:dataScope> --%>
</uix:body>

</uix:document>
</uix:renderingContext>
<%-- END: Content --%> 

