<%-- Name:        lobStorageInclude.jsp 
  -- Type:        JSP Include 
  -- Description: This page contains the UI for lob segments for a
  --              schema object. Lob Storage is handled via a button
  --              that should lead to the standard storage include.
  --
  -- EMO Beans:  You provide the name of your instance of the 
  --             LobSegment bean.  Your instance of the LobSegment will also
  --             serve as the bean for the Lob Storage Page.
  --         
  --             Messages are  expected to be in: uixDBObjectBundle@servlet request
  --             which should point to an instance of the DBObjectMsg bundle.
  --
  --             Errors are expected to be in: errors@servletRequest
  -- 
  -- JSP Changes: To use this page, add the following to your jsp file:
  --
  --  <uix:dataScope currentDataBinding="<your lob bean>@servletRequest">
  --    <jsp:include page="/database/schema/utilities/lobStorageInclude.jsp" />
  --    <uix:ref refID="lobStorageInclude" />
  --  </uix:dataScope>
  --
  -- Controller Changes:  
  --             Make your controller instaniate the emo beans listed
  --             above.  The name of the bean can be whatever you need.
  --             Make sure your controller calls beanUtils with your bean
  --             when submit form is called.
  --
  -- Initializer Changes:
  --             You must create a SegmentInitializer that extents from 
  --             LobSegmentInitializer - see Table for an example.
  --
  -- Getting Storage To Initialize on CREATE:
  --             Currently you must override LobSegment.java and then 
  --             override the getInitializer function to save your own 
  --             initializer.
  --             See TableLob.java for an example.
  --             To make the page initialize everytime a tablespace changes,
  --             you must set the objects initialized variable to false
  --             whenever the tablespace changes.
  --%> 

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import="oracle.sysman.emo.adm.schema.utilities.UtilConst" %>
<%@ page import="oracle.sysman.emo.constants.Units" %>

<%-- STORAGE PAGE CONTENT --%>
<uix:buildTree nodeID="lobStorageInclude">
<uix:dataScope>

<%-- Message Bundles Used --%>
<uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>
<uix:bundle name="dbMsgs2" class="oracle.sysman.db.rsc.inst.DBMsg"/>
<uix:bundle name="tableMsgs" class="oracle.sysman.db.rsc.schm.TableMsg"/>
<uix:bundle name="tsMsgs" class="oracle.sysman.db.rsc.stor.TablespaceMsg"/>
<uix:bundle name="schmMsgs" class="oracle.sysman.db.rsc.schm.SchemaMsg"/>
<uix:bundle name="AAMsgs" class="oracle.sysman.db.rsc.sqla.SqlAccessMsg"/>

<script language="javascript">

function setRetentionTypeSelected()
{
  bChecked = document.forms[0].retention[1].checked;
  document.forms[0].maxSize.disabled=!bChecked;
  document.forms[0].maxUnit.disabled=!bChecked;
  bChecked = document.forms[0].retention[2].checked;
  document.forms[0].minSecs.disabled=!bChecked;
}

function setBFRetentionTypeSelected()
{
  bChecked = document.forms[0].bfretention[2].checked;
  document.forms[0].pctVersion.disabled=!bChecked;
}

function initLOBStorageOptions()
{
  if (!document.forms[0].retention[1].checked)
  {
    document.forms[0].maxSize.disabled=true;
    document.forms[0].maxUnit.disabled=true;
  }

  if (!document.forms[0].retention[2].checked)
    document.forms[0].minSecs.disabled=true;
}
 
function initBFLOBStorageOptions()
{
  if (!document.forms[0].bfretention[2].checked)
    document.forms[0].pctVersion.disabled=true;
}
</script>


  <%-- START: LOB ATTRIBUTES --%>
  <uix:header textBinding="LOB_ATTRIBUTES@dbMsgs">
  <uix:labeledFieldLayout columns="1">

    <%-- Segment Name --%>
    <uix:messageTextInput name="segmentName"
                    promptBinding="SEGMENT@dbMsgs"
                    shortDescBinding="SEGMENT@dbMsgs"
                    textBinding="segmentName@" 
                    disabledBinding="lobNameDisabled@" />

     <%-- Attributes change depending on securefile or basicfile --%>
     <uix:messageRadioButton name="lobStorageType"
	              renderedBinding="versionEqualOrHigher11@"
	              textBinding="BASIC_LOB@tableMsgs"
	              promptBinding="LOB_STORAGE_TYPE@tableMsgs"
                      value="<%= UtilConst.BASICFILE %>"
	              selectedValueBinding="lobStorageType@"
		      disabledBinding="lobDisabled@"
                      onClick="submitForm('tblForm', true, {event:'changeLobStorageType'})" />

     <uix:messageRadioButton name="lobStorageType"
	              renderedBinding="versionEqualOrHigher11@"
	              textBinding="SECURE_LOB@tableMsgs"
	              tipBinding="SECURE_DESC@tableMsgs"
                      value="<%= UtilConst.SECUREFILE %>"
	              selectedValueBinding="lobStorageType@"
                      disabledBinding="lobDisabled@"
                      onClick="submitForm('tblForm', true, {event:'changeLobStorageType'})" />

     <uix:spacer />
     <uix:spacer height="5" />

    <%-- Number of blocks accessed at one time (CHUNK) --%>
    <uix:messagePrompt promptBinding="NUM_OF_BLOCKS_ACC@dbMsgs" renderedBinding="notSecureFile@" labeledNodeId="LOB_CHUNK_ID" />
    <uix:tableLayout>
    <uix:rowLayout>
      <uix:messageTextInput name="chunk"
                    id="LOB_CHUNK_ID"
                    shortDescBinding="NUM_OF_BLOCKS_ACC@dbMsgs"
                    textBinding="chunk@" 
                    renderedBinding="notSecureFile@"
                    disabledBinding="lobDisabled@"
                    columns="10">
        <uix:onSubmitValidater>
          <uix:regExp pattern="[1-9]+[0-9]*$"/>
        </uix:onSubmitValidater>
      </uix:messageTextInput>
      <uix:messageChoice name="chunkUnit" 
                    shortDescBinding="NUM_OF_BLOCKS_ACC@dbMsgs"
                    selectedValueBinding="chunkUnit@"
                    renderedBinding="notSecureFile@"
                    disabledBinding="lobDisabled@" >
         <uix:option textBinding="BYTES@uixDBObjectBundle@servletRequest"
                    value="<%= Units.BYTES %>" />
         <uix:option textBinding="KBYTES@uixDBObjectBundle@servletRequest"
                    value="<%= Units.KBYTES %>" />
         <uix:option textBinding="MBYTES@uixDBObjectBundle@servletRequest"
                    value="<%= Units.MBYTES %>" />
      </uix:messageChoice>
    </uix:rowLayout>
    </uix:tableLayout >

    <%-- Space used for new version(pctVersion)--%>
<%--
    <uix:messageTextInput name="pctVersion"
                          renderedBinding="notSecureFile@"
                          promptBinding="PCTVERSION@dbMsgs"
                          shortDescBinding="PCTVERSION@dbMsgs"
                          textBinding="pctVersion@" 
                          disabledBinding="allDisabled@"
                          columns="10" >
      <uix:onSubmitValidater>
        <uix:regExp pattern="[1-9]+[0-9]*$"/>
      </uix:onSubmitValidater>
    </uix:messageTextInput>

--%>

    <uix:switcher childNameBinding="newLOB@servletRequest">
      <uix:case name="true"> 
        <uix:messageRadioButton name="bfretention"
                                renderedBinding="notSecureFile@"
    	                        textBinding="OLD_VERS_DEF@tableMsgs"
	                        promptBinding="OLD_VERS@tableMsgs"
                                value="<%= UtilConst.AUTO %>"
                                selectedValueBinding="retention@" 
  	                        disabledBinding="allDisabled@"
                                onClick='setBFRetentionTypeSelected()' />  
      </uix:case> 
    </uix:switcher>

    <uix:switcher childNameBinding="newLOB@servletRequest">
      <uix:case name="true"> 
        <uix:messageRadioButton name="bfretention"
                                renderedBinding="notSecureFile@"
    	                        textBinding="OLD_VERS_RET@tableMsgs"
	                        tipBinding="OLD_VERS_RET_DESC@tableMsgs"
                                value="<%= UtilConst.MIN %>"
                                selectedValueBinding="retention@" 
	                        disabledBinding="allDisabled@" 
                                onClick='setBFRetentionTypeSelected()' />  
      </uix:case> 
      <uix:default> 
        <uix:messageRadioButton name="bfretention"
                                renderedBinding="notSecureFile@"
    	                        textBinding="OLD_VERS_RET@tableMsgs"
	                        promptBinding="OLD_VERS@tableMsgs"
	                        tipBinding="OLD_VERS_RET_DESC@tableMsgs"
                                value="<%= UtilConst.MIN %>"
                                selectedValueBinding="retention@" 
	                        disabledBinding="allDisabled@" 
                                onClick='setBFRetentionTypeSelected()' />  
      </uix:default> 
    </uix:switcher>

    <uix:rowLayout/>
    <uix:rowLayout>
      <uix:messageRadioButton name="bfretention"
                              renderedBinding="notSecureFile@"
    	                      textBinding="OLD_VERS_PCT@tableMsgs"
                              value="<%= UtilConst.MAX %>"
                              selectedValueBinding="retention@" 
	                      disabledBinding="allDisabled@"
                              onClick='setBFRetentionTypeSelected()' />  
      <uix:spacer height="0" width="15"/>

      <uix:messageTextInput name="pctVersion"
	                    renderedBinding="notSecureFile@"
                            shortDescBinding="PCTVERSION@dbMsgs"
                            textBinding="pctVersion@" 
                            disabledBinding="allDisabled@"
                            columns="10" >
        <uix:onSubmitValidater>
          <uix:regExp pattern="[1-9]+[0-9]*$"/>
        </uix:onSubmitValidater>
      </uix:messageTextInput>
    </uix:rowLayout> 

    <uix:rowLayout/>
    <uix:rowLayout> 
      <uix:spacer height="0" width="20"/>
      <uix:styledText textBinding="OLD_VERS_PCT_DESC@tableMsgs" 
                      renderedBinding="notSecureFile@"
                      styleClass="OraInlineInfoText" />
    </uix:rowLayout> 

    <%-- Cache--%>
    <uix:messageChoice name="cache" 
                    promptBinding="CACHE@dbMsgs"
                    shortDescBinding="CACHE@dbMsgs"
                    selectedValueBinding="cache@"
                    disabledBinding="allDisabled@" >
      <uix:option text="<%= UtilConst.S_CACHE %>"
                    value="<%= UtilConst.CACHE_ON %>" />
      <uix:option text="<%= UtilConst.S_NO_CACHE %>"
                    value="<%= UtilConst.CACHE_OFF %>" />
      <uix:option text="<%= UtilConst.S_CACHE_READS %>"
                    value="<%= UtilConst.CACHE_READS %>" />
    </uix:messageChoice>

    <%-- Enable storage in Row --%>
    <uix:messageCheckBox name="storageInRow"
                    textBinding="ENABLE_STORAGE_IN_ROW@dbMsgs"
                    shortDescBinding="ENABLE_STORAGE_IN_ROW@dbMsgs"
                    checkedBinding="storageInRow@" 
                    disabledBinding="lobDisabled@"/>

     <%-- Attributes change depending on securefile or basicfile --%>
     <uix:messageRadioButton name="retention"
                             renderedBinding="secureFile@"
    	                     textBinding="AUTOMATIC@tsMsgs"
	                     tipBinding="RETENTION_AUTO_DESC@tableMsgs"
	                     promptBinding="RETENTION@tableMsgs"
                             value="<%= UtilConst.AUTO %>"
                             selectedValueBinding="retention@" 
	                     disabledBinding="allDisabled@" 
                             onClick='setRetentionTypeSelected()' />  

     <uix:spacer />
     <uix:tableLayout>
       <uix:rowLayout>
         <uix:messageRadioButton name="retention"
                                 renderedBinding="secureFile@"
	                         textBinding="MAXIMUM_HDR@tsMsgs"
                                 value="<%= UtilConst.MAX %>"
                                 selectedValueBinding="retention@"
				 disabledBinding="allDisabled@"
                                 onClick='setRetentionTypeSelected()' /> 
         <uix:spacer height="0" width="15"/>
         <uix:messageTextInput name="maxSize"
                              id="MAX_ID_SIZE"
	                      promptBinding="SIZE@tsMsgs"
                              shortDescBinding="MAX_SIZE_BYTES@tableMsgs"
                              renderedBinding="secureFile@"
                              textBinding="maxSize@" 
                              disabledBinding="allDisabled@"
                              columns="10">
           <uix:onSubmitValidater>
             <uix:regExp pattern="[1-9]+[0-9]*$"/>
           </uix:onSubmitValidater>
         </uix:messageTextInput>
         <uix:messageChoice name="maxUnit" 
                            shortDescBinding="NUM_OF_BLOCKS_ACC@dbMsgs"
                            disabledBinding="allDisabled@"
                            selectedValueBinding="maxUnit@"
                            renderedBinding="secureFile@" >
           <uix:option textBinding="BYTES@uixDBObjectBundle@servletRequest"
                       value="<%= Units.BYTES %>" />
           <uix:option textBinding="KBYTES@uixDBObjectBundle@servletRequest"
                       value="<%= Units.KBYTES %>" />
           <uix:option textBinding="MBYTES@uixDBObjectBundle@servletRequest"
                       value="<%= Units.MBYTES %>" />
           <uix:option textBinding="OPT_GB@AAMsgs"
                       value="<%= Units.GBYTES %>" />
         </uix:messageChoice>
       </uix:rowLayout>
     </uix:tableLayout>

     <uix:spacer />
     <uix:rowLayout>
       <uix:flowLayout>
         <uix:spacer height="0" width="20" />
         <uix:styledText textBinding="RETENTION_MAX_DESC@tableMsgs"  styleClass="OraInlineInfoText" renderedBinding="secureFile@" />
       </uix:flowLayout>
     </uix:rowLayout>

     <uix:spacer />
     <uix:tableLayout>
       <uix:rowLayout>
         <uix:messageRadioButton name="retention"
                                 renderedBinding="secureFile@"
	                         textBinding="MINIMUM_HDR@tsMsgs"
                                 value="<%= UtilConst.MIN %>"
                                 selectedValueBinding="retention@"
				 disabledBinding="allDisabled@" 
                                 onClick='setRetentionTypeSelected()' />  
         <uix:spacer height="0" width="15"/>
         <uix:messageTextInput name="minSecs"
                               id="MIN_ID_SECS"
	                       promptBinding="SECONDS@dbMsgs2"
                               shortDescBinding="MIN_SECS@tableMsgs"
                               textBinding="minSecs@" 
                               renderedBinding="secureFile@"
                               disabledBinding="allDisabled@"
                               columns="10">
           <uix:onSubmitValidater>
             <uix:regExp pattern="[1-9]+[0-9]*$"/>
           </uix:onSubmitValidater>
         </uix:messageTextInput>
       </uix:rowLayout>
     </uix:tableLayout>

     <uix:spacer />
     <uix:rowLayout>
       <uix:flowLayout>
         <uix:spacer height="0" width="20" />
         <uix:styledText textBinding="RETENTION_MIN_DESC@tableMsgs"  styleClass="OraInlineInfoText" renderedBinding="secureFile@" />
       </uix:flowLayout>
     </uix:rowLayout>

     <uix:messageRadioButton name="retention"
                             renderedBinding="secureFile@"
    	                     textBinding="COMP_NONE@tableMsgs"
  	                     tipBinding="RETENTION_NONE_DESC@tableMsgs"
                             value="<%= UtilConst.NONE %>"
                             selectedValueBinding="retention@"
		             disabledBinding="allDisabled@" 
                             onClick='setRetentionTypeSelected()' />  
     <uix:spacer />
     <uix:spacer height="5" />

     <%-- Compression  - SECUREFILE LOBs only --%>
     <uix:messageRadioButton name="compression"
                             renderedBinding="secureFile@"
    	                     textBinding="COMP_NONE@tableMsgs"
                             promptBinding="COMPRESSION@tableMsgs"
  	                     tipBinding="COMP_NONE_DESC@tableMsgs"
                             value="<%= UtilConst.NONE %>"
                             selectedValueBinding="compression@"
		             disabledBinding="allDisabled@" />

     <uix:messageRadioButton name="compression"
                             renderedBinding="secureFile112@"
    	                     textBinding="COMP_LOW@tableMsgs"
  	                     tipBinding="COMP_LOW_DESC@tableMsgs"
                             value="<%= UtilConst.LOW %>"
                             selectedValueBinding="compression@"
		             disabledBinding="allDisabled@" />

     <uix:messageRadioButton name="compression"
                             renderedBinding="secureFile@"
    	                     textBinding="COMP_MEDIUM@tableMsgs"
  	                     tipBinding="COMP_MEDIUM_DESC@tableMsgs"
                             value="<%= UtilConst.MEDIUM %>"
                             selectedValueBinding="compression@"
		             disabledBinding="allDisabled@" />

     <uix:messageRadioButton name="compression"
                             renderedBinding="secureFile@"
    	                     textBinding="COMP_HIGH@tableMsgs"
  	                     tipBinding="COMP_HIGH_DESC@tableMsgs"
                             value="<%= UtilConst.HIGH %>"
                             selectedValueBinding="compression@"
		             disabledBinding="allDisabled@" />

     <uix:spacer />
     <uix:spacer height="5" />

     <%-- Deduplication - SECUREFILE LOBs only --%>
     <uix:messageRadioButton name="deduplicate"
	                     promptBinding="DUPLICATION@tableMsgs"
	                     renderedBinding="secureFile@"
	                     textBinding="KEEP_DUPS@tableMsgs"
	                     tipBinding="KEEP_DUPS_DESC@tableMsgs"
                             value="<%= UtilConst.DUP %>"
                             selectedValueBinding="deduplicate@"
                             disabledBinding="allDisabled@" />

     <uix:messageRadioButton name="deduplicate"
	                     renderedBinding="secureFile@"
	                     textBinding="DEDUPLICATE@tableMsgs"
	                     tipBinding="DEDUPLICATE_DESC@tableMsgs"
                             value="<%= UtilConst.DEDUP %>"
                             selectedValueBinding="deduplicate@"
		             disabledBinding="allDisabled@" />

    </uix:labeledFieldLayout>
    </uix:header>
    <%-- END: LOB ATTRIBUTES --%>

    <%-- START: LOB STORAGE ATTRIBUTES --%>
    <uix:header textBinding="LOB_STORAGE_ATTRIBUTES@uixDBObjectBundle@servletRequest">
      <jsp:include page="/database/schema/utilities/storageContextInclude.jsp" />
      <uix:ref refID="storageInclude" />
    </uix:header>
    <%-- END: LOB STORAGE ATTRIBUTES --%>           

</uix:dataScope>
</uix:buildTree>

