<%-- Name:        relatedSegmentsTableInclude.jsp 
  -- Type:        OEM JSP Include 
  -- Description: This page contains the complete UI for related segments for a
  --              schema object. (table, index, mview, mviewlog) 
  --
  -- 
  -- JSP Changes: To use this page,  include this page as a 'macro' include
  --              in your storage page jsp.  In your JSP you must include the
  --              oem taglib.
  -- 
  -- Controller Changes:  
  --             Make your controller instaniate the emo beans listed
  --             above.  The name of each bean must match the names above.
  --             Make sure your controller calls beanUtils for these beans
  --             when submit form is called.
  --%> 

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>

<uix:buildTree nodeID="relatedSegmentsTableInclude">

<uix:dataScope>
<uix:bundle name="schmMsgs"
              class="oracle.sysman.db.rsc.schm.SchemaMsg"/>
<uix:tableLayout>
  <uix:switcher childNameBinding="multiSelectUsed@">
    <uix:case name="true">  <%-- use multiselection --%>
      <uix:switcher childNameBinding="spaceColsUsed@">
        <uix:case name="false">
          <uix:table name="relatedSegsTable"
               width="80%"
               formSubmitted="true"
               tableDataBinding="segmentsList@"
               columnHeaderDataBinding="columnHeaders@"
               columnFormatsBinding="columnFormats@"
               blockSizeBinding="blockSize@"
               maxValueBinding="maxValue@"
               summaryBinding="RELATED_SEGMENTS@schmMsgs"
               valueBinding="startIndexUI@">
      
             <uix:tableFormat tableBanding="rowBanding"/>
             <uix:columnHeaderStamp>
               <uix:sortableHeader textBinding="text" sortableBinding="sortable"/>
             </uix:columnHeaderStamp>
               <uix:styledText textBinding="schema"/>
               <uix:styledText textBinding="segment"/>
               <uix:styledText textBinding="type"/>
               <uix:styledText textBinding="tablespace"/>
            <uix:tableSelection>
                <uix:multipleSelection selectedBinding="select" 
                                       disabledBinding="tableDisabled"
                                       shortDescBinding="SELECT_SEGMENTS@schmMsgs"/>
            </uix:tableSelection>
        </uix:table>
      </uix:case>

      <uix:case name="true"> <%-- use space cols and multiselection --%>
        <uix:table name="relatedSegsTable"
                   width="80%"
                   formSubmitted="true"
                   tableDataBinding="segmentsList@"
                   columnHeaderDataBinding="columnHeaders@"
                   columnFormatsBinding="columnFormats@"
                   blockSizeBinding="blockSize@"
                   maxValueBinding="maxValue@"
                   summaryBinding="RELATED_SEGMENTS@schmMsgs"
                   valueBinding="startIndexUI@">
          
                 <uix:tableFormat tableBanding="rowBanding"/>
                 <uix:columnHeaderStamp>
                   <uix:sortableHeader textBinding="text" sortableBinding="sortable"/>
                 </uix:columnHeaderStamp>
                   <uix:styledText textBinding="schema"/>
                   <uix:styledText textBinding="segment"/>
                   <uix:styledText textBinding="type"/>
                   <uix:styledText textBinding="tablespace"/>
                   <uix:styledText textBinding="spaceUsed"/>
                   <uix:styledText textBinding="spaceAlloc"/>
                   <uix:styledText textBinding="wastedSpace"/>
                <uix:tableSelection>
                    <uix:multipleSelection selectedBinding="select"
                                           disabledBinding="tableDisabled"
                                           shortDescBinding="SELECT_SEGMENTS@schmMsgs"/>
                </uix:tableSelection>
         </uix:table>
       </uix:case>
     </uix:switcher>
  </uix:case>  <%-- end multiselection true case --%>

  <uix:case name="false"> <%-- single selection --%>
    <uix:switcher childNameBinding="spaceColsUsed@">
      <uix:case name="true">
        <uix:table name="relatedSegsTable"
             width="80%"
             formSubmitted="true"
             tableDataBinding="segmentsList@"
             columnHeaderDataBinding="columnHeaders@"
             columnFormatsBinding="columnFormats@"
             blockSizeBinding="blockSize@"
             maxValueBinding="maxValue@"
             summaryBinding="RELATED_SEGMENTS@schmMsgs"
             valueBinding="startIndexUI@">
  
         <uix:tableFormat tableBanding="rowBanding"/>
           <uix:columnHeaderStamp>
             <uix:sortableHeader textBinding="text" sortableBinding="sortable"/>
           </uix:columnHeaderStamp>
             <uix:styledText textBinding="schema"/>
             <uix:styledText textBinding="segment"/>
             <uix:styledText textBinding="type"/>
             <uix:styledText textBinding="tablespace"/>
             <uix:styledText textBinding="spaceUsed"/>
             <uix:styledText textBinding="spaceAlloc"/>
             <uix:styledText textBinding="wastedSpace"/>
          <uix:tableSelection>
              <uix:singleSelection selectedIndexBinding="selectedIndex@servletRequest"
                                   disabledBinding="tableDisabled"
                                   shortDescBinding="SELECT_SEGMENTS@schmMsgs"/>
          </uix:tableSelection>
      </uix:table>
    </uix:case>
    <uix:case name="false"> 
        <uix:table name="relatedSegsTable"
             width="80%"
             formSubmitted="true"
             tableDataBinding="segmentsList@"
             columnHeaderDataBinding="columnHeaders@"
             columnFormatsBinding="columnFormats@"
             blockSizeBinding="blockSize@"
             maxValueBinding="maxValue@"
             summaryBinding="RELATED_SEGMENTS@schmMsgs"
             valueBinding="startIndexUI@">
  
         <uix:tableFormat tableBanding="rowBanding"/>
           <uix:columnHeaderStamp>
             <uix:sortableHeader textBinding="text" sortableBinding="sortable"/>
           </uix:columnHeaderStamp>
             <uix:styledText textBinding="schema"/>
             <uix:styledText textBinding="segment"/>
             <uix:styledText textBinding="type"/>
             <uix:styledText textBinding="tablespace"/>
          <uix:tableSelection>
            <uix:singleSelection selectedIndexBinding="selectedIndex@servletRequest"
                                 disabledBinding="tableDisabled"
                                 shortDescBinding="SELECT_SEGMENTS@schmMsgs"/>
          </uix:tableSelection>
        </uix:table>
      </uix:case>
    </uix:switcher>
  </uix:case>

</uix:switcher>

</uix:tableLayout>
</uix:dataScope>
</uix:buildTree>
