<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>

<%--
  -- Page:        segmentShrink.jsp
  -- Controller:  db/adm/schm/SegmentShrinkController.java
  --
  -- Description: This page presents the user with all the manual segment 
  --              shrink options for a schema object.  The user can choose
  --              to shrink the selected object with cascade or retain options
  --              or can select related segments to shrink and choose retain
  --              for each segment.
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>
<%@ page import="oracle.sysman.emo.adm.schema.utilities.shrink.SegmentShrinkConst" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>
<uix:document>
  
<%-- HTML Page Title : must have function getPageHeader --%>
<%@ include file="/oemTitle.jspf" %>

<uix:body>
<uix:dataScope currentDataBinding="shrinkBean@servletRequest">

<%-- HTML Form --%>
<db:form name="shrinkForm" 
         method="post"
         destinationBinding="destination@"
         copyParams="target,type,cancelURL,sname,oname,otype" >
<uix:formValue name="pageName" value="<%= SchemaPages.UTIL_SEGMENT_SHRINK_PG %>"/>
<uix:pageLayout titleBinding="pageHeader@">

  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/global.jspf" %>
  <%-- Warning/Error display --%>
  <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error" 
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  
  <%-- START: SEGMENT SHRINK CONTENTS starts here --%>
  
  <%-- segment information --%>
  <uix:pageStatus>
  <uix:labeledFieldLayout labelWidth="15%">
    <uix:messagePrompt promptBinding="SEGMENT@uixDBObjectBundle@servletRequest"/>
    <uix:styledText styleClass="OraDataText" textBinding="fullObjectName@"/>
    <uix:messagePrompt promptBinding="OBJECT_TYPE@uixDBObjectBundle@servletRequest"/>
    <uix:styledText styleClass="OraDataText" textBinding="objectTypeUI@"/>
  </uix:labeledFieldLayout>
  </uix:pageStatus>
  <uix:separator />
  <uix:styledText styleClass="OraInstructionText" textBinding="SHRINK_INSTRUCTIONS@uixSchemaBundle@servletRequest"/>

  <%-- options start here --%>
  <uix:stackLayout>

    <%-- Intro Text --%>
    <uix:spacer height="5" width="1" />
  
    <%-- Shrink Options --%>
    <uix:header textBinding="SHRINK_OPT_HEADER@uixSchemaBundle@servletRequest">
    <uix:stackLayout>

       <%-- Shrink Segments (Offline) --%> 
       <uix:radioButton name="shrinkOffline"
                        value="true"
                        textBinding="SHRINK_OPT_OFFLINE@uixSchemaBundle@servletRequest"
                        selectedValueBinding="shrinkOfflineMode@" />

       <uix:rowLayout>
         <uix:spacer width="22"/>
         <uix:styledText styleClass="OraInlineInfoText"
                         textBinding="SHRINK_OPT_OFFLINE_TEXT@uixSchemaBundle@servletRequest" />
       </uix:rowLayout>

       <%-- Defragment Segments (Online) --%> 
       <uix:radioButton name="shrinkOffline"
                        value="false"
                        textBinding="SHRINK_OPT_ONLINE@uixSchemaBundle@servletRequest"
                        selectedValueBinding="shrinkOfflineMode@" />
       <uix:rowLayout>
         <uix:spacer width="22"/>
         <uix:styledText styleClass="OraInlineInfoText"
                         textBinding="SHRINK_OPT_ONLINE_TEXT@uixSchemaBundle@servletRequest" />
       </uix:rowLayout>

    </uix:stackLayout>     
    </uix:header>

    <%-- Segment Selection --%>
    <uix:header textBinding="SHRINK_SEGMENT_HEADER@uixSchemaBundle@servletRequest"
                renderedBinding="dependentSegments@">
    <uix:stackLayout>

      <%-- Shrink schema.obj --%> 
      <%-- replace when RDBMS bug 3194761 fixed
           onClick="submitForm('shrinkForm', true, {event:'segSelection'})" --%>
      <uix:radioButton name="shrinkSingleSeg"
                       value="<%= SegmentShrinkConst.OPT_SEG_ONLY %>"
                       textBinding="shrinkSegOnlyMsg@"
                       selectedValueBinding="shrinkSegmentOption@" />

      <%-- Shrink schema.obj and all Dependent Segments --%>  
      <%-- replace when RDBMS bug 3194761 fixed 
           onClick="submitForm('shrinkForm', true, {event:'segSelection'})" --%>
      <uix:radioButton name="shrinkSingleSeg"
                       value="<%= SegmentShrinkConst.OPT_SEG_CASCADE %>"
                       textBinding="shrinkSegCascadeMsg@"
                       selectedValueBinding="shrinkSegmentOption@" />
       

       <%-- Dependent Segments NOTE: remove once RDBMS bug 3194761 fixed--%>   
       <uix:header textBinding="RELATED_SEGMENTS@uixSchemaBundle@servletRequest">
       <uix:dataScope currentDataBinding="relatedSegments@shrinkBean@servletRequest">
        <uix:bundle name="schmMsgs" class="oracle.sysman.db.rsc.schm.SchemaMsg"/>
        <uix:tableLayout>
        <uix:table name="relatedSegsTable"
                   width="80%"
                   formSubmitted="true"
                   tableDataBinding="segmentsList@"
                   columnHeaderDataBinding="columnHeaders@"
                   columnFormatsBinding="columnFormats@"
                   blockSizeBinding="blockSize@"
                   maxValueBinding="maxValue@"
                   summaryBinding="RELATED_SEGMENTS@uixSchemaBundle@servletRequest"
                   valueBinding="startIndexUI@">
          
                 <uix:tableFormat tableBanding="rowBanding"/>
                 <uix:columnHeaderStamp>
                   <uix:sortableHeader textBinding="text" sortableBinding="sortable"/>
                 </uix:columnHeaderStamp>
                   <uix:styledText textBinding="schema"/>
                   <uix:styledText textBinding="segment"/>
                   <uix:styledText textBinding="type"/>
                   <uix:styledText textBinding="tablespace"/>
         </uix:table>
         </uix:tableLayout>
       </uix:dataScope>        
       </uix:header>

       <%-- Specify Segments to Shrink --%>   
       <%-- Replace once RDBMS bug 3194761 fixed 
       <uix:radioButton name="shrinkSingleSeg"
                        value="<%= SegmentShrinkConst.OPT_DEPENDENT_SEGS %>"
                        textBinding="SHRINK_RELATED_SEGS@uixSchemaBundle@servletRequest"
                        onClick="submitForm('shrinkForm', true, {event:'segSelection'})"
                        selectedValueBinding="shrinkSegmentOption@"  />
       --%>

       <%-- Related Segments --%>   
       <%-- Replace once RDBMS bug 3194761 fixed
       <uix:header textBinding="RELATED_SEGMENTS@uixSchemaBundle@servletRequest">
       <uix:dataScope currentDataBinding="relatedSegments@shrinkBean@servletRequest">
         <jsp:include page="/database/schema/utilities/relatedSegmentsTableInclude.jsp" />
         <uix:ref refID="relatedSegmentsTableInclude" />
       </uix:dataScope>        
       </uix:header>
       --%>

     </uix:stackLayout>     
     </uix:header>

  </uix:stackLayout>
  <%-- END: SEGMENT SHRINK CONTENTS ends here --%>   
        
  <%-- Show SQL, OK, and Schedule Buttons --%>
  <uix:pageButtons>
  <uix:pageButtonBar>

    <%-- SHOW SQL BUTTON --%>
    <uix:submitButton textBinding="SHOWSQL@uixDBObjectBundle@servletRequest" 
                      name="event" 
                      value="showSql" />

    <%-- CANCEL BUTTON --%>
    <uix:submitButton textBinding="CANCEL@uixDBObjectBundle@servletRequest" 
                      name="event" 
                      value="cancel" />

    <%-- SCHEDULE BUTTON --%>
    <uix:submitButton textBinding="CONTINUE@uixDBObjectBundle@servletRequest" 
                      name="event" 
                      value="schedule" />

  </uix:pageButtonBar>
  </uix:pageButtons>

</uix:pageLayout>
</db:form>
<%-- END: HTML Form --%>
</uix:dataScope>
</uix:body>

</uix:document>
</uix:renderingContext>
<%-- END: Content --%> 
