<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>

<%-- Name:        shrinkJobPage.jsp 
  -- Type:        Segment Shrink Job Page
  -- Description: This page is a standalone job page for scheduling a job.
  --              
  --
  --%> 

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>
<%@ page import="oracle.sysman.emo.adm.schema.utilities.shrink.SegmentShrinkConst" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>
<uix:bundle name="dbMsgs"
              class="oracle.sysman.db.rsc.DBObjectMsg"/>
<uix:bundle name="schmMsgs"
              class="oracle.sysman.db.rsc.schm.SchemaMsg"/>
 <uix:bundle name="stgMsg"
              class="oracle.sysman.db.rsc.shrinkAdv.ShrinkAdvMsg"/>
<uix:bundle name="sdkMsgs"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
<uix:document>

<%-- HTML Page Title : must have function getPageHeader --%>
<%@ include file="/oemTitle.jspf" %>

<uix:body>
 <uix:dataScope currentDataBinding="shrinkBean@servletRequest"> 

<%-- HTML Form --%>
<db:form name="shrinkForm"
         method="post"
         destinationBinding="destination@"
         copyParams="target,type,cancelURL,sname,oname,otype" >
<uix:formValue name="pageName" value="<%= SchemaPages.UTIL_SHRINK_JOB_PG %>"/>
<uix:pageLayout titleBinding="pageHeader@">

  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/global.jspf" %>

  <%-- Warning/Error display --%>
  <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error" 
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>

  <%-- START: SCHEDULE JOB CONTENTS starts here --%>
  <%-- segment information --%>
  <uix:pageStatus>
  <uix:labeledFieldLayout labelWidth="15%">
    <uix:messagePrompt promptBinding="SEGMENT@uixDBObjectBundle@servletRequest"/>
    <uix:styledText styleClass="OraDataText" textBinding="fullObjectName@"/>
    <uix:messagePrompt promptBinding="OBJECT_TYPE@uixDBObjectBundle@servletRequest"/>
    <uix:styledText styleClass="OraDataText" textBinding="objectTypeUI@"/>
  </uix:labeledFieldLayout>
  </uix:pageStatus>
  <uix:separator />

  <%-- job options start here --%>
  <uix:stackLayout>
 
    <%-- Intro Text --%>
    <uix:spacer height="5" width="1" />
    <uix:styledText styleClass="OraInstructionText" 
                    textBinding="SCHEDULE_INSTR@stgMsg" />
    <uix:spacer height="10" width="1"/>

    <%-- Job Name, Description --%>    
    <uix:labeledFieldLayout labelWidth="15%">
      <uix:messagePrompt promptBinding="JOB_NAME@schmMsgs"
                         required="yes"
                         labeledNodeId="jobName"/>
      <uix:textInput  id="jobName" 
                      name="jobName"
                      textBinding="jobName@"
                      columns="60"/>
      <uix:messagePrompt promptBinding="JOB_DESC@schmMsgs"
                         labeledNodeId="jobDescription"/>
      <uix:textInput id="jobDescription"
                     name="jobDescription"
                     textBinding="jobDescription@"
                     columns="60"/>
    </uix:labeledFieldLayout>    
    <uix:spacer height="10" width="1"/> 

    <%-- Scheduling Option --%>
     <uix:header textBinding="SCHED_OPT_HDR@schmMsgs">
        <uix:tableLayout cellSpacing="5">
            <%-- START TIME ZONE --%>
            <uix:cellFormat hAlign="right">
            <uix:messagePrompt labeledNodeId="TIME_ZONE"
                  promptBinding="TIME_ZONE@sdkMsgs"/>
            </uix:cellFormat>
            <uix:cellFormat>
              <oem:choice id="TIME_ZONE"
                  name="startTimeZoneSB"
                  optionsBinding="timeZonesSB@scheduleBean@servletRequest"
                  selectedValueBinding="startTimeZoneSB@scheduleBean@servletRequest"/>
            </uix:cellFormat>
        </uix:tableLayout>
        <%@ include file="/database/instance/scheduler/schedule/start.jspf" %> 
    </uix:header>    
  </uix:stackLayout>
  <%-- END: SCHEUDLE JOB CONTENTS ends here --%>   
        
  <%-- Show SQL, OK, and Schedule Buttons --%>
  <uix:pageButtons>
  <uix:pageButtonBar>

    <%-- CANCEL BUTTON --%>
    <uix:submitButton textBinding="CANCEL@uixDBObjectBundle@servletRequest" 
                      shortDescBinding="CANCEL@uixDBObjectBundle@servletRequest"
                      name="event" 
                      value="cancel" />

    <%-- BACK BUTTON --%>
    <uix:submitButton textBinding="BACK@uixDBObjectBundle@servletRequest" 
                      shortDescBinding="BACK@uixDBObjectBundle@servletRequest"
                      name="event" 
                      value="<%= SegmentShrinkConst.BACK %>" />

    <%-- OK BUTTON --%>
    <uix:submitButton textBinding="SUBMIT@uixDBObjectBundle@servletRequest" 
                      shortDescBinding="SUBMIT@uixDBObjectBundle@servletRequest"
                      name="event" 
                      value="submitDBJob" />

  </uix:pageButtonBar>
  </uix:pageButtons>

</uix:pageLayout>
</db:form>
<%-- END: HTML Form --%>
 </uix:dataScope> 
</uix:body>

</uix:document>
</uix:renderingContext>
<%-- END: Content --%> 

