 <%@ include file="/sdk/oemTop.jspf" %>
<%-- Name:        spaceUsagePage.jsp 
  -- Description: This page contains the complete UI for space usage for a
  --              schema object.(table, index, mview, mviewlog) 
  --
  -- JSP Changes: To use this page,  include this page as a 'macro' include
  --              in your space usage page jsp.  In your JSP you must include the
  --              oem taglib.
  --%> 

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<NOSCRIPT>
A browser with Javascript enabled is required for this page to operate properly.
</NOSCRIPT>

<db:script src="/database/utils.js"/>

<uix:renderingContext id="renderingContext">
<uix:bundle name="schmMsgs" class="oracle.sysman.db.rsc.schm.SchemaMsg"/>
<uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>
<oem:setURLEncoder id="renderingContext"/>
<uix:document>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>

<%-- HTML Page Title --%>
<%-- Fix Bug 4080599, for future release
<%@ include file="/oemTitle.jspf" %>
--%>
<uix:metaContainer>
  <%-- uix:head titleBinding="title@spaceUsageBean@servletRequest"/--%>
  <uix:head titleBinding="title@objectBean@servletRequest"/>
</uix:metaContainer>

<uix:body>

<%-- HTML Form --%>
<db:form nameBinding="formName@objectBean@servletRequest"
         destinationBinding="destination@objectBean@servletRequest"
         copyParams="target,type,cancelURL,sname,oname,otype" >
<uix:formValue name="pageName" value="/database/schema/utilities/spaceUsagePage"/>
<uix:formValue name="value" />
<uix:formValue name="source" />
<uix:pageLayout titleBinding="header@objectBean@servletRequest">

  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/global.jspf" %>

  <%-- Warning/Error display --%>
  <oem:messageBox messageType="info"
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error"
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>

  <%-- Create/Edit/View Header --%>
  <uix:subTabLayout>

    <%-- SubTabs --%>
    <uix:subTabs>
      <uix:switcher childNameBinding="currSchemaObjectType@objectBean@servletRequest">

        <uix:case name="0"> <%-- table --%>
          <jsp:include page="/database/schema/table/subTabsInclude.jsp" />
          <uix:ref refID="subTabsInclude" />
        </uix:case>

        <uix:case name="1"> <%-- index --%>
          <jsp:include page="/database/schema/index/subTabsInclude.jsp" />
          <uix:ref refID="indexSubTabsInclude" />
        </uix:case>

        <uix:case name="2"> <%-- mview --%>
          <jsp:include page="/database/schema/mview/subTabsInclude.jsp" />
          <uix:ref refID="mviewSubTabsInclude" />
        </uix:case>

        <%-- mview log --%>
        <uix:case name="3"> 
          <jsp:include page="/database/schema/mvlog/subTabsInclude.jsp" />
          <uix:ref refID="mvLogSubTabsInclude" />
        </uix:case>


      </uix:switcher>

    </uix:subTabs>

    <uix:tableLayout>

      <%-- START: Related Segments Information --%>
      <uix:header textBinding="RELATED_SEGMENTS@schmMsgs">
        <uix:dataScope currentDataBinding="relatedSegsBean@servletRequest">
          <jsp:include page="/database/schema/utilities/relatedSegmentsTableInclude.jsp" />
          <uix:ref refID="relatedSegmentsTableInclude"/>
        </uix:dataScope>

        <uix:tip>
          <uix:styledText styleClass="OraTipText"
                          textBinding="SPACE_USAGE_REFRESH_TIP@schmMsgs" />
        </uix:tip>
      </uix:header> 

      <%-- START: Space Usage Trend Chart --%>
      <uix:header textBinding="segmentUsageTrendTitle@relatedSegsBean@servletRequest">
        <uix:stackLayout> 
  <oem:messageBox messageType="info"
                  errorTableBinding="chartInfo@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
          <uix:rowLayout>
            <uix:messagePrompt labeledNodeId="FROM" promptBinding="FROM@schmMsgs"/>
            <uix:spacer width="5"/>
            <uix:dateField name="fromDate" id="FROM" columns="10"
                           valueBinding="fromDate@spaceUsageBean@servletRequest"/>
            <uix:spacer width="10"/>
            <uix:messagePrompt labeledNodeId="TO" promptBinding="TO@schmMsgs"/>
            <uix:spacer width="5"/>
            <uix:dateField  name="toDate" id="TO" columns="10" 
                            valueBinding="toDate@spaceUsageBean@servletRequest" />
            <uix:spacer width="15"/>
            <uix:submitButton textBinding="REFRESH@dbMsgs" name="event" value="refreshTrend" />
          </uix:rowLayout>
    
        <%-- CHART --%>
          <jsp:include page="/database/schema/utilities/objectGrowthTrendChart.jsp"/>
          <uix:ref refID="objectGrowthTrendChartInclude"/>
        <%-- END: CHART --%>

         <uix:rowLayout>
          <uix:tip>
             <uix:styledText styleClass="OraTipText"
                             textBinding="SPACE_USAGE_TREND_TIP@schmMsgs" />
          </uix:tip>
         </uix:rowLayout>
       </uix:stackLayout>
     </uix:header>
     <%-- END: Space Usage Trend Information --%>

   </uix:tableLayout>

  </uix:subTabLayout>

  <%-- Create/Edit Buttons --%>
  <uix:pageButtons>
  <uix:pageButtonBar>
    <jsp:include page="/database/schema/pageButtonInclude.jsp" />
    <uix:ref refID="pageButtonInclude" />
  </uix:pageButtonBar>
  </uix:pageButtons>

</uix:pageLayout>
</db:form>
<%-- END: HTML Form --%>

</uix:body>
</uix:document>
</uix:renderingContext>
<%-- END: Content --%>


