<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%--
  -- Page:       selectTablespacePage.jsp
  -- Controller: db/adm/schm/*Controller.java - used by several controllers
  -- Description: Tablespace LOV used be several of the schema objects - usually 
  --              only available on CREATE.
  --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<% oracle.cabo.share.util.CaboHttpUtils.setNoCacheHeaders(response); %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>
<%@ page import="oracle.sysman.emo.adm.schema.table.TableConst" %>


<uix:renderingContext id="renderingContext">
  <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>
  <uix:bundle name="tblMsgs" class="oracle.sysman.db.rsc.schm.TableMsg"/>
  <uix:bundle name="msgs" class="oracle.sysman.db.rsc.schm.PartitionsMsg"/>
  <uix:bundle name="spatialMsgs" class="oracle.sysman.db.rsc.sptl.SpatialMsg"/>  
<oem:setURLEncoder id="renderingContext"/>
<uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="SEARCH_AND_SELECT_HEADER@dbMsgs"/>
       <script language="JavaScript" >
        <%@ include file="/database/utils.js"%>
        </script>
      <script language="JavaScript" >
        <%@ include file="/cabo/jsLibs/TableProxy.js" %>
      </script>

      <script>
      
        function lovSelect()
        {
          var appendData = "";
          var proxy = new TableProxy('SRIDTableUI');
          var selectedIndex = proxy.getSelectedRow();
          if (selectedIndex >= 0)
          {
            var selectedElement = proxy.getFormElement('srid', selectedIndex);
            var selectedElementValue = selectedElement.value;
            window.opener.document.tblForm.srid.value = selectedElementValue;
            window.opener.document.tblForm.event.value = "srid_change_submit";
            window.opener.document.tblForm.submit();
            window.close();
          }
          
        }
      </script>

     </uix:metaContainer>

<uix:body>

<%-- HTML Form --%>
<db:form name="tblFormSRID"
         method="post"
         destinationBinding="forEnterHandling@servletRequest"
         copyParams="target,type,otype">

<uix:formValue name="pageName" value="<%= SchemaPages.TBL_SPTL_SRIDS %>"/> 



<uix:pageLayout titleBinding="SEARCH_AND_SELECT_HEADER@dbMsgs">


  <uix:tableLayout width="100%" >
    <uix:rowLayout>
      <uix:spacer height="5" />
    </uix:rowLayout>    
    <uix:rowLayout>
    
      <uix:cellFormat width="80%">
        <uix:spacer width="5" />
      </uix:cellFormat>
    
    
      <uix:cellFormat>
	  <uix:button textBinding="CANCEL@dbMsgs" shortDescBinding="CANCEL@dbMsgs" destination="javascript:window.close();" />
      </uix:cellFormat>
      
       <uix:cellFormat>
        <uix:spacer width="5" />
      </uix:cellFormat>
      
      
      <uix:cellFormat hAlign="right">
        <uix:switcher childNameBinding="selectBut@servletRequest">
          <uix:case name="true">  
            <uix:button textBinding="SELECT@dbMsgs" shortDescBinding="SELECT@dbMsgs" destination="javascript:lovSelect()" />
          </uix:case>
        </uix:switcher>  
      </uix:cellFormat hAlign="right">
 
    </uix:rowLayout>
  </uix:tableLayout>



<uix:header textBinding ="SEARCH@dbMsgs">

  <uix:tableLayout>
    <uix:rowLayout>
      <uix:cellFormat>
      <uix:tip>
      		    <uix:styledText textBinding="SEARCH_SRID_INSTRUCTION@spatialMsgs" styleClass="OraTipText"/>
				
		  </uix:tip>
		  </uix:cellFormat>
		  </uix:rowLayout>
	      </uix:tableLayout>
	       <uix:spacer height="10" />
      <uix:tableLayout>
    <uix:rowLayout>
      <uix:cellFormat>
        <uix:styledText textBinding="SEARCH_COORDINATE_SYSTEM@spatialMsgs" styleClass="OraHeaderSubSub"/>
      </uix:cellFormat>
      <uix:cellFormat>
        <uix:spacer width="5" />
      </uix:cellFormat>      
      <uix:cellFormat>
      
      <uix:messageTextInput name="cs_key" 
      textBinding="spatialCskey@SpatialBean@servletRequest"
     
      columns="25"
	  shortDescBinding="SEARCH_COORDINATE_SYSTEM@spatialMsgs"/>

       </uix:cellFormat> 
      <uix:cellFormat>
        <uix:submitButton formName="tblFormSRID" textBinding="GO@dbMsgs"
	shortDescBinding="GO@dbMsgs" name="event" value="search_srid"/>
      
      </uix:cellFormat>      
    </uix:rowLayout>
  </uix:tableLayout>
</uix:header>

<uix:header textBinding="RESULTS@dbMsgs">
             <oem:table name="SRIDTableUI" 
                     beanKey="sridTableDS"
                     dataSourceProp="SRIDTableUI" 
                     summaryBinding="SEARCH_COORDINATE_SYSTEM@spatialMsgs"
					 blockSize="25" 
                     formSubmitted="true" 
                     width="90%" 
              alternateTextBinding="NO_ITEMS_FOUND@spatialMsgs" >
                        <uix:tableSelection>
                          <uix:singleSelection shortDesc="Select"
                                               selectedIndex="0"/>
                        </uix:tableSelection>
                     
          </oem:table>
</uix:header>



</uix:pageLayout>


  <uix:tableLayout width="100%" >
    <uix:rowLayout>
      <uix:spacer height="5" />
    </uix:rowLayout>    
    <uix:rowLayout>
    
      <uix:cellFormat width="80%">
        <uix:spacer width="5" />
      </uix:cellFormat>
   
     
     <uix:cellFormat>
        <uix:button textBinding="CANCEL@dbMsgs" shortDescBinding="CANCEL@dbMsgs" destination="javascript:window.close();" />
      </uix:cellFormat> 
  
      <uix:cellFormat>
        <uix:spacer width="5" />
      </uix:cellFormat>
      
      <uix:cellFormat hAlign="right">
        <uix:switcher childNameBinding="selectBut@servletRequest">
          <uix:case name="true">  
            <uix:button textBinding="SELECT@dbMsgs" shortDescBinding="SELECT@dbMsgs" destination="javascript:lovSelect()" />
          </uix:case>
        </uix:switcher>  
      </uix:cellFormat hAlign="right">

     
    </uix:rowLayout>
  </uix:tableLayout>


</db:form>
<%-- END: HTML Form --%>

</uix:body>
</uix:document>
</uix:renderingContext>
<%-- END: Content --%> 

