<%-- Name:        spatialStorageContextInclude.jsp 
  -- Type:        JSP Include 
  -- Description: This page contains the complete UI for storage for a
  --              schema object. 
  --
  -- EMO Beans:  You provide the name of your instance of the 
  --             SchemaObjectSegment bean as context to this include.
  --             Your controller must also add uixDBObjectBundle onto the
  --             request so messages can be retrieved correctly. Errors are expected
  --             to be in: errors@servletRequest
  -- 
  -- JSP Changes: To use this page, add the following to your jsp file:
  -- 
  --  <uix:dataScope currentDataBinding="<your segment bean>@servletRequest">
  --    <jsp:include page="/database/schema/utilities/spatialStorageContextInclude.jsp" />
  --    <uix:ref refID="storageInclude" />
  --  </uix:dataScope>
  --  
  -- Controller Changes:  
  --             Make your controller instaniate the emo beans listed
  --             above.  The name of the bean can be whatever you need.
  --             Make sure your controller calls beanUtils with your bean
  --             when submit form is called.
  --
  -- Initializer Changes:
  --             You must create a SegmentInitializer that extents from 
  --             SchemaObjectSegmentInitializer - see Table for an example.
  --
  -- Getting Storage To Initialize on CREATE:
  --             Currently you must override SchemaObjectSegment.java and then 
  --             override the getInitializer function to save your own 
  --             initializer.
  --             See TableSegment.java for an example.
  --             To make the page initialize everytime a tablespace changes,
  --             you must set the objects initialized variable to false
  --             whenever the tablespace changes.
  --%> 

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import="oracle.sysman.emo.adm.schema.SchemaObjectSegment" %>

<%-- STORAGE PAGE CONTENT --%>
<uix:buildTree nodeID="spatialstorageInclude">
<uix:dataScope>

<%-- Message Bundles Used --%>
<uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>

<%-- Layout --%>
<uix:tableLayout>

<%-- Tip & Tablespace --%>
<uix:rowLayout>
<uix:tableLayout cellSpacing="5" width="100%">

<%-- Tip --%>
<uix:rowLayout>
<uix:cellFormat>
  <uix:tip>
    <uix:styledText styleClass="OraTipText"
                    textBinding="STORAGE_TIP@dbMsgs" />
  </uix:tip>
</uix:cellFormat>
</uix:rowLayout>

<%-- START: Tablespace Information --%>
<uix:rowLayout>
<uix:cellFormat>
  <uix:header textBinding="TABLESPACE@dbMsgs">
  <uix:labeledFieldLayout columns="1">

    <%-- Tablespace Name : Note : using renderedBinding and not switcher due to layout problem --%>

    <%-- IF : changing the tblspace is allowed --%>
        <%-- Tablespace LOV w/ Change Button --%>
        <uix:messagePrompt promptBinding="NAME@dbMsgs"
                           labeledNodeId="TABLESPACE_ID" 
                           renderedBinding="changeTablespaceAvail@"/>
        <uix:tableLayout renderedBinding="changeTablespaceAvail@">
        <uix:rowLayout>
          <script language="javascript">    
            var destField;
            function callBackLov() { return (destField); }
          </script>
          <uix:messageLovField name="<%= SchemaObjectSegment.CHANGE_TABLESPACE %>"
                    id="TABLESPACE_ID"
                    textBinding="realTablespace@"
                    shortDescBinding="CLICKTOSELECTTABLESPACE@dbMsgs"
                    onClickBinding="tablespacelovdest@servletRequest"
                    disabledBinding="allDisabled@" />    
          <uix:submitButton textBinding="CHANGE@dbMsgs"
                    id="TABLESPACE_ID"
                    shortDescBinding="CHANGE@dbMsgs"
                    name="event"
                    value="<%= SchemaObjectSegment.CHANGE_TABLESPACE %>"
                    renderedBinding="new@"/>   
        </uix:rowLayout>
        </uix:tableLayout>

    <%-- ELSE IF : tablespace name is read only and can't be changed --%>
        <%-- Tablespace Name : Read Only Text --%>
        <uix:messageStyledText promptBinding="NAME@dbMsgs"
                    shortDescBinding="NAME@dbMsgs"
                    textBinding="realTablespace@" 
                    contentStyleClass="OraDataText"
                    renderedBinding="tablespaceReadOnly@"/>

    <%-- Tablespace Extent Management --%>
    <uix:switcher childNameBinding="locallyManaged@">
      <uix:case name="true">
        <uix:messageStyledText promptBinding="EXTENT_MGMT@dbMsgs"
                    shortDescBinding="EXTENT_MGMT@dbMsgs"
                    textBinding="LOCAL@dbMsgs" 
                    contentStyleClass="OraDataText"/>
      </uix:case>
      <uix:case name="false">
        <uix:messageStyledText promptBinding="EXTENT_MGMT@dbMsgs"
                    shortDescBinding="EXTENT_MGMT@dbMsgs"
                    textBinding="DICTIONARY@dbMsgs" 
                    contentStyleClass="OraDataText"/>
      </uix:case>
    </uix:switcher>

    <%-- Tablespace Segment Management --%>
    <uix:messageStyledText promptBinding="SEGMENT_MANAGEMENT@dbMsgs"
                    shortDescBinding="SEGMENT_MANAGEMENT@dbMsgs"
                    textBinding="segmentMgmt@" 
                    contentStyleClass="OraDataText"/>

 <%-- Logging 
    <uix:messageChoice name="loggingOpt" 
                    promptBinding="LOGGING@dbMsgs"
                    shortDescBinding="LOGGING@dbMsgs"
                    selectedValueBinding="loggingOpt@"
                    disabledBinding="loggingDisabled@" >
      <uix:option textBinding="DEFAULT_OPT@dbMsgs"
                  value="-1" />
      <uix:option textBinding="YES@dbMsgs"
                  value="1" />
      <uix:option textBinding="NO@dbMsgs"
                  value="0" />
    </uix:messageChoice> 
    
    <uix:messageStyledText promptBinding="LOGGING@dbMsgs"
                    shortDescBinding="LOGGING@dbMsgs"
                    textBinding="loggingOpt@" 
                    contentStyleClass="OraDataText"/> --%>
		    
 <uix:switcher childNameBinding="loggingOpt@">
      <uix:case name="1">
        <uix:messageStyledText promptBinding="LOGGING@dbMsgs"
                     shortDescBinding="LOGGING@dbMsgs"
                     textBinding="YES@dbMsgs" 
                     contentStyleClass="OraDataText"/>
      </uix:case>
      <uix:case name="0">
        <uix:messageStyledText promptBinding="LOGGING@dbMsgs"
                     shortDescBinding="LOGGING@dbMsgs"
                     textBinding="NO@dbMsgs" 
                     contentStyleClass="OraDataText"/>
      </uix:case>
      <uix:case name="-1">
        <uix:messageStyledText promptBinding="LOGGING@dbMsgs"
                     shortDescBinding="LOGGING@dbMsgs"
                     textBinding="DEFAULT_OPT@dbMsgs" 
                     contentStyleClass="OraDataText"/>
         </uix:case>
    </uix:switcher>

    
  </uix:labeledFieldLayout>
  </uix:header>
</uix:cellFormat>
</uix:rowLayout>
<%-- END: Tablespace Information --%>

</uix:tableLayout>
</uix:rowLayout>

<%-- Storage Data --%>
<uix:rowLayout>
<uix:tableLayout cellSpacing="5" width="100%">

<%-- START: Dictionary Extent Management --%>
<%-- For Dictionary Managed tablespaces, all extent management       --%>
<%-- is displayed all storage info in one table row which starts here --%>
<uix:rowLayout>
<uix:cellFormat vAlign="top" renderedBinding="dictionaryManaged@">

  <uix:header textBinding="EXTENTS@dbMsgs">
  <uix:tableLayout cellSpacing="5" >

    <%-- Inital Size --%>
    <uix:rowLayout>
      <uix:cellFormat hAlign="right">
        <uix:messagePrompt promptBinding="INITIAL_SIZE@dbMsgs" labeledNodeId="INITIAL_SIZE"/>
      </uix:cellFormat>
      <uix:stackLayout>
      <uix:flowLayout>
        <uix:textInput name="initExtentSize"
                       id="INITIAL_SIZE" shortDescBinding="INITIAL_SIZE@dbMsgs"
                       textBinding="initExtentSize@"
                       columns="10"
                       disabledBinding="disabled@">
          <uix:onSubmitValidater><uix:decimal /></uix:onSubmitValidater>
        </uix:textInput>
        <oem:choice name="initExtentSizeUnit"
                    id="INITIAL_SIZE" shortDescBinding="INITIAL_SIZE@dbMsgs"
                    optionsBinding="sizeUnitChoices@"
                    selectedValueBinding="initExtentSizeUnit@"
                    disabledBinding="disabled@"/>
      </uix:flowLayout>
        <uix:messageText  messageType="error" messageBinding="initExtentSize@errors@servletRequest" />
      </uix:stackLayout>
    </uix:rowLayout>

  <%-- Next Size --%>
  <uix:rowLayout>
    <uix:cellFormat hAlign="right">
      <uix:messagePrompt promptBinding="NEXT_SIZE@dbMsgs" labeledNodeId="NEXT_SIZE"/>
    </uix:cellFormat>
    <uix:stackLayout>
    <uix:flowLayout>
      <uix:textInput name="nextExtentSize" 
                     id="NEXT_SIZE" shortDescBinding="NEXT_SIZE@dbMsgs"
                     textBinding="nextExtentSize@"  
                     columns="10"
                     disabledBinding="allDisabled@">
        <uix:onSubmitValidater><uix:decimal /></uix:onSubmitValidater>
      </uix:textInput>
      <oem:choice name="nextExtentSizeUnit" 
                  id="NEXT_SIZE" shortDescBinding="NEXT_SIZE@dbMsgs"
                  optionsBinding="sizeUnitChoices@"  
                  selectedValueBinding="nextExtentSizeUnit@" 
                  disabledBinding="allDisabled@"/>
    </uix:flowLayout>
    <uix:messageText messageType="error" messageBinding="nextExtentSize@errors@servletRequest" />
    </uix:stackLayout>
  </uix:rowLayout>

  <%-- Increment Size --%>
  <uix:rowLayout renderedBinding="dictionaryManaged@">
    <uix:cellFormat hAlign="right">
      <uix:messagePrompt promptBinding="INCREMENT_SIZE@dbMsgs" labeledNodeId="INCREMENT_SIZE"/>
    </uix:cellFormat>
    <uix:cellFormat>
      <uix:stackLayout>
      <uix:textInput name="pctIncrease" 
                     id="INCREMENT_SIZE" shortDescBinding="INCREMENT_SIZE@dbMsgs"
                     textBinding="pctIncrease@"  
                     columns="10"
                     disabledBinding="allDisabled@">
        <uix:onSubmitValidater><uix:decimal /></uix:onSubmitValidater>
      </uix:textInput>
      <uix:messageText messageType="error" messageBinding="pctIncrease@errors@servletRequest" />
      </uix:stackLayout>
    </uix:cellFormat>
  </uix:rowLayout>

  <%-- Minimum Number --%>
  <uix:rowLayout renderedBinding="dictionaryManaged@">
    <uix:cellFormat hAlign="right">
      <uix:messagePrompt promptBinding="MINIMUM_NUMBER@dbMsgs" labeledNodeId="MINIMUM_NUMBER"/>
    </uix:cellFormat>
    <uix:stackLayout>
      <uix:textInput name="minExtents"
                     id="MINIMUM_NUMBER" shortDescBinding="MINIMUM_NUMBER@dbMsgs"
                     textBinding="minExtents@"
                     columns="10"
                     disabledBinding="allDisabled@">
        <uix:onSubmitValidater><uix:decimal /></uix:onSubmitValidater>
      </uix:textInput>
      <uix:messageText messageType="error" messageBinding="minExtents@errors@servletRequest" />
    </uix:stackLayout>
  </uix:rowLayout>

  <%-- Maximum Number --%>
  <uix:rowLayout renderedBinding="dictionaryManaged@">
    <uix:cellFormat hAlign="right">
      <uix:messagePrompt promptBinding="MAXIMUM_NUMBER@dbMsgs" labeledNodeId="MAXIMUM_NUMBER"/>
    </uix:cellFormat>
    <uix:stackLayout>
      <oem:radioButton name="unlimitedMaxExtents" 
                       value="true"
                       textBinding="UNLIMITED@dbMsgs"
                       selectedValueBinding="unlimitedMaxExtents@"
                       disabledBinding="allDisabled@"/>
      <uix:flowLayout>
        <oem:radioButton name="unlimitedMaxExtents" 
                         value="false"
                         textBinding="VALUE@dbMsgs"
                         selectedValueBinding="unlimitedMaxExtents@"
                         disabledBinding="allDisabled@"/>
        <uix:textInput name="maxExtents"
                       id="MAXIMUM_NUMBER" shortDescBinding="MAXIMUM_NUMBER@dbMsgs"
                       textBinding="maxExtents@"
                       columns="11"
                       disabledBinding="allDisabled@"/>
          <uix:onSubmitValidater><uix:decimal /></uix:onSubmitValidater>
      </uix:flowLayout>
    </uix:stackLayout>
    <uix:messageText messageType="error" messageBinding="maxExtents@errors@servletRequest" />
  </uix:rowLayout>

  </uix:tableLayout>
  </uix:header>

</uix:cellFormat>
<%-- END: Dictionary Extent Management --%>


<%-- START: Segment Storage and Locally Managed Initial Extent--%>
<uix:cellFormat vAlign="top">
  <uix:tableLayout>  

  <%-- Locally Managed: Initial Size --%>
  <uix:rowLayout renderedBinding="locallyManaged@">
  <uix:cellFormat vAlign="top">
  <uix:header textBinding="EXTENTS@dbMsgs">
  <uix:tableLayout cellSpacing="5">
    <uix:rowLayout>
      <uix:cellFormat hAlign="right">
        <uix:messagePrompt promptBinding="INITIAL_SIZE@dbMsgs" labeledNodeId="INITIAL_SIZE"/>
      </uix:cellFormat>
      <uix:stackLayout>
      <uix:flowLayout>
        <uix:textInput name="initExtentSize"
                       id="INITIAL_SIZE" shortDescBinding="INITIAL_SIZE@dbMsgs"
                       textBinding="initExtentSize@"
                       columns="10"
                       disabledBinding="disabled@">
          <uix:onSubmitValidater><uix:decimal /></uix:onSubmitValidater>
        </uix:textInput>
        <oem:choice name="initExtentSizeUnit"
                    optionsBinding="sizeUnitChoices@"
                    selectedValueBinding="initExtentSizeUnit@"
                    disabledBinding="disabled@"/>
      </uix:flowLayout>
        <uix:messageText  messageType="error" messageBinding="initExtentSize@errors@servletRequest" />
      </uix:stackLayout>
    </uix:rowLayout>
  </uix:tableLayout>
  </uix:header>
  </uix:cellFormat>
  </uix:rowLayout>
 
  
  </uix:tableLayout>

</uix:cellFormat>
</uix:rowLayout>

</uix:tableLayout>
</uix:rowLayout>
 

<%-- END: Segment Storage --%>

</uix:tableLayout>

</uix:dataScope>
</uix:buildTree>


