<%-- Name:        viewStorageContextInclude.jsp - 
  -- Type:        OEM JSP Include 
  -- Description: This page contains the complete UI for storage for a
  --              schema object in view form.  This page allows you to 
  --              specify the name of the bean where you want to pull 
  --              data from.
  -- See: storageContextInclude.jsp and tables jsps for further info and for
  --              an example.
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<%-- STORAGE PAGE CONTENT --%>
<uix:buildTree nodeID="viewStorageInclude">
<uix:dataScope>

<%-- Message Bundles Used --%>
<uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>

<uix:tableLayout width="100%">


<%-- START: Tablespace Information --%>
<uix:rowLayout>
<uix:tableLayout width="100%">
<uix:rowLayout>
<uix:cellFormat>
  <uix:header textBinding="TABLESPACE@dbMsgs">
  <uix:labeledFieldLayout columns="1">

    <%-- Tablespace Name --%>
    <uix:messageStyledText promptBinding="NAME@dbMsgs"
                    shortDescBinding="NAME@dbMsgs"
                    textBinding="realTablespace@" 
                    contentStyleClass="OraDataText"/>

    <%-- Tablespace Extent Management --%>
    <!-- Change Manager does not have this information so no show.  -->
    <uix:switcher childNameBinding="xmlInitialized@">
    <uix:case name="false">
     <uix:switcher childNameBinding="locallyManaged@">
      <uix:case name="true">
        <uix:messageStyledText promptBinding="EXTENT_MGMT@dbMsgs"
                     shortDescBinding="EXTENT_MGMT@dbMsgs"
                     textBinding="LOCAL@dbMsgs" 
                     contentStyleClass="OraDataText"/>
      </uix:case>
      <uix:case name="false">
        <uix:messageStyledText promptBinding="EXTENT_MGMT@dbMsgs"
                     shortDescBinding="EXTENT_MGMT@dbMsgs"
                     textBinding="DICTIONARY@dbMsgs" 
                     contentStyleClass="OraDataText"/>
      </uix:case>
     </uix:switcher>
    </uix:case>
    </uix:switcher>

    <%-- Tablespace Segment Management --%>
    <!-- Change Manager does not have this information so no show.  -->
    <uix:switcher childNameBinding="xmlInitialized@">
    <uix:case name="false">
      <uix:messageStyledText promptBinding="SEGMENT_MANAGEMENT@dbMsgs"
                      shortDescBinding="SEGMENT_MANAGEMENT@dbMsgs"
                      textBinding="segmentMgmt@" 
                      contentStyleClass="OraDataText"/>
    </uix:case>
    </uix:switcher>

    <uix:switcher childNameBinding="xmlInitialized@">
    <uix:case name="false">
      <uix:messageStyledText promptBinding="ALLOCATION_TYPE@dbMsgs"
                    shortDescBinding="ALLOCATION_TYPE@dbMsgs"
                    textBinding="allocationType@" 
                    contentStyleClass="OraDataText"/>
    </uix:case>
    </uix:switcher>

    <%-- Logging --%>
    <uix:switcher childNameBinding="loggingOpt@">
      <uix:case name="1">
        <uix:messageStyledText promptBinding="LOGGING@dbMsgs"
                     shortDescBinding="LOGGING@dbMsgs"
                     textBinding="YES@dbMsgs" 
                     contentStyleClass="OraDataText"/>
      </uix:case>
      <uix:case name="0">
        <uix:messageStyledText promptBinding="LOGGING@dbMsgs"
                     shortDescBinding="LOGGING@dbMsgs"
                     textBinding="NO@dbMsgs" 
                     contentStyleClass="OraDataText"/>
      </uix:case>
    </uix:switcher>

  </uix:labeledFieldLayout>
  </uix:header>
</uix:cellFormat>
</uix:rowLayout>
<%-- END: Tablespace Information --%>

</uix:tableLayout>
</uix:rowLayout>

<%-- Storage Layout --%>
<uix:rowLayout>
<uix:tableLayout cellSpacing="5" width="100%">

<%-- START: Extents : DICTIONARY MANAGED only --%>
<uix:rowLayout>
<uix:cellFormat vAlign="top">
  <uix:switcher childNameBinding="showExtentAttributes@">

  <%-- Dictionary Managed --%>
  <uix:case name="true">
  <uix:header textBinding="EXTENTS@dbMsgs">
  <uix:tableLayout>

    <%-- Inital Size --%>
    <uix:rowLayout>
      <uix:cellFormat hAlign="right">
        <uix:messagePrompt promptBinding="INITIAL_SIZE@dbMsgs"/>
      </uix:cellFormat>
      <uix:cellFormat>
        <uix:spacer height="1" width="5" /> 
      </uix:cellFormat>
      <uix:cellFormat>
      <uix:flowLayout>
        <uix:styledText styleClass="OraDataText"
                        textBinding="initExtentSize@" />
        <uix:styledText styleClass="OraDataText"
                        textBinding="initExtentSizeUnit@" />
      </uix:flowLayout>
      </uix:cellFormat>
    </uix:rowLayout>

    <%-- Next Size --%>
    <uix:rowLayout>
      <uix:cellFormat hAlign="right">
        <uix:messagePrompt promptBinding="NEXT_SIZE@dbMsgs"/>
      </uix:cellFormat>
      <uix:cellFormat>
        <uix:spacer height="1" width="5" /> 
      </uix:cellFormat>
      <uix:cellFormat>
      <uix:flowLayout>
        <uix:styledText styleClass="OraDataText"
                        textBinding="nextExtentSize@" />
        <uix:styledText styleClass="OraDataText"
                        textBinding="nextExtentSizeUnit@" />
      </uix:flowLayout>
      </uix:cellFormat>
    </uix:rowLayout>

    <%-- Increment Size --%>
    <uix:rowLayout>
      <uix:cellFormat hAlign="right">
        <uix:messagePrompt promptBinding="INCREMENT_SIZE@dbMsgs" />
      </uix:cellFormat>
      <uix:cellFormat>
        <uix:spacer height="1" width="5" /> 
      </uix:cellFormat>
      <uix:cellFormat>
        <uix:styledText styleClass="OraDataText"
                        textBinding="pctIncrease@" />
      </uix:cellFormat>
    </uix:rowLayout>

    <%-- Minimum Number --%>
    <uix:rowLayout>
      <uix:cellFormat hAlign="right">
        <uix:messagePrompt promptBinding="MINIMUM_NUMBER@dbMsgs"/>
      </uix:cellFormat>
      <uix:cellFormat>
        <uix:spacer height="1" width="5" /> 
      </uix:cellFormat>
      <uix:cellFormat hAlign="left">
        <uix:styledText styleClass="OraDataText"
                        textBinding="minExtents@" />
      </uix:cellFormat>
    </uix:rowLayout>

    <%-- Maximum Number --%>
    <uix:rowLayout vAlign="top">
      <uix:cellFormat hAlign="right">
        <uix:messagePrompt promptBinding="MAXIMUM_NUMBER@dbMsgs" />
      </uix:cellFormat>
      <uix:cellFormat>
        <uix:spacer height="1" width="5" /> 
      </uix:cellFormat>
      <uix:cellFormat hAlign="left">
        <uix:styledText styleClass="OraDataText"
                        textBinding="maxExtents@" />
      </uix:cellFormat>
    </uix:rowLayout>
  </uix:tableLayout>
  </uix:header>
  </uix:case>
  </uix:switcher>
</uix:cellFormat>
<%-- END: Extent Management : DICTIONARY MANAGED only --%>

<%-- START: Segment Storage --%>
<uix:cellFormat vAlign="top">
  <uix:tableLayout>  

  <uix:rowLayout>

  <%-- Space Usage --%>
  <uix:cellFormat vAlign="top">
    <uix:header textBinding="SPACE_USAGE@dbMsgs">
    <uix:tableLayout>
    <uix:rowLayout>
      <uix:cellFormat hAlign="right">
        <uix:messagePrompt promptBinding="FREE_SPACE_PCT@dbMsgs"/>
      </uix:cellFormat>
      <uix:cellFormat>
        <uix:spacer height="1" width="5" /> 
      </uix:cellFormat>
      <uix:cellFormat hAlign="left">
        <uix:styledText styleClass="OraDataText"
                        textBinding="pctFree@" />
      </uix:cellFormat>
    </uix:rowLayout>
    <uix:switcher childNameBinding="pctUsedAvailable@">
    <uix:case name="true">
    <uix:rowLayout>
      <uix:cellFormat hAlign="right">
        <uix:messagePrompt promptBinding="USED_SPACE_PCT@dbMsgs"/>
      </uix:cellFormat>
      <uix:cellFormat>
        <uix:spacer height="1" width="5" /> 
      </uix:cellFormat>
      <uix:cellFormat hAlign="left">
        <uix:styledText styleClass="OraDataText"
                        textBinding="pctUsed@" />
      </uix:cellFormat>
    </uix:rowLayout>      
    </uix:case>
    </uix:switcher>
    </uix:tableLayout>
    </uix:header>
  </uix:cellFormat>

  <%-- Free Lists --%>
  <uix:cellFormat vAlign="top">
    <uix:switcher childNameBinding="freeListAvailable@">
    <uix:case name="true">
    <uix:stackLayout>
    <uix:header textBinding="FREE_LISTS@dbMsgs">
    <uix:tableLayout>
    <uix:rowLayout>
      <uix:cellFormat hAlign="right">
        <uix:messagePrompt promptBinding="FREE_LISTS@dbMsgs"/>
      </uix:cellFormat>
      <uix:cellFormat>
        <uix:spacer height="1" width="5" /> 
      </uix:cellFormat>
      <uix:cellFormat hAlign="left">
        <uix:styledText styleClass="OraDataText"
                        textBinding="freeLists@" />
      </uix:cellFormat>
    </uix:rowLayout>
    <uix:rowLayout>
      <uix:cellFormat hAlign="right">
        <uix:messagePrompt promptBinding="FREE_LIST_GROUPS@dbMsgs"/>
      </uix:cellFormat>
      <uix:cellFormat>
        <uix:spacer height="1" width="5" /> 
      </uix:cellFormat>
      <uix:cellFormat hAlign="left">
        <uix:styledText styleClass="OraDataText"
                        textBinding="freeListGroups@" />
      </uix:cellFormat>
    </uix:rowLayout>
    </uix:tableLayout>
    </uix:header>
    </uix:stackLayout>
    </uix:case>
    </uix:switcher>
  </uix:cellFormat>

  </uix:rowLayout>

  <uix:rowLayout>

  <%-- Number of Transactions --%>
  <uix:cellFormat vAlign="top">
    <uix:header textBinding="NUM_OF_TRAN@dbMsgs">
    <uix:tableLayout>
    <uix:rowLayout>
      <uix:cellFormat hAlign="right">
        <uix:messagePrompt promptBinding="INITIAL@dbMsgs"/>
      </uix:cellFormat>
      <uix:cellFormat>
        <uix:spacer height="1" width="5" /> 
      </uix:cellFormat>
      <uix:cellFormat hAlign="left">
        <uix:styledText styleClass="OraDataText"
                        textBinding="iniTrans@" />
      </uix:cellFormat>
    </uix:rowLayout>
    <uix:rowLayout>
      <uix:cellFormat hAlign="right">
        <uix:messagePrompt promptBinding="MAXIMUM@dbMsgs"/>
      </uix:cellFormat>
      <uix:cellFormat>
        <uix:spacer height="1" width="5" /> 
      </uix:cellFormat>
      <uix:cellFormat hAlign="left">
        <uix:styledText styleClass="OraDataText"
                        textBinding="maxTrans@" />
      </uix:cellFormat>
    </uix:rowLayout>
    </uix:tableLayout>
    </uix:header>
  </uix:cellFormat>

  <%-- Buffer Pool --%>
  <uix:cellFormat vAlign="top">
    <uix:header textBinding="BUFFER_POOL@dbMsgs">
    <uix:tableLayout>
    <uix:rowLayout>
      <uix:cellFormat hAlign="right">
        <uix:messagePrompt promptBinding="BUFFER_POOL@dbMsgs"/>
      </uix:cellFormat>
      <uix:cellFormat>
        <uix:spacer height="1" width="5" /> 
      </uix:cellFormat>
      <uix:cellFormat hAlign="left">
        <uix:styledText styleClass="OraDataText"
                        textBinding="bufferPool@" />
      </uix:cellFormat>
    </uix:rowLayout>
    </uix:tableLayout>
    </uix:header>
  </uix:cellFormat>

  </uix:rowLayout>

  </uix:tableLayout>
</uix:cellFormat>
</uix:rowLayout>
</uix:tableLayout>
</uix:rowLayout>
<%-- END: Segment Storage --%>

</uix:tableLayout>

</uix:dataScope>
</uix:buildTree>
