<%-- Name:        viewStorageInclude.jsp - view version of the storage page
  -- Type:        OEM JSP Include 
  -- Description: This page contains the complete UI for storage for a
  --              schema object. 
  --
  -- EMO Beans:  attribute name      | attribute value ( instance of... )
  --             ========================================================
  --             segmentBean         | SchemaObjectSegment.java      
  --             storageClauseBean   | SchemaObjectStorageClause.java 
  --             storageClauseUIBean | SchemaObjectStorageClauseUI.java
  -- 
  -- JSP Changes: To use this page,  include this page as a 'macro' include
  --              in your storage page jsp.  In your JSP you must include the
  --              oem taglib.
  -- 
  -- Controller Changes:  
  --             Make your controller instaniate the emo beans listed
  --             above.  The name of each bean must match the names above.
  --             Make sure your controller calls beanUtils for these beans
  --             when submit form is called.
  --
  -- Initializer Changes:
  --             You must create a SegmentInitializer that extents from 
  --             SchemaObjectSegmentInitializer - see Table for an example.
  --
  -- Getting Storage To Initialize on CREATE:
  --             Currently you must override SchemaObjectSegment.java and then 
  --             override the getInitializer function to save your own 
  --             initializer.
  --             See TableSegment.java for an example.
  --             To make the page initialize everytime a tablespace changes,
  --             you must set the objects initialized variable to false
  --             whenever the tablespace changes.
  --%> 

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<%-- STORAGE PAGE CONTENT --%>
<uix:buildTree nodeID="viewStorageInclude">
<uix:tableLayout width="100%">
<uix:rowLayout>

<%-- START: Extents : DICTIONARY MANAGED only --%>
<uix:cellFormat vAlign="top">
  <uix:switcher childNameBinding="locallyManaged@segmentBean@servletRequest">

  <%-- Dictionary Managed --%>
  <uix:case name="false">
  <uix:header textBinding="EXTENTS@uixDBObjectBundle@servletRequest">
  <uix:tableLayout>

    <%-- Inital Size --%>
    <uix:rowLayout>
      <uix:cellFormat hAlign="right">
        <uix:messagePrompt promptBinding="INITIAL_SIZE@uixDBObjectBundle@servletRequest"/>
      </uix:cellFormat>
      <uix:cellFormat>
        <uix:spacer height="1" width="5" /> 
      </uix:cellFormat>
      <uix:cellFormat>
      <uix:flowLayout>
        <uix:styledText styleClass="OraDataText"
                        textBinding="initExtentSize@storageClauseBean@servletRequest" />
        <uix:styledText styleClass="OraDataText"
                        textBinding="initExtentSizeUnit@storageClauseBean@servletRequest" />
      </uix:flowLayout>
      </uix:cellFormat>
    </uix:rowLayout>

    <%-- Next Size --%>
    <uix:rowLayout>
      <uix:cellFormat hAlign="right">
        <uix:messagePrompt promptBinding="NEXT_SIZE@uixDBObjectBundle@servletRequest"/>
      </uix:cellFormat>
      <uix:cellFormat>
        <uix:spacer height="1" width="5" /> 
      </uix:cellFormat>
      <uix:cellFormat>
      <uix:flowLayout>
        <uix:styledText styleClass="OraDataText"
                        textBinding="nextExtentSize@storageClauseBean@servletRequest" />
        <uix:styledText styleClass="OraDataText"
                        textBinding="nextExtentSizeUnit@storageClauseBean@servletRequest" />
      </uix:flowLayout>
      </uix:cellFormat>
    </uix:rowLayout>

    <%-- Increment Size --%>
    <uix:rowLayout>
      <uix:cellFormat hAlign="right">
        <uix:messagePrompt promptBinding="INCREMENT_SIZE@uixDBObjectBundle@servletRequest" />
      </uix:cellFormat>
      <uix:cellFormat>
        <uix:spacer height="1" width="5" /> 
      </uix:cellFormat>
      <uix:cellFormat>
        <uix:styledText styleClass="OraDataText"
                        textBinding="pctIncrease@storageClauseBean@servletRequest" />
      </uix:cellFormat>
    </uix:rowLayout>

    <%-- Minimum Number --%>
    <uix:rowLayout>
      <uix:cellFormat hAlign="right">
        <uix:messagePrompt promptBinding="MINIMUM_NUMBER@uixDBObjectBundle@servletRequest"/>
      </uix:cellFormat>
      <uix:cellFormat>
        <uix:spacer height="1" width="5" /> 
      </uix:cellFormat>
      <uix:cellFormat hAlign="left">
        <uix:styledText styleClass="OraDataText"
                        textBinding="minExtents@storageClauseBean@servletRequest" />
      </uix:cellFormat>
    </uix:rowLayout>

    <%-- Maximum Number --%>
    <uix:rowLayout vAlign="top">
      <uix:cellFormat hAlign="right">
        <uix:messagePrompt promptBinding="MAXIMUM_NUMBER@uixDBObjectBundle@servletRequest" />
      </uix:cellFormat>
      <uix:cellFormat>
        <uix:spacer height="1" width="5" /> 
      </uix:cellFormat>
      <uix:cellFormat hAlign="left">
        <uix:styledText styleClass="OraDataText"
                        textBinding="maxExtents@storageClauseBean@servletRequest" />
      </uix:cellFormat>
    </uix:rowLayout>
  </uix:tableLayout>
  </uix:header>
  </uix:case>
  </uix:switcher>
</uix:cellFormat>
<%-- END: Extent Management : DICTIONARY MANAGED only --%>

<%-- START: Segment Storage --%>
<uix:cellFormat vAlign="top">
  <uix:tableLayout>  

  <uix:rowLayout>

  <%-- Space Usage --%>
  <uix:cellFormat vAlign="top">
    <uix:header textBinding="SPACE_USAGE@uixDBObjectBundle@servletRequest">
    <uix:tableLayout>
    <uix:rowLayout>
      <uix:cellFormat hAlign="right">
        <uix:messagePrompt promptBinding="FREE_SPACE_PCT@uixDBObjectBundle@servletRequest"/>
      </uix:cellFormat>
      <uix:cellFormat>
        <uix:spacer height="1" width="5" /> 
      </uix:cellFormat>
      <uix:cellFormat hAlign="left">
        <uix:styledText styleClass="OraDataText"
                        textBinding="pctFree@segmentBean@servletRequest" />
      </uix:cellFormat>
    </uix:rowLayout>
    <uix:switcher childNameBinding="pctUsedAvailable@segmentBean@servletRequest">
    <uix:case name="true">
    <uix:rowLayout>
      <uix:cellFormat hAlign="right">
        <uix:messagePrompt promptBinding="USED_SPACE_PCT@uixDBObjectBundle@servletRequest"/>
      </uix:cellFormat>
      <uix:cellFormat>
        <uix:spacer height="1" width="5" /> 
      </uix:cellFormat>
      <uix:cellFormat hAlign="left">
        <uix:styledText styleClass="OraDataText"
                        textBinding="pctUsed@segmentBean@servletRequest" />
      </uix:cellFormat>
    </uix:rowLayout>      
    </uix:case>
    </uix:switcher>
    </uix:tableLayout>
    </uix:header>
  </uix:cellFormat>

  <%-- Free Lists --%>
  <uix:cellFormat vAlign="top">
    <uix:switcher childNameBinding="freeListAvailable@segmentBean@servletRequest">
    <uix:case name="true">
    <uix:stackLayout>
    <uix:header textBinding="FREE_LISTS@uixDBObjectBundle@servletRequest">
    <uix:tableLayout>
    <uix:rowLayout>
      <uix:cellFormat hAlign="right">
        <uix:messagePrompt promptBinding="FREE_LISTS@uixDBObjectBundle@servletRequest"/>
      </uix:cellFormat>
      <uix:cellFormat>
        <uix:spacer height="1" width="5" /> 
      </uix:cellFormat>
      <uix:cellFormat hAlign="left">
        <uix:styledText styleClass="OraDataText"
                        textBinding="freeLists@storageClauseBean@servletRequest" />
      </uix:cellFormat>
    </uix:rowLayout>
    <uix:rowLayout>
      <uix:cellFormat hAlign="right">
        <uix:messagePrompt promptBinding="FREE_LIST_GROUPS@uixDBObjectBundle@servletRequest"/>
      </uix:cellFormat>
      <uix:cellFormat>
        <uix:spacer height="1" width="5" /> 
      </uix:cellFormat>
      <uix:cellFormat hAlign="left">
        <uix:styledText styleClass="OraDataText"
                        textBinding="freeListGroups@storageClauseBean@servletRequest" />
      </uix:cellFormat>
    </uix:rowLayout>
    </uix:tableLayout>
    </uix:header>
    </uix:stackLayout>
    </uix:case>
    </uix:switcher>
  </uix:cellFormat>

  </uix:rowLayout>

  <uix:rowLayout>

  <%-- Number of Transactions --%>
  <uix:cellFormat vAlign="top">
    <uix:header textBinding="NUM_OF_TRAN@uixDBObjectBundle@servletRequest">
    <uix:tableLayout>
    <uix:rowLayout>
      <uix:cellFormat hAlign="right">
        <uix:messagePrompt promptBinding="INITIAL@uixDBObjectBundle@servletRequest"/>
      </uix:cellFormat>
      <uix:cellFormat>
        <uix:spacer height="1" width="5" /> 
      </uix:cellFormat>
      <uix:cellFormat hAlign="left">
        <uix:styledText styleClass="OraDataText"
                        textBinding="iniTrans@segmentBean@servletRequest" />
      </uix:cellFormat>
    </uix:rowLayout>
    <uix:rowLayout>
      <uix:cellFormat hAlign="right">
        <uix:messagePrompt promptBinding="MAXIMUM@uixDBObjectBundle@servletRequest"/>
      </uix:cellFormat>
      <uix:cellFormat>
        <uix:spacer height="1" width="5" /> 
      </uix:cellFormat>
      <uix:cellFormat hAlign="left">
        <uix:styledText styleClass="OraDataText"
                        textBinding="maxTrans@segmentBean@servletRequest" />
      </uix:cellFormat>
    </uix:rowLayout>
    </uix:tableLayout>
    </uix:header>
  </uix:cellFormat>

  <%-- Buffer Pool --%>
  <uix:cellFormat vAlign="top">
    <uix:header textBinding="BUFFER_POOL@uixDBObjectBundle@servletRequest">
    <uix:tableLayout>
    <uix:rowLayout>
      <uix:cellFormat hAlign="right">
        <uix:messagePrompt promptBinding="BUFFER_POOL@uixDBObjectBundle@servletRequest"/>
      </uix:cellFormat>
      <uix:cellFormat>
        <uix:spacer height="1" width="5" /> 
      </uix:cellFormat>
      <uix:cellFormat hAlign="left">
        <uix:styledText styleClass="OraDataText"
                        textBinding="bufferPool@storageClauseUIBean@servletRequest" />
      </uix:cellFormat>
    </uix:rowLayout>
    </uix:tableLayout>
    </uix:header>
  </uix:cellFormat>

  </uix:rowLayout>

  </uix:tableLayout>
</uix:cellFormat>
<%-- END: Segment Storage --%>

</uix:rowLayout>
</uix:tableLayout>
</uix:buildTree>
