<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        samplePage.jsp
  -- Controller:  db/adm/schm/SampleController.java
  --
  -- Description: Short Description of the page.
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>
<db:script src="/database/LOV.js"/>
<db:script src="/database/utils.js"/>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>

<uix:renderingContext id="renderingContext">
<uix:bundle name="dbMsgs"
            class="oracle.sysman.db.rsc.DBObjectMsg"/>
<oem:setURLEncoder id="renderingContext"/>
<uix:document>
<%@ include file="/oemTitle.jspf" %>

<%-- HTML Page Title --%>
<uix:metaContainer>
  <uix:head titleBinding="title@objectBean@servletRequest"/>
</uix:metaContainer>
<uix:body>

<%-- HTML Form --%>
<db:form name="foo" method="post" destination="/em/console/database/schema/view"
         copyParams="target,type,cancelURL,sname,oname,otype">
<uix:formValue name="pageName" value="/database/schema/view/generalPage"/>
<uix:formValue name="value" />

<uix:pageLayout titleBinding="header@objectBean@servletRequest">

  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/global.jspf" %>

  <%-- Information/Error display --%>
	<%@ include file="/database/informationError.jspf" %>

  <%-- Create/Edit/View Header --%>
  <uix:subTabLayout>
    
    <%-- SubTabs --%>
    <uix:subTabs>
      <uix:subTabBar selectedIndex="0">
        <db:link textBinding="GENERAL@uixViewTypeBundle@servletRequest"
                 copyParams="target,type,cancelURL,sname,oname,otype" />
        <db:link textBinding="OPTIONS@uixViewTypeBundle@servletRequest"
                 onClick="submitForm('foo', true, {event:'tabgotoValue2'})"
                 copyParams="target,type,cancelURL,sname,oname,otype" />
        <db:link textBinding="OBJECT@uixViewTypeBundle@servletRequest"
                 onClick="submitForm('foo', true, {event:'tabgotoValue3'})"
                 copyParams="target,type,cancelURL,sname,oname,otype" />
     </uix:subTabBar>
    </uix:subTabs>

    <%-- START: TAB CONTENTS starts here --%>


        <uix:rowLayout>
          <uix:contents>
            <uix:spacer width="30"/> 
          </uix:contents>
                                   
          <uix:contents>     
            <uix:stackLayout>                      
              <uix:tableLayout cellSpacing="5">
                <uix:contents>
                <uix:rowLayout>
                  <uix:contents>
                    <uix:cellFormat hAlign="right">
                      <uix:switcher  childNameBinding="creating@objectBean@servletRequest">
                        <uix:case name="true">
                          <uix:messagePrompt labeledNodeId="viewName"
                                             promptBinding="NAME@dbMsgs" required="yes"/>
                        </uix:case>
                        <uix:case name="false">
                          <uix:messagePrompt 
                                             promptBinding="NAME@dbMsgs"/>
                        </uix:case>
                      </uix:switcher>
                    </uix:cellFormat> 
                       
                    <uix:stackLayout>
                    <uix:contents>
                     
                      <uix:switcher  childNameBinding="creating@objectBean@servletRequest">
                        <uix:case name="true">
                          <uix:textInput id="viewName"
                                         name="viewName" 
                                         textBinding="viewName@objectBean@servletRequest" />
                        </uix:case>   
                        <uix:case name="false">
                          <uix:styledText styleClass="OraDataText" textBinding="viewName@objectBean@servletRequest"/>
                        </uix:case>         
                      </uix:switcher>
                  
                      <uix:messageText messageBinding="viewName@errors@servletRequest" messageType="error"/>
                    </uix:contents>
                  </uix:stackLayout>               				 
                  </uix:contents>
                </uix:rowLayout>
                
                <uix:rowLayout>
                  <uix:contents>
                    <uix:cellFormat hAlign="right">
                      <uix:switcher  childNameBinding="creating@objectBean@servletRequest">
                        <uix:case name="true">
                          <uix:messagePrompt promptBinding="SCHEMA@dbMsgs" 
                                             labeledNodeId="schema"
                                             required="yes"/>          
                        </uix:case>
                        <uix:case name="false">
                          <uix:messagePrompt promptBinding="SCHEMA@dbMsgs"
                                             />
                        </uix:case>
                      </uix:switcher>
                     </uix:cellFormat> 
                     
                     <%-- SWITCHER: schema --%>
                       <uix:switcher  childNameBinding="creating@objectBean@servletRequest">
                         <uix:case name="true"> 
                          <uix:stackLayout>               
                           <uix:lovField name="schemaName" 
                                         id="schema"
                                         shortDescBinding="SCHEMA@dbMsgs"
                                         searchDescBinding="SCHEMA@dbMsgs"
                                         textBinding="schemaName@objectBean@servletRequest" 
                                         onClick="startLov('schemaName','ListSchema')"/>
                            <uix:messageText messageBinding="schemaName@errors@servletRequest" messageType="error"/> 
                        </uix:stackLayout>
                         </uix:case>   
                         <uix:case name="false">
                           <uix:styledText styleClass="OraDataText" textBinding="schemaName@objectBean@servletRequest"/>   
                         </uix:case>         
                       </uix:switcher>
                    <%-- SWITCHER: schema --%>  
                                         
                  </uix:contents>
                </uix:rowLayout>   

                 
                <uix:rowLayout>
                   <uix:contents>
                     <uix:cellFormat hAlign="right">
                      <uix:messagePrompt labeledNodeId="aliases"
                                         promptBinding="ALIASES@uixViewTypeBundle@servletRequest"/> 
                     </uix:cellFormat>                     
                       <uix:textInput id="aliases"
                                      name="aliases" 
                                      textBinding="aliases@objectBean@servletRequest"
                                      disabledBinding="showAlias@objectBean@servletRequest"
                                      columns="65"/>
                   </uix:contents>
                </uix:rowLayout>
                                  
                <%-- SWITCHER: status --%>
                 <uix:switcher  childNameBinding="creating@objectBean@servletRequest">
                  <uix:case name="false"> 
                 <uix:rowLayout>
                   <uix:contents>
                     <uix:cellFormat hAlign="right">
                        <uix:messagePrompt promptBinding="STATUS@uixViewTypeBundle@servletRequest"/> 
                     </uix:cellFormat>                     
            				  <uix:styledText styleClass="OraDataText" textBinding="displayStatus@objectBean@servletRequest"/>
                   </uix:contents>
                 </uix:rowLayout>
                  </uix:case>
                </uix:switcher>                     
                <%-- SWITCHER: status --%>
        
                <%-- SWITCHER: replace --%>
                <uix:switcher  childNameBinding="creating@objectBean@servletRequest">
                  <uix:case name="true">                               
                    <uix:rowLayout>
                      <uix:cellFormat/> 
                      <uix:checkBox name="replace" 
                                    textBinding="REPLACE_IF_EXISTS@uixViewTypeBundle@servletRequest"
                                    checkedBinding="replace@objectBean@servletRequest"/>
                    </uix:rowLayout>                
                  </uix:case>
                </uix:switcher>     
                <%-- SWITCHER: replace --%>
                
                <uix:spacer height="2"/>

                <%-- SWITCHER: status --%>
                <uix:switcher  childNameBinding="creating@objectBean@servletRequest">
                
                  <uix:case name="true">           
                    <uix:rowLayout>
                      <uix:contents>
                        <uix:cellFormat hAlign="right" vAlign="top">
                           <uix:messagePrompt labeledNodeId="queryText"
                                              promptBinding="QUERYTEXT@uixViewTypeBundle@servletRequest" 
                                              required="yes"/> 
                        </uix:cellFormat>
                        <uix:stackLayout>
                          <uix:contents>
                            <uix:textInput id="queryText"
                                           name="queryText" 
                                           textBinding="queryText@objectBean@servletRequest"
                                           columns="80" 
                                           rows="10" />    
                            <uix:messageText messageBinding="queryText@errors@servletRequest" messageType="error"/>    
                          </uix:contents>
                        </uix:stackLayout>
                      </uix:contents>                         
                    </uix:rowLayout>                                                     
                  </uix:case>
                  
                  <uix:case name="false">
                                     
                    <uix:rowLayout>
                      <uix:contents>
                        <uix:cellFormat hAlign="right" vAlign="top"> 
                           <uix:messagePrompt labeledNodeId="queryText"
                                              promptBinding="QUERYTEXT@uixViewTypeBundle@servletRequest"
                                              required="yes"/> 
                         
                        </uix:cellFormat>              
                        <uix:stackLayout>
                          <uix:contents>
                            <uix:textInput id="queryText"
                                           name="queryText" 
                                           textBinding="queryText@objectBean@servletRequest" 
                                           columns="80" 
                                           rows="10" />
                            <uix:messageText messageBinding="queryText@errors@servletRequest" messageType="error"/>  
                            <uix:rowLayout hAlign="right">
                              <uix:submitButton  textBinding="COMPILE@dbMsgs" name="event" value="compilecommit"/>
                              <uix:spacer width="5"/>
                              <uix:switcher childNameBinding="showError@objectBean@servletRequest">
                                <uix:case name="false">
                                  <uix:submitButton textBinding = "SHOW_ERRORS@dbMsgs" name="event" value="showErrors" disabled="true"/>
                                </uix:case>
                                <uix:case name="true">
                                  <uix:submitButton textBinding = "errorButtonName@objectBean@servletRequest" name="event" value="showErrors"/>
                                </uix:case>
                              </uix:switcher>
                            </uix:rowLayout>
                          </uix:contents>
                        </uix:stackLayout>
                      </uix:contents>
                    </uix:rowLayout>     
                    
                 </uix:case>
                </uix:switcher>                     
                <%-- SWITCHER: status --%>
                
                <uix:switcher childNameBinding="showErrorBox@objectBean@servletRequest">
                  <uix:case name="true">
                    <uix:rowLayout> 
                      <uix:cellFormat hAlign="right" vAlign="top">      
                        <uix:messagePrompt labeledNodeId="compileError"
                                           promptBinding="ERRORS@dbMsgs"/> 
                      </uix:cellFormat>              
                      <uix:textInput id="compileError"
                                     name="compileError" 
                                     textBinding="compileError@objectBean@servletRequest" 
                                     columns="80" 
                                     rows="5" 
                                     readOnly="true"/>                             
                    </uix:rowLayout>
                  </uix:case>
                </uix:switcher>
                </uix:contents>
              </uix:tableLayout>
              <uix:spacer height="10"/>         
            </uix:stackLayout>            
          </uix:contents>              
        </uix:rowLayout> 


    <%-- END: TAB CONTENTS ends here --%>   
        
  </uix:subTabLayout>  

  <%-- Create/Edit Buttons --%>
  <uix:pageButtons>
  <uix:pageButtonBar>
    <jsp:include page="/database/schema/pageButtonInclude.jsp" />
    <uix:ref refID="pageButtonInclude" />
  </uix:pageButtonBar>
  </uix:pageButtons>

</uix:pageLayout>
</db:form>
<%-- END: HTML Form --%>

</uix:body>
</uix:document>
</uix:renderingContext>
<%-- END: Content --%> 




