<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        samplePage.jsp
  -- Controller:  db/adm/schm/SampleController.java
  --
  -- Description: Short Description of the page.
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<NOSCRIPT>
A browser with Javascript enabled is required for this page to operate properly.
</NOSCRIPT>

<db:script src="/database/utils.js"/>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>
<%@ page import="oracle.sysman.emo.adm.schema.view.ViewObjectConstants" %>

<uix:renderingContext id="renderingContext">
    <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>
    <uix:bundle name="viewMsgs" class="oracle.sysman.db.rsc.schm.ViewTypeMsg"/>
    <uix:bundle name="tblMsgs" class="oracle.sysman.db.rsc.schm.TableMsg"/>
    <oem:setURLEncoder id="renderingContext"/>
    <uix:document>
        <%@ include file="/oemTitle.jspf" %>

        <%-- HTML Page Title --%>
        <uix:metaContainer>
            <uix:head titleBinding="title@objectBean@servletRequest"/>
        </uix:metaContainer>
        <uix:body>

            <%-- HTML Form --%>
            <db:form name="objectPageForm" method="post" destination="/console/database/schema/view"
                copyParams="target,type,cancelURL,sname,oname,otype">
                <uix:formValue name="pageName" value="/database/schema/view/objectPage"/>
                <uix:formValue name="schemaName" valueBinding="schemaName@objectBean@servletRequest"/>
                <uix:formValue name="value" />
                <uix:pageLayout titleBinding="header@objectBean@servletRequest">

                    <%-- Oracle Logo and Tabs --%>
                    <%@ include file="/database/global.jspf" %>

                    <%-- Warning/Error display --%>
                    <oem:messageBox messageType="info" 
                    errorTableBinding="info@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                    <oem:messageBox messageType="error" 
                    errorTableBinding="errors@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>

					


					<%-- Create/Edit/View Header --%>
                    <uix:subTabLayout>
                        <%-- SubTabs --%>
                        <uix:subTabs>
                            <uix:subTabBar selectedIndex="2">
                                <db:link textBinding="GENERAL@viewMsgs"
                                onClick="submitForm('objectPageForm', true, {event:'tabgotoValue1'})"
                                copyParams="target,type,cancelURL,sname,oname,otype" />
                                <db:link textBinding="OPTIONS@viewMsgs"
                                onClick="submitForm('objectPageForm', true, {event:'tabgotoValue2'})"
                                copyParams="target,type,cancelURL,sname,oname,otype" />
                                <db:link textBinding="OBJECT@viewMsgs"
                                copyParams="target,type,cancelURL,sname,oname,otype" />
                            </uix:subTabBar>
                        </uix:subTabs>

                        <%-- START: TAB CONTENTS starts here --%>

						<uix:rowLayout>
							<uix:contents>
								<uix:messagePrompt promptBinding="OBJECT_TIP@viewMsgs" />
							</uix:contents>
						</uix:rowLayout>
						<uix:rowLayout>
							<uix:contents>
								<uix:spacer width="10" />
							</uix:contents>
						</uix:rowLayout>
						

						<uix:rowLayout>
                            <uix:contents>
                                <uix:stackLayout>    
                                    <uix:rowLayout>                 
                                        <uix:flowLayout>
                                            <uix:styledText textBinding="TYPE@viewMsgs" labeledNodeId="DEFINE_USING"
                                            styleClass="OraPromptText" />
                                            <uix:choice name="<%= ViewObjectConstants.DEFINE_TYPE_USING %>" 
                                                id="DEFINE_USING"
                                                onChange="submitForm('objectPageForm', true, {'event':'defineTypeUsing'})"
                                                disabledBinding="showObjectTypeChoice@objectBean@servletRequest"
                                                selectedValueBinding="defineTypeUsing@objectBean@servletRequest">
                                                <uix:option textBinding="OBJECT_TYPE@dbMsgs"
                                                value="<%= ViewObjectConstants.DEF_TYPE_OBJ %>" />
                                                <uix:switcher childNameBinding="xdbEnabled@servletRequest">
                                                    <uix:case name="true">
                                                        <uix:option textBinding="XML_TYPE@tblMsgs"
                                                        value="<%= ViewObjectConstants.DEF_TYPE_XML %>" />
                                                    </uix:case>
                                                </uix:switcher>
                                            </uix:choice> 
                                        </uix:flowLayout>
                                    </uix:rowLayout> 
                                    <uix:spacer height="5"/>    
                                    <uix:header textBinding="OBJECTTYPE_DETAILS@viewMsgs">
                                        <uix:contents>
                                            <uix:spacer height="15"/>
                                            <uix:switcher childNameBinding="defineTypeUsing@objectBean@servletRequest">
                                                <uix:case name="<%= ViewObjectConstants.DEF_TYPE_OBJ %>">
                                                    <jsp:include page="/database/schema/view/objectTypeInclude.jsp" />
                                                    <uix:ref refID="objectTypeInclude" /> 
                                                </uix:case>   
                                                <uix:case name="<%= ViewObjectConstants.DEF_TYPE_XML %>">
                                                    <uix:dataScope currentDataBinding="XMLTypeTable_Bean@servletRequest">
                                                        <jsp:include page="/database/schema/view/xmlTypeInclude.jsp" />
                                                        <uix:ref refID="xmlTypeInclude" />
                                                    </uix:dataScope>
                                                </uix:case>
                                            </uix:switcher>
                                        </uix:contents>
                                    </uix:header>
                                </uix:stackLayout>
                            </uix:contents> 
                        </uix:rowLayout> 

                        <%-- END: TAB CONTENTS ends here --%>   
        
                    </uix:subTabLayout>  

                    <%-- Create/Edit Buttons --%>
                    <uix:pageButtons>
                        <uix:pageButtonBar>
                            <jsp:include page="/database/schema/pageButtonInclude.jsp" />
                            <uix:ref refID="pageButtonInclude" />
                        </uix:pageButtonBar>
                    </uix:pageButtons>

                </uix:pageLayout>
            </db:form>
            <%-- END: HTML Form --%>

        </uix:body>
    </uix:document>
</uix:renderingContext>
<%-- END: Content --%> 




