<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>

<uix:buildTree nodeID="objectTypeInclude">
    <uix:dataScope>
        <db:script src="/database/utils.js"/>   <%-- lovField support --%>
        <db:script src="/database/LOV.js" />
        <%-- Message Bundles --%>
       
        <uix:stackLayout>
        
            <uix:rowLayout>
                <uix:contents>
                    <uix:spacer width="20"/>  
                    <uix:cellFormat hAlign="left">
                        <uix:messagePrompt promptBinding="OBJECT_TYPE@dbMsgs"
                                           labeledNodeId="OTYPE"/>
                        <uix:spacer width="5"/>
                    </uix:cellFormat>
        
                    <uix:cellFormat hAlign="left">
                        <uix:stackLayout>   
                            <uix:lovField name="viewSchemaObjectType" 
                                          id="OTYPE"
                                          columns="50"
                                          shortDescBinding="OBJECT_TYPE@dbMsgs"
                                          searchDescBinding="OBJECT_TYPE@dbMsgs"
                                          textBinding="viewSchemaObjectType@objectBean@servletRequest" 
                                          onClick="setSearchFilter('schemaName');startLov('viewSchemaObjectType','ListObjecttype')"/>
                            <uix:messageText messageBinding="viewSchemaObjectType@errors@servletRequest" messageType="error"/>
                        </uix:stackLayout>
                    </uix:cellFormat>
                    <uix:spacer width="5"/>
                    <uix:cellFormat hAlign="left">              
                        <uix:submitButton textBinding="GO@dbMsgs" name="event" value="getObjectType" unvalidated="true"/>             				 
                    </uix:cellFormat>       
                </uix:contents>
            </uix:rowLayout>
                  
                 
            <uix:rowLayout>
                <uix:contents>   
                    <uix:spacer width="30"/>
                    <oem:radioButton name="OIDType" value="defaultOID" textBinding="DEFAULT_OID_TEXT@viewMsgs" selectedValueBinding="OIDType@objectBean@servletRequest" />   
                </uix:contents>
            </uix:rowLayout>

            <uix:rowLayout>
                <uix:contents>   
                    <uix:spacer width="30"/>     
                    <oem:radioButton name="OIDType" value="notDefaultOID" textBinding="NOT_DEFAULT_OID_TEXT@viewMsgs" selectedValueBinding="OIDType@objectBean@servletRequest"/>
                </uix:contents>
            </uix:rowLayout>
                                     
        </uix:stackLayout>

        <uix:contents>
            <uix:spacer height="5"/>
                                               
            <uix:rowLayout>             
                <uix:spacer width="80"/>            
                <oem:shuttle name="ObjectAttributes" leadingHeaderBinding="AVAILABLE_ATTRIBUTES@dbMsgs" trailingHeaderBinding="SELECTED_ATTRIBUTES@dbMsgs" size="5" reorderable="true" >
                    <uix:leading>
                        <oem:list name="availableObjectAttributes" optionsBinding="availableObjectAttributes@objectBean@servletRequest" shortDescBinding="AVAILABLE_ATTRIBUTES@dbMsgs"/>
                    </uix:leading>
                    <uix:trailing>
                        <oem:list name="objectIDAttrList" optionsBinding="objectIDAttrList@objectBean@servletRequest" shortDescBinding="SELECTED_ATTRIBUTES@dbMsgs"/>
                    </uix:trailing>
                </oem:shuttle>                 
            </uix:rowLayout> 
            <uix:spacer height="15"/>    
        </uix:contents>   
    </uix:dataScope>
</uix:buildTree>
