<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        samplePage.jsp
  -- Controller:  db/adm/schm/SampleController.java
  --
  -- Description: Short Description of the page.
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<NOSCRIPT>
A browser with Javascript enabled is required for this page to operate properly.
</NOSCRIPT>

<db:script src="/database/utils.js"/>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>
<uix:document>
<%@ include file="/oemTitle.jspf" %>
  
<%-- HTML Page Title --%>
<uix:metaContainer>
  <uix:head titleBinding="title@objectBean@servletRequest"/>
</uix:metaContainer>
<uix:body>

<%-- HTML Form --%>
<db:form name="OptionsPageForm" method="post" destination="/console/database/schema/view"
         copyParams="target,type,cancelURL,sname,oname,otype">
<uix:formValue name="pageName" value="/database/schema/view/optionsPage"/>
<uix:formValue name="value" /> 
<uix:pageLayout titleBinding="header@objectBean@servletRequest">

  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/global.jspf" %>

  <%-- Warning/Error display --%>
  <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error" 
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>

  <%-- Create/Edit/View Header --%>
  <uix:subTabLayout>
    
    <%-- SubTabs --%>
    <uix:subTabs>
      <uix:subTabBar selectedIndex="1">
        <db:link textBinding="GENERAL@uixViewTypeBundle@servletRequest"
                 onClick="submitForm('OptionsPageForm', true, {event:'tabgotoValue1'})"
                 copyParams="target,type,cancelURL,sname,oname,otype" />
        <db:link textBinding="OPTIONS@uixViewTypeBundle@servletRequest"
                 copyParams="target,type,cancelURL,sname,oname,otype" />
        <db:link textBinding="OBJECT@uixViewTypeBundle@servletRequest"
                 onClick="submitForm('OptionsPageForm', true, {event:'tabgotoValue3'})"
                 copyParams="target,type,cancelURL,sname,oname,otype" />
     </uix:subTabBar>
    </uix:subTabs>

    <%-- START: TAB CONTENTS starts here --%>

        <uix:rowLayout>
          <uix:contents>
            <uix:spacer width="30"/>
          </uix:contents>

           <uix:stackLayout>         
             <uix:contents>
					<uix:messageCheckBox name="force"
						textBinding="OPTIONS_FORCE@uixViewTypeBundle@servletRequest"
						tipBinding="OPTIONS_FORCE_TIP@uixViewTypeBundle@servletRequest"
						checkedBinding="force@objectBean@servletRequest"
						 />
									<uix:spacer height="1"/>
               <uix:checkBox name="restriction" textBinding="OPTIONS_RESTRICTION@uixViewTypeBundle@servletRequest" checkedBinding="restriction@objectBean@servletRequest"/>
               
               <uix:rowLayout>                          
                 <uix:contents>
                   <uix:spacer width="30"/> 
                 </uix:contents>
                 <uix:stackLayout>
                   <uix:contents>                       
                     <oem:radioButton name="restrictionType" value="readOnly" textBinding="OPTIONS_READ_ONLY@uixViewTypeBundle@servletRequest"  selectedValueBinding="restrictionType@objectBean@servletRequest"/>         
                     <oem:radioButton name="restrictionType" value="withCheckOption" textBinding="OPTIONS_WITH_CHECK_OPTION@uixViewTypeBundle@servletRequest" selectedValueBinding="restrictionType@objectBean@servletRequest"/>
                     <uix:rowLayout>
                       <uix:contents>
                         <uix:spacer width="30"/>
                       </uix:contents>
                       <uix:stackLayout>
                      
                       <uix:rowLayout>
                         <uix:messagePrompt labeledNodeId="constraint"
                                            promptBinding="CONSTRAINT_NAME@uixViewTypeBundle@servletRequest"/>
                         <uix:spacer width ="10"/>
                         <uix:stackLayout>
                           <uix:textInput id="constraint"
                                          name="constraint" 
                                          textBinding="constraint@objectBean@servletRequest"/>
                           <uix:styledText styleClass="OraInlineInfoText" textBinding="DEFAULT_CONSTRAINT@uixViewTypeBundle@servletRequest"/>
                         </uix:stackLayout>           
                       </uix:rowLayout>
                       </uix:stackLayout>
                     </uix:rowLayout>
                   </uix:contents>
                 </uix:stackLayout>
               </uix:rowLayout>
            </uix:contents>
          </uix:stackLayout>
        </uix:rowLayout>

    <%-- END: TAB CONTENTS ends here --%>   
        
  </uix:subTabLayout>  

  <%-- Create/Edit Buttons --%>
  <uix:pageButtons>
  <uix:pageButtonBar>
    <jsp:include page="/database/schema/pageButtonInclude.jsp" />
    <uix:ref refID="pageButtonInclude" />
  </uix:pageButtonBar>
  </uix:pageButtons>

</uix:pageLayout>
</db:form>
<%-- END: HTML Form --%>

</uix:body>
</uix:document>
</uix:renderingContext>
<%-- END: Content --%> 




