<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        samplePage.jsp
  -- Controller:  db/adm/schm/SampleController.java
  --
  -- Description: Short Description of the page.
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<NOSCRIPT>
A browser with Javascript enabled is required for this page to operate properly.
</NOSCRIPT>

<jsp:useBean id="objectBean" scope="request"
   type="oracle.sysman.emo.adm.schema.view.View"/>

<db:script src="/database/utils.js"/>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>
<%@ page import="oracle.sysman.emo.adm.schema.view.ViewObjectConstants" %>

<uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext"/>
    <uix:bundle name="xschMsg" class="oracle.sysman.db.rsc.xdb.XDBSchemaMsg"/>
    <uix:document>
        <%@ include file="/oemTitle.jspf" %>

        <%-- HTML Page Title --%>
        <uix:metaContainer>
            <uix:head titleBinding="title@objectBean@servletRequest"/>
        </uix:metaContainer>
        <uix:body>

            <%-- HTML Form --%>
            <db:form name="foo" 
                method="post" 
                destination="/console/database/schema/view"
                copyParams="target,type,cancelURL,sname,oname,otype" >
                <uix:formValue name="pageName" value="/database/schema/view/viewPage"/>
                <uix:formValue name="value" />     
                <uix:formValue name="oname" valueBinding="viewName@objectBean@servletRequest" /> 
                <uix:pageLayout titleBinding="header@objectBean@servletRequest">

                    <%-- Oracle Logo and Tabs --%>
                    <%@ include file="/database/global.jspf" %>

                    <%-- Warning/Error display --%>
                    <oem:messageBox messageType="info" 
                    errorTableBinding="info@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                    <oem:messageBox messageType="error" 
                    errorTableBinding="errors@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>

                    <%-- START: TAB CONTENTS starts here --%>
                    <uix:header textBinding="GENERAL@uixDBObjectBundle@servletRequest">

                        <uix:tableLayout cellSpacing="5">
                            <uix:rowLayout>
                                <uix:contents>
                                    <uix:cellFormat hAlign="right" width="80">
                                        <uix:messagePrompt promptBinding="NAME@uixViewTypeBundle@servletRequest"/>
                                    </uix:cellFormat> 
                                    <uix:styledText styleClass="OraDataText" textBinding="viewName@objectBean@servletRequest"/> 
                                </uix:contents>
                            </uix:rowLayout>
                
                            <uix:rowLayout>
                                <uix:contents>
                                    <uix:cellFormat hAlign="right" width="80">
                                        <uix:messagePrompt promptBinding="SCHEMA@uixViewTypeBundle@servletRequest"/>            
                                    </uix:cellFormat> 
                                    <uix:styledText styleClass="OraDataText" textBinding="schemaName@objectBean@servletRequest"/>                    
                                </uix:contents>
                            </uix:rowLayout>   
                 
                            <uix:rowLayout>
                                <uix:contents>
                                    <uix:cellFormat hAlign="right" width="80">
                                        <uix:messagePrompt promptBinding="ALIASES@uixViewTypeBundle@servletRequest"/>
                                    </uix:cellFormat>         
                                    <uix:styledText styleClass="OraDataText" textBinding="aliases@objectBean@servletRequest"/> 
                                </uix:contents>
                            </uix:rowLayout>
  
                            <uix:rowLayout>
                                <uix:contents>
                                    <uix:cellFormat hAlign="right" width="80">
                                        <uix:messagePrompt promptBinding="STATUS@uixViewTypeBundle@servletRequest"/>
                                    </uix:cellFormat>                     
                                    <uix:styledText styleClass="OraDataText" textBinding="displayStatus@objectBean@servletRequest"/>
                                </uix:contents>
                            </uix:rowLayout>                   

                            <uix:rowLayout>
                                <uix:contents>
                                    <uix:cellFormat hAlign="right" vAlign="top">
                                        <uix:messagePrompt labeledNodeId="queryText"
                                        promptBinding="QUERYTEXT@uixViewTypeBundle@servletRequest"/>
                                    </uix:cellFormat>  
                                    <uix:textInput id="queryText"
                                    name="queryText" 
                                    textBinding="queryText@objectBean@servletRequest"  
                                    readOnly="true" 
                                    columns="80" 
                                    rows="<%= objectBean.getNumRows()%>" />
                                </uix:contents> 
                            </uix:rowLayout>                    
                  
                            <uix:switcher childNameBinding="showErrorBox@objectBean@servletRequest">
                                <uix:case name="true">
                                    <uix:rowLayout> 
                                        <uix:cellFormat hAlign="right" vAlign="top">
                                            <uix:messagePrompt labeledNodeId="compileError"
                                            promptBinding="ERRORS@uixDBObjectBundle@servletRequest"/>
                                        </uix:cellFormat>           
                                        <uix:textInput id="compileError"
                                        name="compileError" 
                                        textBinding="compileError@objectBean@servletRequest"
                                        columns="80" 
                                        rows="<%= objectBean.getErrorsNumRows()%>"
                                        readOnly="true"/>                             
                                    </uix:rowLayout>
                                </uix:case>
                            </uix:switcher> 

                        </uix:tableLayout>
                    </uix:header>

                    <%-- options  --%>
                    <uix:switcher  childNameBinding="restriction@objectBean@servletRequest">
                        <uix:case name="true">
                            <uix:header textBinding="OPTIONS@uixDBObjectBundle@servletRequest">
                                <uix:tableLayout>
                                    <uix:contents>

                                        <uix:switcher  childNameBinding="readOnly@objectBean@servletRequest">
                                            <uix:case name="true">
                                                <uix:rowLayout>
                                                    <uix:messagePrompt promptBinding="OPTIONS_READ_ONLY@uixViewTypeBundle@servletRequest"/> 
                                                </uix:rowLayout>
                                            </uix:case>      
                                            <uix:case name="false">
                                                <uix:rowLayout>
                                                    <uix:stackLayout>
                                                        <uix:contents>
                                                            <uix:messagePrompt promptBinding="OPTIONS_WITH_CHECK_OPTION@uixViewTypeBundle@servletRequest"/> 
                                                            <uix:rowLayout>
                                                                <uix:messagePrompt promptBinding="CONSTRAINT_NAME@uixViewTypeBundle@servletRequest"/>
                                                                <uix:spacer width ="10"/>      
                                                                <uix:styledText styleClass="OraDataText" textBinding="constraint@objectBean@servletRequest"/> 
                                                            </uix:rowLayout>
                                                        </uix:contents>
                                                    </uix:stackLayout>
                                                </uix:rowLayout>  
                                            </uix:case>
                                        </uix:switcher>
                  
                                    </uix:contents>
                                </uix:tableLayout>
                            </uix:header>
                        </uix:case>
                    </uix:switcher>
                    <%--options --%>
        
                    <%-- object --%>
                    <uix:switcher childNameBinding="defineTypeUsing@objectBean@servletRequest">
                        <uix:case name="<%= ViewObjectConstants.DEF_TYPE_OBJ %>">
                            <uix:switcher  childNameBinding="useOID@objectBean@servletRequest">
                                <uix:case name="true">
                                    <uix:header textBinding="ASOBJECT@uixViewTypeBundle@servletRequest">
                                        <uix:tableLayout cellSpacing="5">   
                                            <uix:rowLayout>
                                                <uix:cellFormat hAlign="right">
                                                    <uix:messagePrompt promptBinding="OBJECTTYPE@uixViewTypeBundle@servletRequest"/>
                                                </uix:cellFormat>
                                                <uix:cellFormat>
                                                    <uix:styledText styleClass="OraDataText" textBinding="viewSchemaObjectType@objectBean@servletRequest"/>                                           				 
                                                </uix:cellFormat>
                                            </uix:rowLayout>
                  
                                            <uix:switcher  childNameBinding="objectIDDefault@objectBean@servletRequest">
                                                <uix:case name="true">
                                                    <uix:rowLayout>
                                                        <uix:cellFormat hAlign="right">
                                                            <uix:messagePrompt promptBinding="DEFAULT_OBJECT_ID@uixViewTypeBundle@servletRequest"/>
                                                        </uix:cellFormat>
                                                        <uix:cellFormat>
                                                            <uix:inlineMessage prompt="   "/>
                                                        </uix:cellFormat> 
                                                    </uix:rowLayout>
                                                </uix:case>    
                                                <uix:case name="false">
                                                    <uix:rowLayout>
                                                        <uix:cellFormat hAlign="right">
                                                            <uix:messagePrompt promptBinding="NONDEFAULT_OBJECT_ID@uixViewTypeBundle@servletRequest"/>
                                                        </uix:cellFormat>
                                                        <uix:cellFormat>
                                                            <uix:styledText styleClass="OraDataText" textBinding="objectIDAttrListString@objectBean@servletRequest"/> 
                                                        </uix:cellFormat>
                                                    </uix:rowLayout>
                                                </uix:case>
                                            </uix:switcher>
              
                                        </uix:tableLayout>
                                    </uix:header>
                                </uix:case>
                            </uix:switcher>
                        </uix:case>
                        <uix:case name="<%= ViewObjectConstants.DEF_TYPE_XML %>">
                            <uix:header textBinding="ASOBJECT@uixViewTypeBundle@servletRequest">
                                <uix:tableLayout cellSpacing="5">   
                                    <uix:rowLayout>
                                        <uix:cellFormat hAlign="right">
                                            <uix:messagePrompt promptBinding="OBJECTTYPE@uixViewTypeBundle@servletRequest"/>
                                        </uix:cellFormat>
                                        <uix:cellFormat>
                                            <uix:styledText styleClass="OraDataText" textBinding="viewSchemaObjectType@objectBean@servletRequest"/>                                           				 
                                        </uix:cellFormat>
                                    </uix:rowLayout>
                                    <uix:rowLayout>
                                        <uix:cellFormat hAlign="right">
                                            <uix:messagePrompt promptBinding="TYPE@uixViewTypeBundle@servletRequest"/>
                                        </uix:cellFormat>
                                        <uix:cellFormat>
                                            <uix:switcher childNameBinding="schemaBased@XMLTypeTable_Bean@servletRequest">
                                                <uix:case name="true">
                                                    <uix:styledText styleClass="OraDataText" textBinding="SCHEMA_BASED@xschMsg"/> 
                                                </uix:case>
                                                <uix:case name="false">
                                                    <uix:styledText styleClass="OraDataText" textBinding="NON_SCHEMA_BASED@xschMsg"/> 
                                                </uix:case>
                                            </uix:switcher>
                                        </uix:cellFormat>
                                    </uix:rowLayout>
                                    <uix:rowLayout>
                                        <uix:cellFormat hAlign="right">
                                            <uix:messagePrompt promptBinding="XML_SCHEMA@xschMsg"/>
                                        </uix:cellFormat>
                                        <uix:cellFormat>
                                            <uix:switcher childNameBinding="schemaBased@XMLTypeTable_Bean@servletRequest">
                                                <uix:case name="true">
                                                    <uix:styledText styleClass="OraDataText" textBinding="schemaURL@XMLTypeTable_Bean@servletRequest"/> 
                                                </uix:case>
                                                
                                            </uix:switcher>
                                        </uix:cellFormat>
                                    </uix:rowLayout>
                                     <uix:rowLayout>
                                        <uix:cellFormat hAlign="right">
                                            <uix:messagePrompt promptBinding="ELEMENT@xschMsg"/>
                                        </uix:cellFormat>
                                        <uix:cellFormat>
                                            <uix:switcher childNameBinding="schemaBased@XMLTypeTable_Bean@servletRequest">
                                                <uix:case name="true">
                                                    <uix:styledText styleClass="OraDataText" textBinding="schemaElement@XMLTypeTable_Bean@servletRequest"/> 
                                                </uix:case>
                                                
                                            </uix:switcher>
                                        </uix:cellFormat>
                                    </uix:rowLayout>
                                    <uix:rowLayout>
                                        <uix:cellFormat hAlign="right">
                                            <uix:messagePrompt promptBinding="VIEW_OBJ_IDENT@xschMsg"/>
                                        </uix:cellFormat>
                                        <uix:cellFormat>
                                            <uix:switcher childNameBinding="objectIdentifier@XMLTypeTable_Bean@servletRequest">
                                                <uix:case name="<%= ViewObjectConstants.USE_DEFAULT_QUERY %>">
                                                    <uix:styledText styleClass="OraDataText" textBinding="VIEW_OBJ_DEFAULT@xschMsg"/> 
                                                </uix:case>
                                                <uix:case name="<%= ViewObjectConstants.USE_XPATH_EXPR %>">
                                                    <uix:styledText styleClass="OraDataText" textBinding="VIEW_OBJ_XPATH@xschMsg"/> 
                                                </uix:case>
                                                
                                            </uix:switcher>
                                        </uix:cellFormat>
                                    </uix:rowLayout>
                                    <uix:rowLayout>
                                        <uix:cellFormat hAlign="right">
                                            <uix:messagePrompt promptBinding="VIEW_EXPR@xschMsg"/>
                                        </uix:cellFormat>
                                        <uix:cellFormat>
                                            <uix:switcher childNameBinding="objectIdentifier@XMLTypeTable_Bean@servletRequest">
                                                <uix:case name="<%= ViewObjectConstants.USE_XPATH_EXPR %>">
                                                    <uix:styledText styleClass="OraDataText" textBinding="xpathQuery@XMLTypeTable_Bean@servletRequest"/> 
                                                </uix:case>
                                           </uix:switcher>
                                        </uix:cellFormat>
                                    </uix:rowLayout>
                                </uix:tableLayout>
                            </uix:header>
                        </uix:case>
                    </uix:switcher>
                    <%-- END: TAB CONTENTS ends here --%>   
        

                    <%-- Create/Edit Buttons --%>
                    <uix:pageButtons>
                      <uix:pageButtonBar>
                          <uix:switcher childNameBinding="xmlInitialized@objectBean@servletRequest">
                            <uix:case name="false">
                                <jsp:include page="/database/schema/pageButtonViewInclude.jsp" />
                                <uix:ref refID="pageButtonViewInclude" />
                            </uix:case>
                            <uix:case name="true">
                            <%-- OK Button --%>
        <%@ include file="/database/changemgr/cmEMOViewPageButtons.jspf" %>
                            </uix:case>
                          </uix:switcher>
                      </uix:pageButtonBar>
                    </uix:pageButtons>

                </uix:pageLayout>
            </db:form>
            <%-- END: HTML Form --%>

        </uix:body>
    </uix:document>
</uix:renderingContext>
<%-- END: Content --%> 




