<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%-- Imports --%>
<%@ page import="oracle.sysman.emo.adm.schema.table.XmlTypeConstants" %>
<%@ page import="oracle.sysman.emo.adm.schema.table.TableConst" %>



<%-- COLUMN TABLE DEFINITION --%>

<uix:buildTree nodeID="xmlTypeInclude">
    <uix:dataScope>
        <db:script src="/database/utils.js"/>   <%-- lovField support --%>
        <db:script src="/database/LOV.js" />
        <%-- Message Bundles --%>
        <uix:bundle name="xschMsg" class="oracle.sysman.db.rsc.xdb.XDBSchemaMsg"/>
        <uix:bundle name="tblMsgs" class="oracle.sysman.db.rsc.schm.TableMsg"/>
        <uix:bundle name="viewMsg" class="oracle.sysman.db.rsc.schm.ViewTypeMsg"/>
        
        <uix:tableLayout cellSpacing="5" hAlign="center" width="100%">
            <uix:contents>
				<uix:rowLayout>
					<uix:contents>
						<uix:cellFormat>
							<uix:contents>
								<uix:styledText styleClass="OraInstructionText"
									textBinding="OBJECT_TYPE@viewMsg" />
							</uix:contents>
						</uix:cellFormat>
					</uix:contents>
				</uix:rowLayout>

				<uix:rowLayout>
                    <uix:contents>
                        <uix:cellFormat>
                            <uix:contents>
                                <uix:spacer width="20"/>
                                <uix:radioButton name="xmlSchemaType" value ="<%=XmlTypeConstants.SCHEMA_BASED_NONE%>" 
                                textBinding="NON_SCHEMA_BASED@xschMsg"
                                shortDescBinding="NON_SCHEMA_BASED@xschMsg"
                                onClick="submitForm('objectPageForm', true, {'event':'xmlSchemaSelected'})"
                                disabledBinding="editing@objectBean@servletRequest"
                                selectedBinding="noSchema@"/>
                            </uix:contents>
                        </uix:cellFormat>
                    </uix:contents>
                </uix:rowLayout>
            </uix:contents>
        </uix:tableLayout>
        <uix:tableLayout cellSpacing="5" hAlign="center" width="100%">
            <uix:contents>
                <uix:rowLayout>
                    <uix:contents>
                        <uix:cellFormat>
                            <uix:contents>
                                <uix:spacer width="20"/>
                                <uix:radioButton name="xmlSchemaType" value ="<%=XmlTypeConstants.SCHEMA_BASED_ONE%>" 
                                textBinding="SCHEMA_BASED@xschMsg"
                                shortDescBinding="SCHEMA_BASED@xschMsg"
                                onClick="submitForm('objectPageForm', true, {'event':'xmlSchemaSelected'})"
                                disabledBinding="editing@objectBean@servletRequest"
                                selectedBinding="oneSchema@"/>
                            </uix:contents>
                        </uix:cellFormat>
                    </uix:contents>
                </uix:rowLayout>
            </uix:contents>
        </uix:tableLayout>
        <uix:switcher childNameBinding="oneSchema@">
            <uix:case name="true">
                <uix:tableLayout>
                    <uix:stackLayout>
                        <uix:tableLayout cellSpacing="5">
                            <uix:contents>
                                <uix:rowLayout>
                                    <uix:contents>
                                        <uix:cellFormat hAlign="right" wrappingDisabled="true">
                                            <uix:contents>
                                                <uix:styledText styleClass="OraInstructionText" textBinding="XML_SCHEMA@xschMsg" labeledNodeId="schemaURL"/>
                                            </uix:contents>
                                        </uix:cellFormat>
                                        <uix:cellFormat hAlign="left" wrappingDisabled="true">
                                            <uix:contents>
                                                <uix:messageLovField columns="65"
                                                name="schemaURL"
                                                id="schemaURL"
                                                textBinding="completeXmlSchema@"
                                                shortDescBinding="XML_SCHEMA@xschMsg"
                                                searchDescBinding="XML_SCHEMA@xschMsg"
                                                disabledBinding="xmlTypeTableEditing@objectBean@servletRequest"
                                                onClick="setWindowSize(800,600);preserveCase();startLov('schemaURL','ListOwnerXmlSchema')"/>
                                            </uix:contents>
                                        </uix:cellFormat>
                                        <uix:cellFormat hAlign="left" wrappingDisabled="true" >
                                            <uix:contents>
                                                <uix:submitButton textBinding="PARSE_XML_SCHEMA@xschMsg"
                                                shortDescBinding="PARSE_XML_SCHEMA@xschMsg"
                                                name="event" value="parse_schema"/>
                                            </uix:contents>
                                        </uix:cellFormat>
                                    </uix:contents>
                                </uix:rowLayout>
                                <uix:switcher childNameBinding="showStorageOptionsToggle@">
                                    <uix:case name="<%= XmlTypeConstants.SCHEMA_PARSING_DONE %>">
                                                    
                                        <uix:rowLayout>
                                            <uix:contents>
                                                <uix:cellFormat hAlign="right">
                                                    <uix:contents>
                                                        <uix:styledText styleClass="OraInstructionText" textBinding="ELEMENT@xschMsg"/>
                                                    </uix:contents>
                                                </uix:cellFormat>
                                                                                
                                                                                    
                                                <uix:cellFormat hAlign="left">
                                                    <uix:contents>
                                                       
                                                                <oem:choice name="schemaElement" optionsBinding="elementCollection@XMLTypeTable_Bean@servletRequest" shortDescBinding="ELEMENT@xschMsg"/>
                                                            
                                                    </uix:contents>
                                                </uix:cellFormat>
                                            </uix:contents>
                                        </uix:rowLayout>
                                    </uix:case>
                                </uix:switcher>
                                <uix:switcher childNameBinding="showStorageOptionsToggle@">
                                    <uix:case name="<%= XmlTypeConstants.SCHEMA_PARSING_DONE %>">
                                        <jsp:include page="/database/schema/view/subXmlTypeInclude.jsp" />
                                        <uix:ref refID="subXmlTypeInclude" />
                                    </uix:case>
                                </uix:switcher>
                            </uix:contents>
                        </uix:tableLayout>
                    </uix:stackLayout>
                </uix:tableLayout>
            </uix:case>
            <uix:case name="false">
                <jsp:include page="/database/schema/view/subXmlTypeInclude.jsp" />
                <uix:ref refID="subXmlTypeInclude" />
            </uix:case>
        </uix:switcher>
        
    </uix:dataScope>    
</uix:buildTree>
