<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="addObjPrivsPageTitle@objectPageBean@servletRequest" />
  
    <script language="JavaScript">
      <%@ include file="/database/utils.js"%>
      function myCallBack(lovwin, event)
      {
          
      }
    
    </script>
    </uix:metaContainer>


    <uix:body>

     <db:form name="selectObj" method="POST" destinationBinding="destination@objectPageBean@servletRequest" copyParams="target,type,cancelURL,oname,otype">
      <uix:pageLayout titleBinding="addObjPrivsPageTitle@objectPageBean@servletRequest">
      
        <%@ include file="/database/global.jspf" %>
      
         
         <uix:formValue name="pageName" value="/database/security/addColObjPrivPage"/>
          <oem:messageBox messageType="info" errorTableBinding="info@servletRequest"
                             titleTextKey="titleText" mainTextKey="mainText"/>
          <oem:messageBox messageType="error" errorTableBinding="errors@servletRequest"
                             titleTextKey="titleText" mainTextKey="mainText"/>
        
       
        <uix:rowLayout>
          <uix:cellFormat hAlign="right">
            <uix:messagePrompt labeledNodeId="selectedSchemaObjectName" promptBinding="SELECT_COLUMN_OBJECTS@uixgranteeBundle@servletRequest" required="yes"/>
        </uix:cellFormat>
        </uix:rowLayout>
        <uix:rowLayout>
        <uix:stackLayout>
        <uix:messageLovField id="selectedSchemaObjectName"
                name="selectedSchemaObjectName" rows="5" columns="45"
                textBinding="selectedSchemaObjectName@objectPageBean@servletRequest"
                shortDescBinding="SELECT_COL_CLICK_TEXT@uixgranteeBundle@servletRequest"
                searchDescBinding="SELECT_COL_CLICK_TEXT@uixgranteeBundle@servletRequest"
                onClickBinding="objlovdest@servletRequest" />
        
        </uix:stackLayout>
        </uix:rowLayout>   
        <uix:rowLayout>
         <uix:cellFormat hAlign="right">
            <uix:messagePrompt prompt=""/>
         </uix:cellFormat>
         <uix:cellFormat hAlign="right">
              <uix:styledText textBinding="addColSchemaHint@objectPageBean@servletRequest" styleClass="OraInlineInfoText" />
          </uix:cellFormat>
         </uix:rowLayout >
         <uix:rowLayout>
         
         <uix:cellFormat hAlign="left">
              <uix:styledText textBinding="SELECT_OBJ_TEXT@uixgranteeBundle@servletRequest" styleClass="OraInlineInfoText" />
          </uix:cellFormat>
         </uix:rowLayout >
         
          <oem:shuttle name="selectedPrivs" leadingHeaderBinding="AVAILOBJ@uixgranteeBundle@servletRequest" trailingHeaderBinding="SELOBJ@uixgranteeBundle@servletRequest" size="5" reorderable="false" >
            <uix:leading>
              <oem:list shortDescBinding="AVAILOBJ@uixgranteeBundle@servletRequest" name="availablePrivs" multiple="true" optionsBinding="availablePrivs@objectPageBean@servletRequest"/>
            </uix:leading>
            <uix:trailing>
              <oem:list shortDescBinding="SELOBJ@uixgranteeBundle@servletRequest" name="selectedPrivNames" multiple="true" optionsBinding="selectedPrivNames@objectPageBean@servletRequest"/>
            </uix:trailing>
          </oem:shuttle>
        <uix:messageText messageBinding="privilegesGranted@errors@servletRequest" messageType="error"/>

        <uix:pageButtons>
          <uix:pageButtonBar>
            
            <uix:submitButton textBinding="CANCEL@uixDBObjectBundle@servletRequest" name="event" value="cancelAddObjPriv"/>
            <uix:submitButton textBinding="OK@uixDBObjectBundle@servletRequest" name="event" value="finishAddObjPriv"/>
            
            
	        </uix:pageButtonBar>
        </uix:pageButtons>
        
      </uix:pageLayout>
      </db:form>
      </uix:body>
    
</uix:document>
</uix:renderingContext> 
        
