<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="addConsumerGrpPageTitle@consumerGrpPageBean@servletRequest" />
  
    <script language="JavaScript">
      <%@ include file="/database/utils.js"%>
    </script>
    </uix:metaContainer>


    <uix:body>

     <db:form name="selectCons" method="POST" destinationBinding="destination@consumerGrpPageBean@servletRequest" copyParams="target,type,cancelURL,oname,otype">
      <uix:pageLayout titleBinding="addConsumerGrpPageTitle@consumerGrpPageBean@servletRequest">
      
        <%@ include file="/database/global.jspf" %>
      
        <uix:formValue name="pageName" value="/database/security/addDelConsumerGrpPage"/>
        <oem:messageBox messageType="info" errorTableBinding="info@servletRequest"
                             titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="error" errorTableBinding="errors@servletRequest"
                             titleTextKey="titleText" mainTextKey="mainText"/>
        
        
                
        <oem:shuttle name="selectedPrivs" leadingHeaderBinding="AVAILCONS@uixgranteeBundle@servletRequest" trailingHeaderBinding="SELCONS@uixgranteeBundle@servletRequest" size="5" reorderable="false" >
          <uix:leading>
            <oem:list shortDescBinding="AVAILCONS@uixgranteeBundle@servletRequest" name="availablePrivNames" multiple="true" optionsBinding="availablePrivNames@consumerGrpPageBean@servletRequest"/>
          </uix:leading>
          <uix:trailing>
            <oem:list shortDescBinding="SELCONS@uixgranteeBundle@servletRequest" name="selectedPrivNames" multiple="true" optionsBinding="selectedPrivNames@consumerGrpPageBean@servletRequest"/>
          </uix:trailing>
        </oem:shuttle>
        <uix:messageText messageBinding="privilegesGranted@errors@servletRequest" messageType="error"/>
        

        <uix:pageButtons>
          <uix:pageButtonBar>
            
            <uix:submitButton textBinding="CANCEL@uixDBObjectBundle@servletRequest" name="event" value="cancelAddConsumerGrp"/>
            <uix:submitButton textBinding="OK@uixDBObjectBundle@servletRequest" name="event" value="finishAddConsumerGrp"/>
            
            
	        </uix:pageButtonBar>
        </uix:pageButtons>
        
      </uix:pageLayout>
      </db:form>
      </uix:body>
    
</uix:document>
</uix:renderingContext> 


