<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="addSysPrivsPageTitle@systemPageBean@servletRequest" />
  
    <script language="JavaScript">
      <%@ include file="/database/utils.js"%>
    </script>
    </uix:metaContainer>


    <uix:body>

     <db:form name="selectSys" method="POST" destinationBinding="destination@systemPageBean@servletRequest" copyParams="target,type,cancelURL,oname,otype">
      <uix:pageLayout titleBinding="addSysPrivsPageTitle@systemPageBean@servletRequest">
      
        <%@ include file="/database/global.jspf" %>
      
        <uix:formValue name="pageName" value="/database/security/addDelSysPrivPage"/>
        <oem:messageBox messageType="info" errorTableBinding="info@servletRequest"
                             titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="error" errorTableBinding="errors@servletRequest"
                             titleTextKey="titleText" mainTextKey="mainText"/>
        
        
                
        <oem:shuttle name="selectedPrivs" leadingHeaderBinding="AVAILSYS@uixgranteeBundle@servletRequest" trailingHeaderBinding="SELSYS@uixgranteeBundle@servletRequest" size="5" reorderable="false" >
          <uix:leading>
            <oem:list shortDescBinding="AVAILSYS@uixgranteeBundle@servletRequest" name="availablePrivNames" multiple="true" optionsBinding="availablePrivNames@systemPageBean@servletRequest"/>
          </uix:leading>
          <uix:trailing>
            <oem:list shortDescBinding="SELSYS@uixgranteeBundle@servletRequest" name="selectedPrivNames" multiple="true" optionsBinding="selectedPrivNames@systemPageBean@servletRequest"/>
          </uix:trailing>
        </oem:shuttle>
        <uix:messageText messageBinding="privilegesGranted@errors@servletRequest" messageType="error"/>
        

        <uix:pageButtons>
          <uix:pageButtonBar>
            
            <uix:submitButton textBinding="CANCEL@uixDBObjectBundle@servletRequest" name="event" value="cancelAddSysPriv"/>
            <uix:submitButton textBinding="OK@uixDBObjectBundle@servletRequest" name="event" value="finishAddSysPriv"/>
            
            
	        </uix:pageButtonBar>
        </uix:pageButtons>
        
      </uix:pageLayout>
      </db:form>
      </uix:body>
    
</uix:document>
</uix:renderingContext> 
