<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:buildTree nodeID="auditSummaryInclude">

     <uix:tableLayout width="90%">

       <uix:rowLayout vAlign="top">
         <uix:cellFormat vAlign="top" width="50%">
         <uix:tableLayout>
          <uix:rowLayout>
           <uix:header textBinding="AUDITING_CONFIG_HDR@auditMsg">

            <uix:tableLayout>
              <uix:rowLayout>
                <uix:cellFormat width="20"/>
                <uix:cellFormat hAlign="right" wrappingDisabled="true">
                  <uix:messagePrompt promptBinding="AUDIT_TRAIL_HDR@auditMsg"/>
                </uix:cellFormat> 
                <uix:spacer width="8"/> 
                <uix:cellFormat wrappingDisabled="true">
                  <db:link textBinding="auditTrail@objectBean@servletRequest" 
                           destinationBinding="auditTrailDest@servletRequest"
                           renderedBinding="hasAuditTrail@objectBean@servletRequest"
                           copyParams="target,type"/>
                  <uix:styledText styleClass="OraDataText"
                                  renderedBinding="noAuditTrail@objectBean@servletRequest"
                                  text="N/A"/>
                </uix:cellFormat> 
              </uix:rowLayout>

              <%-- For pre 9.2, the audit_sys_opertions param is not available --%>
              <uix:rowLayout renderedBinding="hasAuditSysOperations@objectBean@servletRequest">
                <uix:cellFormat width="20"/>
                <uix:cellFormat hAlign="right" wrappingDisabled="true">
                  <uix:messagePrompt promptBinding="AUDIT_SYS_USER_OP_HDR@auditMsg"/>
                </uix:cellFormat> 
                <uix:spacer width="8"/> 
                <uix:cellFormat wrappingDisabled="true">
                  <db:link textBinding="auditSysOperations@objectBean@servletRequest" 
                           destinationBinding="auditSysOpDest@servletRequest"
                           copyParams="target,type"/>
                </uix:cellFormat> 
              </uix:rowLayout>

              <uix:rowLayout renderedBinding="hasAuditFileDest@objectBean@servletRequest">
                <uix:cellFormat width="20"/>
                <uix:cellFormat hAlign="right" vAlign="top" wrappingDisabled="true">
                  <uix:messagePrompt promptBinding="AUDIT_FILE_DIR_HDR@auditMsg"/>
                </uix:cellFormat> 
                <uix:spacer width="8"/> 
                <uix:cellFormat wrappingDisabled="true">
                  <db:link textBinding="auditFileDest@objectBean@servletRequest" 
                           destinationBinding="auditFileDestDest@servletRequest"
                           copyParams="target,type"/>
                </uix:cellFormat> 
              </uix:rowLayout>

              <uix:rowLayout renderedBinding="showFileDestHint@objectBean@servletRequest">
                <uix:cellFormat width="20"/>
                <uix:cellFormat hAlign="right" vAlign="top"> 
                  <uix:messagePrompt prompt=""/>
                </uix:cellFormat> 
                <uix:spacer width="8"/> 
                <uix:cellFormat wrappingDisabled="false">
                  <uix:styledText styleClass="OraInlineInfoText" 
                                  textBinding="AUDIT_FILE_DEST_HINT@auditMsg"/>
                </uix:cellFormat> 
              </uix:rowLayout>

              <uix:rowLayout> 
                <uix:spacer height="5"/> 
              </uix:rowLayout> 
              
              <uix:rowLayout> 
                <uix:cellFormat width="20"/>
                <uix:cellFormat hAlign="right" vAlign="top" wrappingDisabled="true">
                  <uix:messagePrompt promptBinding="DEFAULT_AUDIT_OPTIONS_HDR@auditMsg"/>
                </uix:cellFormat> 
                <uix:spacer width="8"/> 
                <uix:cellFormat> 
                  <db:link textBinding="numDefAudOptions@objectBean@servletRequest" 
                           destinationBinding="numDefAudOptionsDest@servletRequest"
                           copyParams="target,type"/>
                </uix:cellFormat> 
              </uix:rowLayout>
              
            </uix:tableLayout>
          </uix:header>
        </uix:rowLayout>

        <%-- Summary Section --%>
      </uix:tableLayout>
    </uix:cellFormat>

    <uix:cellFormat vAlign="top" width="50%" hAlign="right">
      <jsp:include page="/database/security/audit/auditTrailInclude.jsp" />
      <uix:ref refID="auditTrailInclude" />
    </uix:cellFormat> 
  </uix:rowLayout>

  </uix:tableLayout>
</uix:buildTree> 
