<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:buildTree nodeID="auditTrailInclude">

     <uix:tableLayout width="90%">

       <uix:rowLayout vAlign="top">
         <uix:header textBinding="AUDIT_TRAILS_HDR@auditMsg">
         
           <uix:tableLayout width="75%"> 
             <uix:rowLayout> 
               <uix:cellFormat vAlign="top" width="50%">
               
               <uix:tableLayout cellSpacing="5"> 
                 <uix:rowLayout> 
                  <uix:cellFormat hAlign="right" wrappingDisabled="true"> 
                    <uix:messagePrompt promptBinding="DB_AUDIT_TRAIL_TXT@auditMsg"/>
                  </uix:cellFormat> 
                  <uix:cellFormat width="8"/> 
                  <uix:cellFormat vAlign="top" wrappingDisabled="true">
                    <db:link textBinding="AUDITED_FAILED_LOGINS@auditMsg"
                             onClick="submitForm('auditForm', true, {event:'showFailedLogins'})"
                             renderedBinding="hasAuditTrail@objectBean@servletRequest"
                             copyParams="target,type"/>
                    <uix:styledText styleClass="OraDataText"
                                    renderedBinding="noAuditTrail@objectBean@servletRequest"
                                    text="N/A"/>
                  </uix:cellFormat> 
                </uix:rowLayout> 

                <uix:rowLayout> 
                  <uix:cellFormat/> 
                  <uix:cellFormat width="8"/> 
                  <uix:cellFormat vAlign="top" wrappingDisabled="true">
                    <db:link textBinding="AUDITED_PRIVS@auditMsg"
                             onClick="submitForm('auditForm', true, {event:'showAuditedPrivs'})"
                             renderedBinding="hasAuditTrail@objectBean@servletRequest"
                             copyParams="target,type"/>
                    <uix:styledText styleClass="OraDataText"
                                    renderedBinding="noAuditTrail@objectBean@servletRequest"
                                    text="N/A"/>
                  </uix:cellFormat> 
                </uix:rowLayout> 

                <uix:rowLayout> 
                  <uix:cellFormat/>
                  <uix:cellFormat width="8"/> 
                  <uix:cellFormat vAlign="top" wrappingDisabled="true">
                    <db:link textBinding="AUDITED_OBJS@auditMsg"
                             onClick="submitForm('auditForm', true, {event:'showAuditedObjs'})"
                             renderedBinding="hasAuditTrail@objectBean@servletRequest"
                             copyParams="target,type"/>
                    <uix:styledText styleClass="OraDataText"
                                    renderedBinding="noAuditTrail@objectBean@servletRequest"
                                    text="N/A"/>
                  </uix:cellFormat> 
                </uix:rowLayout> 
  
                <%-- disable for now
                <uix:rowLayout> 
                  <uix:cellFormat/>
                  <uix:cellFormat width="8"/> 
                  <uix:cellFormat vAlign="top" wrappingDisabled="true">
                    <db:link textBinding="AUDITED_STMTS@auditMsg"
                             onClick="submitForm('auditForm', true, {event:'showAuditedStmts'})"
                             renderedBinding="hasAuditTrail@objectBean@servletRequest"
                             copyParams="target,type"/>
                    <uix:styledText styleClass="OraDataText"
                                    renderedBinding="noAuditTrail@objectBean@servletRequest"
                                    text="N/A"/>
                  </uix:cellFormat> 
                </uix:rowLayout> 

              --%>
  
            <%-- OS audit trail link --%>
              <uix:rowLayout>
                <uix:cellFormat hAlign="right" wrappingDisabled="true"> 
                  <uix:messagePrompt promptBinding="OS_AUDIT_TRAIL_TXT@auditMsg"
                  />
                </uix:cellFormat> 
                <uix:cellFormat width="8"/> 
                <uix:cellFormat vAlign="top" wrappingDisabled="true">
                  <db:link textBinding="VIEW_OS_AUDIT_TRAILS@auditMsg"
                           onClick="submitForm('auditForm', true, {event:'launchRFV'})"
                           copyParams="auditFileDest"
                           />
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>
          </uix:cellFormat> 


      </uix:rowLayout>
    </uix:tableLayout>
  </uix:header>
  </uix:rowLayout>
 </uix:tableLayout>
</uix:buildTree> 
