<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        wizAction.jsp
  -- Controller:  oracle.sysman.db.adm.sec.AuditController
  --
  -- Description: Introduction page for security Audit
  --
  --  MODIFIED    (MM/DD/YY)
  --   mnihala 05/09/05 - Fix ADA bugs 
  --   qsong   05/02/05 - remove auditedObjectsSummaryInclude 
  --   qsong   01/14/05 - change layout
  --   qsong   12/06/04 - 
  --   qsong   11/23/04 - 
  --   qsong   11/10/04 - 
  --   qsong   08/25/04 - 
  --   qsong   07/19/04 - 
  --   qsong   06/18/04 - 
  --   qsong   06/16/04 - 
  --   qsong   06/15/04 - qsong_db_audit
  --   qsong   04/21/04 - Creation
  --%>


<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>
<db:script src="/database/LOV.js"/>
<db:script src="/database/utils.js"/>

<%-- Imports --%>
<%@ page import="oracle.sysman.emo.adm.security.audit.AuditConstants" %>

<uix:renderingContext id="renderingContext">
<uix:bundle name="dbMsg"
              class="oracle.sysman.db.rsc.DBObjectMsg"/>
<uix:bundle name="auditMsg"
              class="oracle.sysman.db.rsc.sec.AuditMsg"/>
<oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%-- Browser title.  Page name from controller getPageHeader() --%>
    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="title@objectBean@servletRequest"/>
    </uix:metaContainer>
    
    <%@ include file="/enablePPR.jspf" %>
    <uix:body>
      <%-- HTML Form --%>
      <db:form name="auditForm" method="post" copyParams="target,type">
        <uix:formValue name="pageName" value="/database/security/audit/auditedObjectsPage"/>
        <uix:formValue name="auditFileDest" valueBinding="auditFileDest@objectBean@servletRequest"/>
        <uix:formValue name="source"/> 
        <uix:pageLayout> 

          <%-- Oracle Logo and Tabs, breadcrumb data from --%>
          <%-- controller getNavigatorPath()              --%>
          <%@ include file="/database/global.jspf" %>

          <%-- Warning/Error display --%>
          <oem:messageBox messageType="info"
                          errorTableBinding="info@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>
          <oem:messageBox messageType="error"
                          errorTableBinding="errors@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>

        <uix:header textBinding="header@objectBean@servletRequest">
          <uix:switcher childNameBinding="auditEnabled@objectBean@servletRequest">
            <uix:case name="false">
              <uix:rowLayout>
                <uix:spacer height="5"/>
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:cellFormat width="15"/>
                <uix:image source="/em/images/warning.gif"/>
                <uix:cellFormat width="5"/>
                <uix:styledText styleClass="OraPromptText" textBinding="AUDIT_DISABLED_HINT@auditMsg"/>
              </uix:rowLayout>
            </uix:case> 
          </uix:switcher>

          <%-- Audit Trail Instruction Text --%>
          <uix:rowLayout>
            <uix:cellFormat width="20"/>
            <uix:switcher childNameBinding="auditEnabled@objectBean@servletRequest">
              <uix:case name="true">
                <uix:image source="/em/images/infoicon_active.gif"/>
              </uix:case> 
            </uix:switcher>
            <uix:cellFormat width="5"/>
            <uix:styledText styleClass="OraInstructionText" 
                            textBinding="auditTrailHint@objectBean@servletRequest"/>
          </uix:rowLayout>

          <%-- audit config/summary include --%> 
          <jsp:include page="/database/security/audit/auditSummaryInclude.jsp" />
          <uix:ref refID="auditSummaryInclude" />
         
          <%-- adding this empty header so that the subTabs will align with the upper section --%>
          <uix:header text="">
          <uix:subTabLayout>
            <uix:subTabs>
              <jsp:include page="/database/security/audit/subTabsInclude.jsp" />
              <uix:ref refID="auditSubTabsInclude"/>
            </uix:subTabs>

          <uix:spacer height="10"/>

          <uix:tableLayout hAlign="center" width="90%">
            <uix:dataScope currentDataBinding="auditObjectsDS@servletRequest">
              <uix:rowLayout>
                <uix:tableLayout cellSpacing="5">
                  <uix:rowLayout>

                    <uix:tableLayout> 
                      <uix:rowLayout> 
                        <uix:messagePrompt labeledNodeId="objectOwner"
                                           promptBinding="SCHEMA@dbMsg"/>
                      </uix:rowLayout> 
                      <uix:rowLayout> 
                        <uix:messageLovField id="objectOwner"
                                             name="<%= AuditConstants.S_OBJECT_OWNER %>"
                                             searchDescBinding="SCHEMA@dbMsg"
                                             textBinding="objectOwner@"
                                             columns="15"
                                             onClick="startLov('objectOwner', 'ListSchema')"/>
                      </uix:rowLayout>
                    </uix:tableLayout>

                    <uix:tableLayout>
                      <uix:rowLayout>
                        <uix:messagePrompt labeledNodeId="objectName"
                                           promptBinding="AUDIT_ONAME_HDR@auditMsg"/>
                      </uix:rowLayout> 
                      <uix:rowLayout> 
                        <uix:textInput id="objectName"
                                       name="<%= AuditConstants.S_OBJECT_NAME %>"
                                       shortDescBinding="AUDIT_ONAME_HDR@auditMsg"
                                       columns="15"
                                       textBinding="objectName@"/>
                      </uix:rowLayout>
                    </uix:tableLayout>

                    <uix:tableLayout>
                      <uix:rowLayout>
                        <uix:messagePrompt labeledNodeId="objectType"
                                           promptBinding="AUDIT_OTYPE_HDR@auditMsg"/>
                      </uix:rowLayout>
                      <uix:rowLayout>
                        <uix:textInput id="objectType"
                                       name="<%= AuditConstants.S_OBJECT_TYPE %>"
                                       shortDescBinding="AUDIT_OTYPE_HDR@auditMsg"
                                       columns="15"
                                       textBinding="objectType@"/>
                        <uix:spacer width="5"/>
                        <uix:submitButton textBinding="SEARCH@dbMsg" 
                                          name="event" value="searchAuditObject"/>
                      </uix:rowLayout>
                    </uix:tableLayout>

                  </uix:rowLayout>
                </uix:tableLayout> 
              </uix:rowLayout>

              <uix:rowLayout>
                <uix:separator>
                  <uix:spacer height="10"/>
                </uix:separator>
             </uix:rowLayout>
 
             <uix:rowLayout width="100%"> 
               <uix:cellFormat hAlign="right" vAlign="bottom" width="100%">
                 <uix:submitButton textBinding="ADD@dbMsg" name="event" value="createAuditObj"/>
               </uix:cellFormat>
             </uix:rowLayout>

             <uix:rowLayout>
               <uix:table id="auditObjsList"
                          alternateTextBinding="NO_OBJECT_FOUND@dbMsg"
                          formSubmitted="true"
                          width="100%"
                          tableDataBinding="rowData"
                          minValue="1"
                          valueBinding="startIndex"
                          maxValueBinding="numRows"
                          blockSizeBinding="blockSize"
                          summaryBinding="AUDITED_OBJS@auditMsg"
                          partialRenderMode="self">
<%--
                          detailDisclosureBinding="detailData"
                          allDetailsEnabled="true"
--%>

                 <uix:tableFormat tableBanding="rowBanding"/>

                   <uix:column>
                     <uix:columnHeader>
                       <uix:sortableHeader textBinding="AUDIT_SCHEMA_HDR@auditMsg"
                                           sortableBinding="<%= AuditConstants.S_SORT_SCHEMA_COL %>" />
                     </uix:columnHeader>
                     <uix:columnFormat columnDataFormat="textFormat"/>
                     <uix:styledText textBinding="<%= AuditConstants.S_SCHEMA_COL %>"/>
                   </uix:column>

                   <uix:column>
                     <uix:columnHeader>
                       <uix:sortableHeader textBinding="AUDIT_ONAME_HDR@auditMsg"
                                           sortableBinding="<%= AuditConstants.S_SORT_ONAME_COL %>" />
                     </uix:columnHeader>
                     <uix:columnFormat columnDataFormat="textFormat"/>
                     <uix:styledText textBinding="<%= AuditConstants.S_ONAME_COL %>"/>
                   </uix:column>

                   <uix:column>
                     <uix:columnHeader>
                       <uix:sortableHeader textBinding="AUDITED_STMT@auditMsg"
                                           sortableBinding="<%= AuditConstants.S_SORT_STATEMENT_COL %>" />
                     </uix:columnHeader>
                     <uix:columnFormat columnDataFormat="textFormat"/>
                     <uix:styledText textBinding="<%= AuditConstants.S_AUD_OPT_COL %>"/>
                   </uix:column>

                   <uix:column>
                     <uix:columnHeader>
                       <uix:sortableHeader textBinding="SUCCESS@auditMsg"
                                           sortableBinding="<%= AuditConstants.S_SORT_SUCCESS_COL %>" />
                     </uix:columnHeader>
                     <uix:columnFormat columnDataFormat="textFormat"/>
                     <uix:styledText textBinding="<%= AuditConstants.S_SUCCESS_COL %>"/>
                   </uix:column>

                   <uix:column>
                     <uix:columnHeader>
                       <uix:sortableHeader textBinding="FAILURE@auditMsg"
                                           sortableBinding="<%= AuditConstants.S_SORT_FAILURE_COL %>" />
                     </uix:columnHeader>
                     <uix:columnFormat columnDataFormat="textFormat"/>
                     <uix:styledText textBinding="<%= AuditConstants.S_FAILURE_COL %>"/>
                   </uix:column>
                   

                   <uix:column>
                     <uix:columnHeader>
                       <uix:sortableHeader textBinding="AUDIT_OTYPE_HDR@auditMsg"
                                           sortableBinding="<%= AuditConstants.S_SORT_OTYPE_COL %>"/>
                     </uix:columnHeader>
                     <uix:columnFormat columnDataFormat="textFormat"/>
                     <uix:styledText textBinding="<%= AuditConstants.S_OTYPE_COL %>"/>
                   </uix:column>

                   <uix:tableSelection>
                     <uix:multipleSelection selectedBinding="select" shortDescBinding="SELECT@dbMsg">
                       <uix:submitButton textBinding="REMOVE@dbMsg" 
                                         name="event" 
                                         value="deleteAuditObj" 
                                         shortDesc="Remove audit options from selected object"/>
                     </uix:multipleSelection>
                   </uix:tableSelection>

                 </uix:table>
               </uix:rowLayout>
             </uix:dataScope>
           </uix:tableLayout>

           <uix:rowLayout>
             <uix:spacer height="20"/>
           </uix:rowLayout>
         </uix:subTabLayout>
        </uix:header>

       </uix:header>
     </uix:pageLayout>
   </db:form>
 </uix:body>
</uix:document>
</uix:renderingContext>        
         
