<%@ include file="/sdk/oemTop.jspf" %>
<%-- 
   MODIFIED    (MM/DD/YY)
      mperugu   03/11/09 - fix for bug 8307802
      sshastry  03/20/06 - To fix translation errors
      mnihalan  05/09/05 - Fix ADA bugs 
      qsong     11/18/04 - 
      qsong     06/16/04 - 
      qsong     06/15/04 - qsong_db_audit
      qsong     04/25/04 - Created
--%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ page import="oracle.sysman.db.rsc.DBObjectMsgID" %>
<%@ page import="oracle.sysman.emo.adm.security.audit.AuditConstants" %>
<db:script src="/database/LOV.js"/>

<script language="javascript">
function getSelectedObjectType()
{
    obj = eval (document.forms[0].selectedAuditObject);
    value = obj[obj.selectedIndex].value;
    return value;
}

function getSelectedSynonymRefType()
{
    obj = eval (document.forms[0].selectedSynRefAuditOType);
    value = obj[obj.selectedIndex].value;
    return value;
}

function isOnPublicSynonym()
{
  return eval (document.forms[0].onPubSyn[1].checked);
}

function popWindow(otype)
{
  search_event = 'ListTable';
  if( otype == "<%= DBObjectMsgID.TABLE%>" )
    search_event = 'ListTable';
  else if( otype == "<%= DBObjectMsgID.VIEW%>" )
    search_event = 'ListView';
  else if( otype == "<%= DBObjectMsgID.SEQUENCE%>" )
    search_event = 'ListSequence';
  else if( otype == "<%= DBObjectMsgID.PROCEDURE%>" )
    search_event = 'ListProcedure';
  else if( otype == "<%= DBObjectMsgID.FUNCTION%>" )
    search_event = 'ListFunction';
  else if( otype == "<%= DBObjectMsgID.PACKAGE%>" )
    search_event = 'ListPackage';
  else if( otype == "<%= DBObjectMsgID.MATERIALIZED_VIEW%>" )
    search_event = 'ListMView';
  else if( otype == "<%= DBObjectMsgID.DIRECTORY%>" )
    search_event = 'ListDirectory';
  else if( otype == "<%= DBObjectMsgID.LIBRARY%>" )
    search_event = 'ListLibrary';
  else if( otype == "<%= DBObjectMsgID.OBJECTTYPE%>" )
    search_event = 'ListObjecttype';
 /* else if( otype == "<%= DBObjectMsgID.CONTEXT%>" )
    search_event = 'ListContext';*/
  else if( otype == "<%= DBObjectMsgID.SYNONYM%>" )
    search_event = 'ListSynonym';
 
  setSearchFilter("schema");
  startLov('onObjectName', search_event);
}

function popSynonymWindow(isOnPubSyn, otype)
{
  search_event = 'ListSynonym';
  if( otype == "<%= DBObjectMsgID.TABLE%>" )
    search_event = 'ListTableSynonym';
  else if( otype == "<%= DBObjectMsgID.VIEW%>" )
    search_event = 'ListViewSynonym';
  else if( otype == "<%= DBObjectMsgID.SEQUENCE%>" )
    search_event = 'ListSequenceSynonym';
  else if( otype == "<%= DBObjectMsgID.PROCEDURE%>" )
    search_event = 'ListProcedureSynonym';
  else if( otype == "<%= DBObjectMsgID.FUNCTION%>" )
    search_event = 'ListFunctionSynonym';
  else if( otype == "<%= DBObjectMsgID.PACKAGE%>" )
    search_event = 'ListPackageSynonym';
  else if( otype == "<%= DBObjectMsgID.MATERIALIZED_VIEW%>" )
    search_event = 'ListMViewSynonym';
  else if( otype == "<%= DBObjectMsgID.ARRAYTYPE%>" )
    search_event = 'ListArraytypeSynonym';
  else if( otype == "<%= DBObjectMsgID.TABLETYPE%>" )
    search_event = 'ListTabletypeSynonym';
  else if( otype == "<%= DBObjectMsgID.OBJECTTYPE%>" )
    search_event = 'ListObjecttypeSynonym';

  if( isOnPubSyn )
  {
    setSearchFilter("publicUser");
    setDisabledFilter(0);
  }
  else
    setSearchFilter("schema");
  startLov('onSynonymName', search_event);
}

function callBackLov()
{
}
</script>

<uix:renderingContext id="renderingContext">
<uix:bundle name="dbMsg"
	    class="oracle.sysman.db.rsc.DBObjectMsg"/>
<uix:bundle name="auditMsg"
	    class="oracle.sysman.db.rsc.sec.AuditMsg"/>

  <oem:setURLEncoder id="renderingContext"/>
<uix:document>
<uix:metaContainer>
  <uix:head titleBinding="title@auditObjBean@servletRequest"/>
</uix:metaContainer>
<uix:link id="TOP"/>

<uix:body>
     <db:form name="auditObjForm"  
               method="post"
               destination="/console/database/security/objectAudit"
               copyParams="target,type,cancelURL">
     <uix:formValue name="pageName" value="/database/security/audit/createAuditObjPage"/>
     <uix:formValue name="schema" valueBinding="loginName@auditObjBean@servletRequest"/> 
     <uix:formValue name="source"/> 
     <uix:formValue name="publicUser" value="PUBLIC"/> 
   <uix:pageLayout titleBinding="header@auditObjBean@servletRequest">

      <%-- Oracle Logo and Tabs --%>
      <%@ include file="/database/global.jspf" %>
    
      <%-- Warning/Error display --%>
      <oem:messageBox messageType="info"
                      errorTableBinding="info@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>
      <oem:messageBox messageType="error"
                      errorTableBinding="errors@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>

            <uix:tableLayout cellSpacing="5"> 

            <uix:rowLayout renderedBinding="createNotInContext@auditObjBean@servletRequest">
              <uix:tableLayout cellSpacing="5"> 
                <uix:rowLayout>
                  <uix:tableLayout width="100%">
                    <uix:rowLayout>
                      <uix:cellFormat width="10"/>
                      <uix:styledText textBinding="CREATE_AUDIT_OBJ_TIP@auditMsg" styleClass="OraInstructionText" />
                    </uix:rowLayout>
                  </uix:tableLayout>
                </uix:rowLayout>

                <%-- Audit Object Type --%>
                <uix:rowLayout>
                  <uix:tableLayout cellSpacing="5">
                    <uix:rowLayout>
                      <uix:cellFormat hAlign="right" width="100">
                        <uix:messagePrompt promptBinding="OBJECT_TYPE@dbMsg" labeledNodeId="selectedAuditObject"/>
                      </uix:cellFormat>
                      <uix:choice name="selectedAuditObject"
                                  id="selectedAuditObject"
                                  onChange="submitForm('auditObjForm', true, {'event':'changeObjectType'})"
                                  selectedValueBinding="selectedAuditObject@auditObjBean@servletRequest">
                        <uix:contents childDataBinding="objectAuditObjects@auditObjBean@servletRequest">
                          <uix:option textBinding="textKey"
                                      valueBinding="valueKey"/>
                        </uix:contents> 
                      </uix:choice> 
                    </uix:rowLayout>
                  </uix:tableLayout>
                </uix:rowLayout>
                <%-- end Audit Object Type --%>
              </uix:tableLayout> 
            </uix:rowLayout> 

            <uix:rowLayout> 
              <uix:tableLayout> 
                <uix:rowLayout> 
                  <uix:tableLayout> 
                    <uix:rowLayout> 
                      <%-- object type cell --%>
                      <uix:cellFormat vAlign="top" width="50%">
                        <uix:header textBinding="auditAttrHeader@auditObjBean@servletRequest">
                          <uix:tableLayout cellSpacing="5" renderedBinding="createNotInContext@auditObjBean@servletRequest">
    
                            <%-- Audit Object Type --%>
                            <uix:rowLayout renderedBinding="createOnObject@auditObjBean@servletRequest">
                              <uix:tableLayout cellSpacing="5">
                                <uix:rowLayout>
                                  <uix:cellFormat vAlign="top" hAlign="right"> 
                                    <uix:messagePrompt promptBinding="selectedAuditObjectText@auditObjBean@servletRequest" labeledNodeId="OBJECT_NAME"/>
                                  </uix:cellFormat> 
                                  <uix:stackLayout> 
                                    <uix:lovField name="onObjectName"
                                                  id="OBJECT_NAME" searchDescBinding="OBJECT_TYPE@dbMsg"
                                                  textBinding="onObjectName@auditObjBean@servletRequest"
                                                  onClick='<%= "popWindow(getSelectedObjectType())" %>'/>
                                    <uix:messageText messageBinding="onObjectName@errors@servletRequest" messageType="error"/>
                                  </uix:stackLayout> 
                                </uix:rowLayout>
                              </uix:tableLayout>
                            </uix:rowLayout>
                            <%-- end Audit Object Type --%>

                            <%-- Synonym For Audit Object Type --%>
                            <uix:rowLayout renderedBinding="createOnSynonym@auditObjBean@servletRequest">
                              <uix:tableLayout cellSpacing="5">
                                <uix:rowLayout>
                                  <uix:cellFormat hAlign="right" wrappingDisabled="true"> 
                                    <uix:messagePrompt promptBinding="REF_OTYPE_TXT@auditMsg" labeledNodeId="selectedSynRefAuditOType"/>
                                  </uix:cellFormat>
                                  <uix:choice name="selectedSynRefAuditOType"
                                              id="selectedSynRefAuditOType"
                                              onChange="submitForm('auditObjForm', true, {'event':'changeSynRefOType'})"
                                              selectedValueBinding="selectedSynRefAuditOType@auditObjBean@servletRequest">
                                    <uix:contents childDataBinding="objectAuditSynonymOTypes@auditObjBean@servletRequest">
                                      <uix:option textBinding="textKey"
                                                  valueBinding="valueKey"/>
                                    </uix:contents>
                                  </uix:choice>
                                </uix:rowLayout>
    
                                <uix:rowLayout>
                                  <uix:cellFormat vAlign="top" hAlign="right" wrappingDisabled="true"> 
                                    <uix:messagePrompt promptBinding="SYNONYM@dbMsg"/>
                                  </uix:cellFormat>
                                  <uix:cellFormat>
                                  <uix:tableLayout cellSpacing="5">
                                    <uix:rowLayout> 
                                      <uix:tableLayout> 
                                        <uix:rowLayout vAlign="top"> 
                                          <oem:radioButton name="onPubSyn" 
                                                           value="false"
                                                           textBinding="NONE_PUBLIC@auditMsg"
                                                           selectedValueBinding="onPubSyn@auditObjBean@servletRequest"/>
                                          <uix:spacer width="5"/>
                                          <oem:radioButton name="onPubSyn" 
                                                           value="true"
                                                           textBinding="PUBLIC@auditMsg"
                                                           selectedValueBinding="onPubSyn@auditObjBean@servletRequest"/>
                                        </uix:rowLayout> 
                                      </uix:tableLayout> 
                                    </uix:rowLayout>
                                    <uix:rowLayout>
                                      <uix:stackLayout>
                                        <uix:lovField name="onSynonymName"
                                                      id="SYNONYM_NAME" searchDescBinding="SYNONYM@dbMsg" shortDescBinding="SYNONYM@dbMsg"
                                                      textBinding="onSynonymName@auditObjBean@servletRequest"
                                                      onClick='<%= "popSynonymWindow(isOnPublicSynonym(), getSelectedSynonymRefType())" %>'/>
                                        <uix:messageText messageBinding="onSynonymName@errors@servletRequest" messageType="error"/>
                                      </uix:stackLayout>
                                    </uix:rowLayout>
                                  </uix:tableLayout>
                                  </uix:cellFormat>
                                </uix:rowLayout>
                              </uix:tableLayout>
                            </uix:rowLayout>
                            <%-- end Synonym For Audit Object Type --%>
                          </uix:tableLayout>

                          <uix:tableLayout cellSpacing="5">
                            <%-- Shuttle --%>
                            <uix:rowLayout>
                              <uix:stackLayout>
                                <oem:shuttle name="objAuditOptions"
                                             leadingHeaderBinding="AVAILABLE_STMTS_HDR@auditMsg"
                                             trailingHeaderBinding="SELECTED_STMTS_HDR@auditMsg"
                                             reorderable="false">
                                  <uix:leading>
                                    <oem:list name="availableObjectOptions" 
					      shortDescBinding="AVAILABLE_STMTS_HDR@auditMsg"
                                              optionsBinding="availableObjectOptions@auditObjBean@servletRequest" 
                                              multiple="true"/>
                                  </uix:leading>
                                  <uix:trailing>
                                    <oem:list name="selectedObjectOptions" 
					      shortDescBinding="SELECTED_STMTS_HDR@auditMsg"
                                              optionsBinding="selectedObjectOptions@auditObjBean@servletRequest"
                                              multiple="true"/>
                                  </uix:trailing>
                                </oem:shuttle>
                                <uix:messageText messageBinding="selectedObjectOptions@errors@servletRequest" messageType="error"/>
                              </uix:stackLayout>
                            </uix:rowLayout>
                            <%-- end Shuttle --%>
                        </uix:tableLayout>


                    </uix:header> 
                  </uix:cellFormat> 
                  <%-- end object type cell --%>

                  <%-- Options Include Cell--%>
                  <uix:cellFormat vAlign="top" width="50%">
                    <uix:dataScope currentDataBinding="auditObjBean@servletRequest">
                      <jsp:include page="/database/security/audit/auditOptionsInclude.jsp" />
                      <uix:ref refID="auditOptionsInclude" />
                    </uix:dataScope> 
                  </uix:cellFormat>
                  <%-- end Options Include Cell--%>

                </uix:rowLayout> 
                </uix:tableLayout> 
                </uix:rowLayout>
              </uix:tableLayout>
            </uix:rowLayout>

          </uix:tableLayout>

      <%-- Create/Edit Buttons --%>
      <uix:pageButtons>
        <uix:pageButtonBar>
          <jsp:include page="/database/schema/pageButtonInclude.jsp" />
          <uix:ref refID="pageButtonInclude" />
        </uix:pageButtonBar>
      </uix:pageButtons>

      </uix:pageLayout>
     </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

