<%@ include file="/sdk/oemTop.jspf" %>
<%-- 
   MODIFIED    (MM/DD/YY)
      sshastry  03/20/06 - To fix translation error
      mnihalan  05/09/05 - Fix ADA bugs 
      qsong     06/15/04 - qsong_db_audit
      qsong     04/25/04 - Created
--%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<db:script src="/database/LOV.js"/>

<%-- Imports --%>
<%@ page import="oracle.sysman.emo.adm.security.audit.AuditConstants" %>

<uix:renderingContext id="renderingContext">
<uix:bundle name="dbMsg"
	    class="oracle.sysman.db.rsc.DBObjectMsg"/>
<uix:bundle name="auditMsg"
	    class="oracle.sysman.db.rsc.sec.AuditMsg"/>

  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>
<uix:metaContainer>
  <uix:head titleBinding="title@auditPrivBean@servletRequest"/>
</uix:metaContainer>
<uix:link id="TOP"/>

    <uix:body>
      <db:form name="auditPrivForm"  
               method="post"
               destination="/console/database/security/privilegeAudit"
               copyParams="target,type,cancelURL">
     <uix:formValue name="pageName" value="/database/security/audit/createAuditPrivPage"/>
     <uix:formValue name="source"/> 
   <uix:pageLayout titleBinding="header@auditPrivBean@servletRequest">

      <%-- Oracle Logo and Tabs --%>
      <%@ include file="/database/global.jspf" %>
    
      <%-- Warning/Error display --%>
      <oem:messageBox messageType="info"
                      errorTableBinding="info@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>
      <oem:messageBox messageType="error"
                      errorTableBinding="errors@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>

      <uix:tableLayout cellSpacing="5" width="100%">
        <uix:rowLayout>
            <uix:cellFormat vAlign="top" width="40%">
         <uix:header textBinding="AUDITED_PRIVS@auditMsg">
          <uix:tableLayout cellSpacing="5">
            <uix:rowLayout>
              <uix:tableLayout>
                <uix:rowLayout>
                  <%--<uix:cellFormat/>--%>
                  <uix:styledText textBinding="CREATE_AUDIT_PRIV_PRIVS_TIP@auditMsg" styleClass="OraInstructionText"/> 
               
               </uix:rowLayout>
              </uix:tableLayout>
            </uix:rowLayout> 

            <uix:rowLayout> 
              <uix:spacer height="5"/> 
            </uix:rowLayout> 

            <uix:rowLayout> 
              <uix:tableLayout>
                <uix:rowLayout>
               <%--   <uix:cellFormat width="50%"/> --%>
                  <uix:cellFormat> 
                  <oem:shuttle name="auditPrivOptions"
                               leadingHeaderBinding="AVAILABLE_PRIVS_HDR@auditMsg"
                               trailingHeaderBinding="SELECTED_PRIVS_HDR@auditMsg"
                               reorderable="false">
                    <uix:leading>
                      <oem:list name="availPrivilegeOptions"
				shortDescBinding="AVAILABLE_PRIVS_HDR@auditMsg"
                                optionsBinding="availPrivilegeOptions@auditPrivBean@servletRequest"
                                multiple="true"/>
                    </uix:leading>
                    <uix:trailing>
                      <oem:list name="selectedPrivilegeOptions"
				shortDescBinding="SELECTED_PRIVS_HDR@auditMsg"
                                optionsBinding="selectedPrivilegeOptions@auditPrivBean@servletRequest"
                                multiple="true"/>
                    </uix:trailing>
                  </oem:shuttle>
                  <uix:messageText messageBinding="selectedPrivilegeOptions@errors@servletRequest" messageType="error"/>
                  </uix:cellFormat> 
                </uix:rowLayout>
              </uix:tableLayout>
            </uix:rowLayout>
          </uix:tableLayout> 
        </uix:header>

               <uix:header textBinding="AUDITED_ROLES_HDR@auditMsg">
          <uix:tableLayout cellSpacing="5">
            <uix:rowLayout width="50%">
              <uix:tableLayout>
                <uix:rowLayout>
                   <uix:styledText textBinding="CREATE_AUDIT_PRIV_ROLE_TIP@auditMsg" styleClass="OraInstructionText"/>
                </uix:rowLayout>
              </uix:tableLayout>
            </uix:rowLayout>

            <uix:rowLayout>
              <uix:spacer height="10"/>
            </uix:rowLayout>

            <uix:rowLayout>
              <uix:tableLayout>
                <uix:rowLayout>
                   <uix:cellFormat width="40" />
                   <uix:cellFormat vAlign="top">
                    <uix:checkBox name="connect" 
                                  text="CONNECT" 
                                  checkedBinding="connect@auditPrivBean@servletRequest"/>
                  </uix:cellFormat>
                  <uix:spacer width="10"/>
                  <uix:cellFormat vAlign="top">
                    <uix:checkBox name="dba" 
                                  text="DBA" 
                                  checkedBinding="dba@auditPrivBean@servletRequest"/>
                  </uix:cellFormat>
                  <uix:spacer width="10"/>
                  <uix:cellFormat vAlign="top">
                    <uix:checkBox name="resource" 
                                  text="RESOURCE" 
                                  checkedBinding="resource@auditPrivBean@servletRequest"/>
                  </uix:cellFormat>
                </uix:rowLayout>
              </uix:tableLayout>
            </uix:rowLayout>
          </uix:tableLayout>
        </uix:header>
  
        </uix:cellFormat> 
        
 
        <uix:cellFormat vAlign="top" width="60%">


          <uix:dataScope currentDataBinding="auditPrivBean@servletRequest">
          <uix:tableLayout> 
          <jsp:include page="/database/security/audit/auditOptionsInclude2.jsp" />
          <uix:ref refID="auditOptionsInclude" />
          </uix:tableLayout> 
        </uix:dataScope> 

       
      </uix:cellFormat>
       </uix:rowLayout>
      </uix:tableLayout> 


        <%-- Create/Edit Buttons --%>
        <uix:pageButtons>
        <uix:pageButtonBar>
          <jsp:include page="/database/schema/pageButtonInclude.jsp" />
          <uix:ref refID="pageButtonInclude" />
        </uix:pageButtonBar>
        </uix:pageButtons>

      </uix:pageLayout>
        </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

