<%@ include file="/sdk/oemTop.jspf" %>
<%-- 
   MODIFIED    (MM/DD/YY)
      mnihalan  05/09/05 - Fix ADA bugs 
      qsong     06/15/04 - qsong_db_audit
      qsong     04/25/04 - Created
--%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<db:script src="/database/LOV.js"/>

<%-- Imports --%>
<%@ page import="oracle.sysman.emo.adm.security.audit.AuditConstants" %>

<uix:renderingContext id="renderingContext">
<uix:bundle name="dbMsg"
	    class="oracle.sysman.db.rsc.DBObjectMsg"/>
<uix:bundle name="auditMsg"
	    class="oracle.sysman.db.rsc.sec.AuditMsg"/>

  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>
<uix:metaContainer>
  <uix:head titleBinding="title@auditStmtBean@servletRequest"/>
</uix:metaContainer>
<uix:link id="TOP"/>

    <uix:body>
      <db:form name="auditStmtForm"  
               method="post"
               destination="/console/database/security/statementAudit"
               copyParams="target,type,cancelURL">
     <uix:formValue name="pageName" value="/database/security/audit/createAuditStmtPage"/>
     <uix:formValue name="source"/> 
   <uix:pageLayout titleBinding="header@auditStmtBean@servletRequest">

      <%-- Oracle Logo and Tabs --%>
      <%@ include file="/database/global.jspf" %>
    
      <%-- Warning/Error display --%>
      <oem:messageBox messageType="info"
                      errorTableBinding="info@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>
      <oem:messageBox messageType="error"
                      errorTableBinding="errors@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>

      <uix:tableLayout cellSpacing="5" width="100%">
        <uix:rowLayout> 
        <uix:cellFormat vAlign="top" width="50%"> 
          <uix:header textBinding="SQL_STMT_OP_HDR@auditMsg">
            <uix:spacer height="10"/> 
                  <oem:shuttle name="stmtAuditOptions"
                               leadingHeaderBinding="AVAILABLE_STMTS_HDR@auditMsg"
                               trailingHeaderBinding="SELECTED_STMTS_HDR@auditMsg"
                               reorderable="false">
                    <uix:leading>
                      <oem:list name="availStatementOptions"
                                optionsBinding="availStatementOptions@auditStmtBean@servletRequest"
				shortDescBinding="AVAILABLE_STMTS_HDR@auditMsg"
                                multiple="true"/>
                    </uix:leading>
                    <uix:trailing>
                      <oem:list name="selectedStatementOptions"
                                optionsBinding="selectedStatementOptions@auditStmtBean@servletRequest"
				shortDescBinding="SELECTED_STMTS_HDR@auditMsg"
                                multiple="true"/>
                    </uix:trailing>
                  </oem:shuttle>
                  <uix:messageText messageBinding="selectedStatementOptions@errors@servletRequest" messageType="error"/>
         </uix:header> 
        </uix:cellFormat> 
        <uix:cellFormat vAlign="top" width="50%"> 
        <uix:dataScope currentDataBinding="auditStmtBean@servletRequest">
          <uix:tableLayout> 
          <jsp:include page="/database/security/audit/auditOptionsInclude.jsp" />
          <uix:ref refID="auditOptionsInclude" />
          </uix:tableLayout> 
        </uix:dataScope> 
        </uix:cellFormat> 
      </uix:rowLayout>

      </uix:tableLayout> 


        <%-- Create/Edit Buttons --%>
        <uix:pageButtons>
        <uix:pageButtonBar>
          <jsp:include page="/database/schema/pageButtonInclude.jsp" />
          <uix:ref refID="pageButtonInclude" />
        </uix:pageButtonBar>
        </uix:pageButtons>

      </uix:pageLayout>
        </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

