<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:       dbAuditTrailContentsPage.jsp
  -- Controller: db/adm/sec/DBAuditTrailBrowserController.java
  --
  -- Description: This is the results page for the DB audit trail link from audit home page
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>
<jsp:useBean id="objectBean" scope="request"
   type="oracle.sysman.emo.adm.schema.DisplayContentsObject"/>

<db:script src="/database/utils.js"/>

<uix:renderingContext id="renderingContext">
  <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>
  <uix:bundle name="audMsgs" class="oracle.sysman.db.rsc.sec.AuditMsg"/>
<oem:setURLEncoder id="renderingContext"/>
<uix:document>


<%-- HTML Page Title --%>
<uix:metaContainer>
  <uix:head titleBinding="title@objectBean@servletRequest"/>
</uix:metaContainer>

<uix:body>
<db:form name="dataBrowserForm"
         method="post"
         destinationBinding="destination@objectBean@servletRequest"
         copyParams="target,type,cancelURL,sname,oname,otype"> 
<uix:formValue name="pageName" value="/database/security/audit/dbAuditTrailContentsPage"/>
<uix:formValue name="value" />
<uix:formValue name="source" />
<uix:pageLayout titleBinding="header@objectBean@servletRequest">

  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/global.jspf" %>

    <uix:tableLayout width="100%" cellSpacing="5"> 

      <%-- SQL --%>
      <uix:rowLayout width="100%">
        <uix:hideShow id="hideShow"
                      undisclosedTextBinding="SHOW_SQL@audMsgs"
                      disclosedTextBinding="HIDE_SQL@audMsgs"
                      disclosedBinding="showSQL@objectBean@servletRequest"
                      formSubmitted="true">
          <uix:textInput id="SQL" name="sql" textBinding="sql@objectBean@servletRequest" 
                         columns="100" rows="5" readOnly="true"
                         shortDescBinding="QUERY@uixDBObjectBundle@servletRequest"/>
        </uix:hideShow>
      </uix:rowLayout>

      <uix:rowLayout>
      <uix:spacer height="8"/>
      </uix:rowLayout>

      <%-- Result Table --%>
      <uix:rowLayout width="100%"> 
        <oem:table name="tableViewDataBrowingUIDS" dataSourceProp="tableViewDataBrowingUIDS"
                   destinationBinding="destination@objectBean@servletRequest"
                   formSubmitted="true" width="95%" blockSize="25"
                   summaryBinding="RESULT@dbMsgs"
                   showAll="no"
                   copyParams="target,type,cancelURL,sname,oname,otype" >
        </oem:table>
      </uix:rowLayout>
      
      <%-- tip --%>
      <uix:rowLayout renderedBinding="needTip@objectBean@servletRequest">
	<uix:cellFormat hAlign="left" wrappingDisabled="true">
        <uix:spacer height="10"/>
        <uix:tip textBinding="tip@objectBean@servletRequest"/>
	</uix:cellFormat>
      </uix:rowLayout>

    </uix:tableLayout>

    <uix:pageButtons>
      <uix:pageButtonBar>
        <uix:submitButton textBinding="FILTER_RESULT@audMsgs"
                          name="event" value="refineQuery"/>
        <uix:submitButton textBinding="RETURN@dbMsgs" 
                          name="event" value="return"/>
      </uix:pageButtonBar>
    </uix:pageButtons>

  </uix:pageLayout>
</db:form>
<%-- END: HTML Form --%>

</uix:body>
</uix:document>
</uix:renderingContext>
<%-- END: Content --%>

