<%@ include file="/sdk/oemTop.jspf" %>
  <%--
  --  MODIFIED    (MM/DD/YY)
  --   mnihala 05/09/05 - Fix ADA bugs 
  --   qsong   12/06/04 - 
  --   qsong   09/29/04 - 
  --   qsong   08/25/04 - 
  --   qsong   06/15/04 - qsong_db_audit
  --   qsong   06/02/04 - Creation
  --%>


<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>
<db:script src="/database/utils.js"/>

<%-- Imports --%>
<%@ page import="oracle.sysman.emo.adm.security.audit.AuditConstants" %>

<uix:renderingContext id="renderingContext">
<uix:bundle name="dbMsg"
              class="oracle.sysman.db.rsc.DBObjectMsg"/>
<uix:bundle name="auditMsg"
              class="oracle.sysman.db.rsc.sec.AuditMsg"/>
<oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%-- Browser title.  Page name from controller getPageHeader() --%>
    <%-- @ include file="/oemTitle.jspf" --%>

    <uix:metaContainer>
      <uix:head titleBinding="pageTitle@defaultAuditDS@servletRequest"/>
    </uix:metaContainer>

    <%@ include file="/enablePPR.jspf" %>
    <uix:body>
      <%-- HTML Form --%>
      <db:form name="foo" method="post" destinationBinding="<%= AuditConstants.S_PAGE_DESTINATION %>"
                          copyParams="target,type">
        <uix:formValue name="pageName" value="/database/security/audit/defaultAuditOptionsPage"/>
        <uix:formValue name="source"/>
        <uix:pageLayout titleBinding="pageHeader@defaultAuditDS@servletRequest"> 

          <%-- Oracle Logo and Tabs, breadcrumb data from --%>
          <%-- controller getNavigatorPath()              --%>
          <%@ include file="/database/global.jspf" %>

          <%-- Warning/Error display --%>
          <oem:messageBox messageType="info"
                          errorTableBinding="info@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>
          <oem:messageBox messageType="error"
                          errorTableBinding="errors@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>

          <uix:dataScope currentDataBinding="defaultAuditDS@servletRequest">
            <uix:tableLayout cellSpacing="5" width="90%"> 

              <uix:rowLayout>
                <uix:styledText styleClass="OraInstructionText" textBinding="DEFAULT_AUDIT_OPTIONS_TIP@auditMsg"/>
              </uix:rowLayout>
           
              <uix:rowLayout>
                <uix:table id="defaultAuditList"
                           alternateTextBinding="NO_OBJECT_FOUND@dbMsg"
                           formSubmitted="true"
                           width="100%"
                           tableDataBinding="rowData"
                           minValue="1"
                           valueBinding="startIndex"
                           maxValueBinding="numRows"
                           blockSizeBinding="blockSize"
                           summaryBinding="DEFAULT_AUDIT_OPTIONS_TIP@auditMsg"
                           partialRenderMode="self">

                  <uix:tableFormat tableBanding="rowBanding"/>

                  <uix:column>
                    <uix:columnHeader>
                      <uix:styledText textBinding="AUDIT_STATEMENT_HDR@auditMsg"/>
                    </uix:columnHeader>
                    <uix:columnFormat columnDataFormat="textFormat"/>
                    <uix:styledText textBinding="<%= AuditConstants.S_STATEMENT_COL%>"/>
                  </uix:column>

                  <uix:column>
                    <uix:columnHeader>
                      <uix:styledText textBinding="AUDIT_SUCCESS_HDR@auditMsg"/>
                    </uix:columnHeader>
                    <uix:columnFormat columnDataFormat="textFormat"/>
                      <oem:choice name="successOption"
                                  shortDescBinding="AUDIT_SUCCESS_HDR@auditMsg"
                                  selectedValueBinding="<%= AuditConstants.S_SUCCESS_COL%>"
                                  optionsBinding="defaultOptionsList@defaultAuditDS@servletRequest"/>
                  </uix:column>

                  <uix:column>
                    <uix:columnHeader>
                      <uix:styledText textBinding="AUDIT_FAILURE_HDR@auditMsg"/>
                    </uix:columnHeader>
                    <uix:columnFormat columnDataFormat="textFormat"/>
                      <oem:choice name="failureOption"
                                  shortDescBinding="AUDIT_FAILURE_HDR@auditMsg"
                                  selectedValueBinding="<%= AuditConstants.S_FAILURE_COL%>"
                                  optionsBinding="defaultOptionsList@defaultAuditDS@servletRequest"/>
                  </uix:column>

                  <uix:column>
                    <uix:columnHeader>
                      <uix:styledText textBinding="AUDIT_APPLICABLE_OBJECTS_HDR@auditMsg"/>
                    </uix:columnHeader>
                    <uix:columnFormat columnDataFormat="textFormat"/>
                    <uix:styledText textBinding="<%= AuditConstants.S_OBJECTS_COL%>"/>
                  </uix:column>

                </uix:table>
              </uix:rowLayout>

              <%-- java object hint text --%>
              <uix:rowLayout>
                <uix:styledText styleClass="OraInlineInfoText"
                                textBinding="AUDIT_DEF_OPT_JAVA_OBJ_HINT@auditMsg"/>
              </uix:rowLayout>
              </uix:tableLayout>
            </uix:dataScope> 

            <%-- Edit Buttons --%>
            <uix:pageButtons>
              <uix:pageButtonBar>
                <jsp:include page="/database/schema/pageButtonInclude.jsp" />
                <uix:ref refID="pageButtonInclude" />
              </uix:pageButtonBar>
            </uix:pageButtons>

         </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

