<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
  <uix:bundle name="dbMsgs"
              class="oracle.sysman.db.rsc.DBObjectMsg"/>
  <uix:bundle name="audMsgs"
              class="oracle.sysman.db.rsc.sec.AuditMsg"/>
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="CONFIRMATION@dbMsgs"/>
    </uix:metaContainer>
  <% if (request.getAttribute("em2goApp") != null) {%>
        <%@ include file="/em2go/em2goGlobal.jspf" %>
  <% } else {%>   
        <%@ include file="/database/globalPopup.jspf" %>
  <%} %>
    <uix:body>
    <db:form name="confirmForm"
             method="post"
             copyParams="target,type">
      <uix:formValue name="pageName" value="/database/security/audit/deleteConfirmation"/>

      <uix:contents>
      
        <uix:pageLayout messageType="confirmation">

          <% if (request.getAttribute("em2goApp") != null) {%>
                <%@ include file="/em2go/em2goGlobal.jspf" %>
          <% } else {%>
                <%@ include file="/database/globalPopup.jspf" %>
          <%} %>
          
         <% if (request.getAttribute("em2goApp") != null) {%>
         <%@ include file="/em2go/em2goFooter.jspf" %>
         <%}%>  

          <uix:tableLayout cellSpacing="15">
            <uix:rowLayout>
              <uix:cellFormat width="20"/>
              <uix:styledText styleClass="OraDataText"
                              textBinding="msgText@msgTable@servletRequest"/>
            </uix:rowLayout>
            <uix:rowLayout>
              <uix:cellFormat width="20"/>
              <uix:styledText styleClass="OraInstructionText"
                              textBinding="deleteWarning@mainEmoBean@servletRequest"/>
            </uix:rowLayout>

            <uix:rowLayout>
              <uix:cellFormat width="20"/>
              <uix:tableLayout cellSpacing="5">
                <uix:hideShow id="hideShow"
                              undisclosedTextBinding="SHOW_SQL@audMsgs"
                              disclosedTextBinding="HIDE_SQL@audMsgs"
                              disclosedBinding="showDeleteSQL@mainEmoBean@servletRequest"
                              formName="confirmForm"
                              formSubmitted="true">
                  <uix:spacer height="10"/>
                  <uix:rowLayout>
                    <uix:cellFormat width="20"/>
                    <db:sqlDisplay sqlListBinding="sqlList@mainEmoBean@servletRequest"/>
                  </uix:rowLayout>
                </uix:hideShow> 
              </uix:tableLayout>
            </uix:rowLayout>
          </uix:tableLayout>

          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:button textBinding="NO@uixDBObjectBundle@servletRequest" 
                      destinationBinding="backURL@servletRequest"/>
              <uix:button textBinding="YES@uixDBObjectBundle@servletRequest" 
                      destinationBinding="deleteURL@servletRequest"/>
            </uix:pageButtonBar>
          </uix:pageButtons>

        </uix:pageLayout>
            
      </uix:contents>
     </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
