<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil"%>
<%@ page import="oracle.sysman.db.rsc.streams.ApplyMsg"%>
<%@ page import="oracle.cabo.ui.data.BundleDataObject"%>
<%@ page import="oracle.sysman.db.adm.sec.common.EntDBSecConstants"%>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>
  <uix:bundle name="streamsMsgs" class="oracle.sysman.db.rsc.streams.StreamsMsg"/>
  <uix:bundle name="olsMsgs" class="oracle.sysman.db.rsc.sec.OLSOIDMsg"/>
  
   <uix:document>
  
        <uix:metaContainer>
            <uix:head titleBinding="title@servletRequest"/>
        </uix:metaContainer>

     <script>

      function showLov(lovUrl)
      {
         openWindow(window, lovUrl, 'lovWindow',{width:700, height:600},true, 'dialog','');
      }
      
    </script>
          
            <uix:body>
                <uix:form name="form0" method="POST"  destination="/console/database/EntDBSec">
                    <uix:formValue name="pageName" value="/database/security/common/dbLogin" />
  
                    <uix:pageLayout titleBinding="header@servletRequest">
                    
                   	 <%@ include file="/enablePPR.jspf" %>
                         <%@ include file="/oemGlobal.jspf" %>
		        

            <%-- <uix:messages> --%>
            <oem:messageBox messageType="info" 
                      errorTableBinding="info@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>
            <oem:messageBox messageType="error" 
                      errorTableBinding="errors@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>            
            <%-- </uix:messages> --%>

                     
                      <!-- main uix:contents -->
                      
                        <uix:tableLayout>
                          
                            <uix:spacer width="10" height="20"/>
                            <uix:rowLayout>
                              
                                <uix:cellFormat width="500" hAlign="center">

                                <uix:labeledFieldLayout>
                                  <uix:contents>
                                  <uix:messageLovField name="OID_BIND_DN" promptBinding="USER@olsMsgs" required="uiOnly" textBinding="bindDn@oidConnection@servletRequest" noAutoComplete="true"  onClickBinding="lovDestForUsers@servletRequest" messageBinding="exampleUserDn@servletRequest" searchDescBinding="SHOW_USERS@olsMsgs" columns="50" maximumLength="1024" />

                                  <uix:spacer width="10" height="10"/>                  

				  <%--  
                                  <uix:messageTextInput promptBinding="PASSWORD@olsMsgs" name="OID_PASSWORD" required="uiOnly" textBinding="password@oidConnection@servletRequest"/>
                                  --%>

				  <uix:messageTextInput name="OID_PASSWORD" promptBinding="PASSWORD@olsMsgs" required="uiOnly"  secret="true" noAutoComplete="true" />

                                  <%--
                                  <uix:spacer width="10" height="10"/>
                                  
                                <uix:switcher defaultCase="false" childNameBinding="disableModule@oidConnection@servletRequest">
                                
                                    <uix:case name="true">
                                    
                                        <uix:messageStyledText 
                                                           textBinding="configureModule@servletRequest"
                                                           promptBinding="CONFIGURE@olsMsgs"
                                                           styleClass="OraDataText"
                                                           shortDescBinding="CONFIGURE@olsMsgs"
                                                           />
                                        
                                    </uix:case>
                                    
                                    <uix:case name="false">
                                    
                                          <uix:messageChoice promptBinding="CONFIGURE@olsMsgs" name="configuremodule" >
                                              <uix:option text="Label Security" value="<%= EntDBSecConstants.OLS_URL%>"  />
                                              <uix:option text="Enterprise Users" value="<%=EntDBSecConstants.EUS_URL%>" />
                                              <uix:option text="Global Application Context" value="<%=EntDBSecConstants.APPCTX_URL%>" />
                                          </uix:messageChoice>
                                        
                                    </uix:case>
                                    
                                </uix:switcher>
                    
                                  --%>
                                  <uix:spacer width="10" height="10"/>
                                  <%--
                                  <uix:messageTextInput name="OID_HOST" promptBinding="HOST@olsMsgs" required="uiOnly" textBinding="host@oidConnection@servletRequest" disabled="true" />
                                  --%>
                                  <uix:messageStyledText shortDescBinding="HOST@olsMsgs" textBinding="host@oidConnection@servletRequest"  promptBinding="HOST@olsMsgs" styleClass="OraDataText" />
                                  
                                  <uix:spacer width="10" height="10"/>
                                  <%--
                                  <uix:messageTextInput promptBinding="PORT@olsMsgs" name="OID_PORT" required="uiOnly" textBinding="port@oidConnection@servletRequest" disabled="true" />
                                  --%>
                                  <uix:messageStyledText shortDescBinding="PORT@olsMsgs" textBinding="port@oidConnection@servletRequest"  promptBinding="PORT@olsMsgs" styleClass="OraDataText" />
                                  
                                  <uix:spacer width="10" height="10"/>
                                  <%--
                                  <uix:messageTextInput promptBinding="REALM@olsMsgs" name="realm" required="uiOnly" textBinding="realmDn@oidConnection@servletRequest" disabled="true" />
                                  --%>
                                  <uix:messageStyledText shortDescBinding="REALM@olsMsgs" textBinding="realmDn@oidConnection@servletRequest"  promptBinding="REALM@olsMsgs" styleClass="OraDataText" />
                                  
                                  </uix:contents>
                                </uix:labeledFieldLayout>
                                  
                                  
                                </uix:cellFormat>
                                <%--
                                <uix:cellFormat width="500" hAlign="end">
                                  
                                    <uix:contentContainer text="Overview of Enterprise Database Security" width="350">
                                      
                                        <uix:styledText text="Enterprise Database Security feature enables " styleClass="OraInstructionText"/>
                                        <uix:spacer width="10" height="10"/>
                                        <uix:styledText text="1) To implement Oracle Label Security Policies for different databases in      a  Oracle Internet Directory. " styleClass="OraInstructionText"/>
                                        <uix:spacer width="10" height="10"/>
                                        <uix:styledText text="2) To store Globally Initialized Application Context attributes in Oracle      Internet Directory and assign it to one or more enterprise users. They      can be retrieved automatically  upon login for an enterprise user and      then used to initialize an application context." styleClass="OraInstructionText"/>
                                        <uix:spacer width="10" height="10"/>
                                        <uix:styledText text="3)  Administration of Enterprise users for different  databases in a Oracle         Internet Directory." styleClass="OraInstructionText"/>
                                      
                                    </uix:contentContainer>
                                  
                                </uix:cellFormat>
                              --%>
                            </uix:rowLayout>
                          
                        </uix:tableLayout>


                                  
                                  
                      <uix:pageStatus>
                        <uix:flowLayout>
                          
                            <uix:formattedText textBinding="OLS_LOGIN_PAGE_INST_TEXT@olsMsgs"
                                           styleClass="OraInstructionText"/>
                          
                        </uix:flowLayout>
                      </uix:pageStatus>

             <uix:pageButtons>
                <uix:pageButtonBar>
                  <uix:contents>
                <uix:button shortDescBinding="CANCEL@olsMsgs" textBinding="CANCEL@olsMsgs" destinationBinding="cancelUrl@servletRequest" />
                <uix:submitButton textBinding="LOGIN@olsMsgs" name="event" value="doDbLogin" />

                  </uix:contents>
                </uix:pageButtonBar>
                
             </uix:pageButtons>
                      
                    </uix:pageLayout>
                </uix:form>
            </uix:body>
        </uix:document>
</uix:renderingContext>


