<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil"%>
<%@ page import="oracle.sysman.db.rsc.streams.ApplyMsg"%>
<%@ page import="oracle.cabo.ui.data.BundleDataObject"%>
<%@ page import="oracle.sysman.emo.adm.security.eus.EUSConstants"%>
<%@ page import="oracle.sysman.emo.util.UIXDataSource"%>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>
  <uix:bundle name="streamsMsgs" class="oracle.sysman.db.rsc.streams.StreamsMsg"/>
  
        <uix:document>
                     <%@ include file="/oemTitle.jspf" %>

          <uix:metaContainer>
            <!-- Set the page title -->
            <uix:head titleBinding="WINDOW_TITLE@servletRequest"/>
          </uix:metaContainer>
            <uix:body>
               
                <uix:form name="form0" method="POST" destination="/console/database/EntDBSec?event=launchmodule">
                      
                    <uix:pageLayout title="Realm Selection..">
                   	 <%@ include file="/enablePPR.jspf" %>
                         <%@ include file="/oemGlobal.jspf" %>
		         <%@ include file="/database/security/common/entdbseclogout.jspf" %>
                      <!-- main contents -->
                      
                        <uix:tableLayout>
                          
                            <uix:spacer width="10" height="20"/>
                            <uix:rowLayout width="500">

                                <uix:dataScope currentDataBinding="REALM_TABLE_LIST@servletRequest">
                                <uix:table 
                                            name="REALM_TABLE_LIST"
                                               alternateText="No Items Found."
                                               width="100%"
                                               formSubmitted="true" 
                                               tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                                               minValue="1"
                                               valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                                               blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>" 
                                               maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
                                  >
                                            <uix:tableFormat tableBanding="rowBanding"/>

                                                <uix:column>
                                                        <uix:columnHeader>
                                                                <uix:text text = "Realm Name"/>
                                                        </uix:columnHeader>
                                                        <uix:columnFormat columnDataFormat="textFormat" />
                                                         <% String REALM_NAME_INDEX = "REALM_NAME_INDEX"; %>
                                                <uix:styledText textBinding="<%= REALM_NAME_INDEX %>" />
                                                </uix:column>                      

                                                <%--
                                                <uix:column>
                                                        <uix:columnHeader>
                                                                <uix:sortableHeader text="No. Of Users" sortable="false"/>
                                                        </uix:columnHeader>
                                                        <uix:columnFormat columnDataFormat="numberFormat" />
                                                         <% String REALM_USERS_INDEX = "REALM_USERS_INDEX"; %>
	                                                <uix:styledText textBinding="<%= REALM_USERS_INDEX %>" />
                                                </uix:column>

                                                <uix:column>
                                                        <uix:columnHeader>
                                                                <uix:sortableHeader text="No. f Groups" sortable="false"/>
                                                        </uix:columnHeader>
                                                        <uix:columnFormat columnDataFormat="numberFormat" />
                                                         <% String REALM_GROUPS_INDEX = "REALM_GROUPS_INDEX"; %>
	                                                <uix:styledText textBinding="<%= REALM_GROUPS_INDEX %>" />
                                                </uix:column>
                                                --%>

                                        <uix:tableSelection>
                                            <uix:singleSelection selectedIndex="0" text="Select an item and ..."/>
                                        </uix:tableSelection>
                                        
                                  <uix:tableActions>
                                    <uix:flowLayout>
                                      
                                        <uix:rowLayout>
                                          
                                            <uix:messageChoice prompt="Configure" name="configuremodule" >
                                                <uix:option text="Label Security" value="/database/EntDBSec/OLSOID/PolicyController"/>
                                                <uix:option text="Enterprise Users" value="<%=EUSConstants.EUS_LAUNCH_URL%>"/>
                                                <uix:option text="Application Context" value="/database/EntDBSec/AppCtxt"/>
                                            </uix:messageChoice>
                                            <uix:spacer width="10" height="10"/>
                                            <uix:submitButton text="Go" destination="/console/database/EntDBSec?event=launchmodule"/>
                                          
                                        </uix:rowLayout>
                                      
                                    </uix:flowLayout>
                                  </uix:tableActions>
                                        
                                 </uix:table>
                                </uix:dataScope>
                              
                            </uix:rowLayout>
                          
                        </uix:tableLayout>
                      
                      <uix:location>
                        <uix:breadCrumbs>
                          
		            <uix:link text="Enterprise Database Security"
			    destination="/console/database/EntDBSec?event=login"
			    />
                            <uix:link text="uix:link 0"/>
                          
                        </uix:breadCrumbs>
                      </uix:location>
                      <uix:pageStatus>
                        <uix:flowLayout>
                          
                            <uix:formattedText text="Select a Realm for Enterprise Database Security administration."
                                           styleClass="OraInstructionText"/>
                          
                        </uix:flowLayout>
                      </uix:pageStatus>
                    </uix:pageLayout>
                  
                </uix:form>
               
            </uix:body>
          
        </uix:document>
   </uix:renderingContext>

