<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="title@objectBean@servletRequest" />
  
    <script language="JavaScript">
      <%@ include file="/database/utils.js"%>
    </script>
    </uix:metaContainer>


    <uix:body>
      <db:form name="foo" method="POST" destinationBinding="destination@objectBean@servletRequest" copyParams="target,type,cancelURL,oname,otype">
      <uix:pageLayout titleBinding="header@objectBean@servletRequest" >
        <%@ include file="/database/global.jspf" %>
        
        <uix:formValue name="pageName" value="/database/security/consumerGrpPage"/>
        <uix:formValue name="miscCode" valueBinding="miscCode@objectBean@servletRequest" />

        <oem:messageBox messageType="info" errorTableBinding="info@servletRequest"
                             titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="error" errorTableBinding="errors@servletRequest"
                             titleTextKey="titleText" mainTextKey="mainText"/>
        
        <uix:subTabLayout>
          <uix:subTabs>
            <uix:subTabBar selectedIndex="5">
              
                <uix:link textBinding="GENERAL_TAB@uixgranteeBundle@servletRequest"
                onClick="submitForm('foo', true, {event:'generalTab'})"/>
                <uix:link textBinding="ROLE_TAB@uixgranteeBundle@servletRequest"
                 onClick="submitForm('foo', true, {event:'roleTab'})"/>
                <uix:link textBinding="SYSTEM_TAB@uixgranteeBundle@servletRequest"
                 onClick="submitForm('foo', true, {event:'systemTab'})"/>
                <uix:link textBinding="OBJECT_TAB@uixgranteeBundle@servletRequest"
                 onClick="submitForm('foo', true, {event:'objectTab'})"/>
                 <uix:switcher childNameBinding="userObject@objectBean@servletRequest">
                 <uix:case name="true">
                 <uix:link textBinding="QUOTA_TAB@uixuserBundle@servletRequest" 
                 onClick="submitForm('foo', true, {event:'quotaTab'})"/>
                 </uix:case>
                </uix:switcher>
                <uix:switcher childNameBinding="versionEqualOrHigherTo815@objectBean@servletRequest">
                  <uix:case name="true">
                     <uix:link textBinding="CONSUMER_GROUP_TAB@uixgranteeBundle@servletRequest" />
                      
                  </uix:case>
                </uix:switcher>
                <uix:switcher childNameBinding="userObject@objectBean@servletRequest">
                 <uix:case name="true">
                <uix:link textBinding="PROXY_TAB@uixuserBundle@servletRequest"
                 onClick="submitForm('foo', true, {event:'proxyTab'})"/>
                 </uix:case>
                </uix:switcher>
             
            </uix:subTabBar>
          </uix:subTabs>

          <%-- add explanitory text; different for users and roles --%>
          <uix:switcher childNameBinding="userObject@objectBean@servletRequest">
            <uix:case name="true">
              <uix:stackLayout>
                <uix:spacer height="5" />
                <uix:styledText styleClass="OraInstructionText" textBinding="USER_CONSGRP_TEXT@uixgranteeBundle@servletRequest" />
              </uix:stackLayout>
            </uix:case>
            <uix:case name="false">
              <uix:stackLayout>
                <uix:spacer height="5" />
                <uix:styledText styleClass="OraInstructionText" textBinding="ROLE_CONSGRP_TEXT@uixgranteeBundle@servletRequest" />
              </uix:stackLayout>
            </uix:case>
          </uix:switcher>

            <uix:tableLayout width="100%" cellSpacing="2">
               <uix:rowLayout hAlign="right">
                  <uix:submitButton textBinding="ADD_DEL_BTN@uixgranteeBundle@servletRequest" name="event" value="addConsumerGrp" />
                </uix:rowLayout> 

               <uix:rowLayout>
                
                    <oem:table name="consumerGrpsTableUI" beanKey="consumerGrpPageBean" blockSize="25"
                              destinationBinding="destination@consumerGrpPageBean@servletRequest" formSubmitted="true"
                              summaryBinding="CONSUMER_GROUP_TAB@uixgranteeBundle@servletRequest"
                              dataSourceProp="consumerGrpsTableUI" alternateTextBinding="NO_ITEMS_FOUND@uixDBObjectBundle@servletRequest" width="100%">
                    </oem:table>
                  
               </uix:rowLayout>

              
               <uix:rowLayout hAlign="left" > 
                <uix:switcher childNameBinding="userObject@objectBean@servletRequest">
                <uix:case name="true">
                    <uix:rowLayout>
                    <uix:cellFormat hAlign="right">
		    <uix:flowLayout>
		    	<uix:spacer height="20" />
                      <uix:messagePrompt labeledNodeId="defaultconsgrp" promptBinding="INITIALCONSGRP@uixgranteeBundle@servletRequest"/>
		    </uix:flowLayout>
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="left">
		    <uix:flowLayout>
		    	<uix:spacer height="20" />
                      <oem:choice id="defaultconsgrp" name="defaultconsgrp" optionsBinding="consumerGroups@consumerGrpPageBean@servletRequest" selectedValueBinding="defaultconsgrp@consumerGrpPageBean@servletRequest" />
		    </uix:flowLayout>
                    </uix:cellFormat>
                    </uix:rowLayout>
                </uix:case>
                </uix:switcher>
               </uix:rowLayout>
               
              </uix:tableLayout>   
           </uix:subTabLayout>
    
          <uix:pageButtons>
          <uix:pageButtonBar>
            <jsp:include page="/database/schema/pageButtonInclude.jsp" />
            <uix:ref refID="pageButtonInclude" />            
	  </uix:pageButtonBar>
        </uix:pageButtons>
         
      </uix:pageLayout>
      </db:form>
      </uix:body>
   
</uix:document>
</uix:renderingContext> 

