<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>
<% oracle.cabo.share.util.CaboHttpUtils.setNoCacheHeaders(response); %>

<uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext"/>
    <uix:document>
        <uix:metaContainer>
            <uix:head titleBinding="title@objectBean@servletRequest" />
  
            <script language="JavaScript">
                <%@ include file="/database/utils.js"%>
            </script>
     
        </uix:metaContainer>
        <uix:body>
            <db:form name="dirobj" method="POST" destination="/console/database/security/dirObject" 
                copyParams="target,type,cancelURL,oname,otype">
                <uix:pageLayout titleBinding="header@objectBean@servletRequest" >
                    <uix:formValue name="pageName" value="/database/security/dirobject/addDirUserPage"/>
                    <%@ include file="/database/global.jspf" %>

                    <oem:messageBox messageType="info" errorTableBinding="info@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                    <oem:messageBox messageType="error" errorTableBinding="errors@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                    
                             <uix:tableLayout>
                            <uix:rowLayout>
                                <uix:cellFormat>
                                    <uix:spacer height="10"/>
                                </uix:cellFormat>
                            </uix:rowLayout>
                            <uix:rowLayout>
                                <uix:cellFormat>
                                    <uix:spacer width="20"/>
                                    <uix:messagePrompt promptBinding="AVAILABLE_USERS@uixDirectoryObjectBundle@servletRequest" labeledNodeId="searchFilter" />
                                </uix:cellFormat>
                                <uix:cellFormat>
                                    <uix:textInput id="searchFilter" name = "searchFilter" columns="10" shortDescBinding = "AVAILABLE_USERS@uixDirectoryObjectBundle@servletRequest" />
                                </uix:cellFormat>
                                <uix:spacer width="8" />
                                <uix:cellFormat>
                                    <uix:submitButton textBinding="GO@uixDBObjectBundle@servletRequest" name="event" value="searchUsers" shortDescBinding="GO@uixDBObjectBundle@servletRequest"/>
                                </uix:cellFormat>
                            </uix:rowLayout>
                        </uix:tableLayout>
                       

                    <uix:header textBinding = "AVAILABLE_USERS@uixDirectoryObjectBundle@servletRequest">
                        <uix:spacer width="8" />
                        <uix:tableLayout width="80%">
               				  
                            <uix:rowLayout>
                
                                <oem:table name="availableUsersTableUI" beanKey="userListDataSource"
                                    blockSize="10"  formSubmitted="true"
                                    dataSourceProp="availableUsersTableUI" 
                                    alternateTextBinding="NO_ITEMS_FOUND@uixDBObjectBundle@servletRequest" 
                                    summaryBinding="SELECT_AVAILABLE_SUMMARY@uixDBObjectBundle@servletRequest"
                                    width="100%" copyParams="target,type">
                                    <uix:tableSelection>
                                        <uix:multipleSelection text = "Select" shortDescBinding="SELECT_SHORTDESC@uixDBObjectBundle@servletRequest">
									
                                        </uix:multipleSelection>
                                    </uix:tableSelection>
                                </oem:table>
                            </uix:rowLayout>

                        </uix:tableLayout>
                    </uix:header>
                    <uix:pageButtons>
                        <uix:pageButtonBar>
                    
                            <uix:submitButton textBinding="CANCEL@uixDBObjectBundle@servletRequest" name="event" value="cancel" shortDescBinding="CANCEL@uixDBObjectBundle@servletRequest"/>	               							<uix:submitButton textBinding="OK@uixDBObjectBundle@servletRequest" name="event" value="selectUsers" shortDescBinding="OK@uixDBObjectBundle@servletRequest"/>
                        </uix:pageButtonBar>
                    </uix:pageButtons>
                </uix:pageLayout>
            </db:form>
        </uix:body>  
    </uix:document>
</uix:renderingContext> 
