<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>
<% oracle.cabo.share.util.CaboHttpUtils.setNoCacheHeaders(response); %>


<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>
    <uix:metaContainer>
      <uix:head titleBinding="title@objectBean@servletRequest" />
  
      <script language="JavaScript">
      	<%@ include file="/database/utils.js"%>
      </script>
     
    </uix:metaContainer>
    <uix:body>
	<db:form name="dirobj" method="POST" destination="/console/database/security/dirObject" copyParams="target,type,cancelURL,oname,otype">
     	   <uix:pageLayout titleBinding="header@objectBean@servletRequest" >
		<uix:formValue name="pageName" value="/database/security/dirobject/generalPage"/>
		 <%@ include file="/database/global.jspf" %>

		<oem:messageBox messageType="info" errorTableBinding="info@servletRequest"
                             titleTextKey="titleText" mainTextKey="mainText"/>
        	<oem:messageBox messageType="error" errorTableBinding="errors@servletRequest"
                             titleTextKey="titleText" mainTextKey="mainText"/>
		<uix:switcher childNameBinding="sysdbaPriv@objectBean@servletRequest">
                                        	<uix:case name="false">
			<uix:messagePrompt messageType="warning" promptBinding="NOT_SYSDBA_INFO@uixDirectoryObjectBundle@servletRequest"/> 
		</uix:case>
		</uix:switcher>
		<uix:subTabLayout>
          		<uix:subTabs>
           			 <uix:subTabBar selectedIndex="0">
              
                			<uix:link textBinding="GENERAL_TAB@uixDirectoryObjectBundle@servletRequest" />
                                        <uix:switcher childNameBinding="sysdbaPriv@objectBean@servletRequest">
                                        	<uix:case name="true">    
		                			<uix:link textBinding="PRIVILEGE_TAB@uixDirectoryObjectBundle@servletRequest"
                	 				onClick="submitForm('dirobj', true, {event:'privilegeTab'})"/>
						</uix:case>
						<uix:case name="false">
							<uix:link textBinding="PRIVILEGE_TAB@uixDirectoryObjectBundle@servletRequest"
								  disabled ="true" />
						</uix:case>
                                       </uix:switcher>        
            			</uix:subTabBar>
          		</uix:subTabs>
			<uix:spacer width="8" />
			<uix:tableLayout cellSpacing="5">

		              <uix:rowLayout>
				
               			 <uix:cellFormat hAlign="right">
                  			<uix:switcher childNameBinding="creating@objectBean@servletRequest">
                    				<uix:case name="true">
                      					<uix:messagePrompt labeledNodeId="doName" promptBinding="NAME@uixDBObjectBundle@servletRequest" required="yes"/>
                    				</uix:case>
                    				<uix:case name="false">
                      					<uix:messagePrompt promptBinding="NAME@uixDBObjectBundle@servletRequest" />
                    				</uix:case>
                  			</uix:switcher>
                		</uix:cellFormat>
     	          		<uix:stackLayout>
                 			 <uix:switcher childNameBinding="creating@objectBean@servletRequest">
                    				<uix:case name="true">
                      					<uix:textInput id="doName" name="doName" textBinding="doName@objectBean@servletRequest" columns="50" shortDescBinding="NAME@uixDBObjectBundle@servletRequest"/>
                    				</uix:case>
                    				<uix:case name="false">
                      					<uix:styledText textBinding="doName@objectBean@servletRequest" styleClass="OraDataText" />
                    				</uix:case>
                  			</uix:switcher>
                  			<uix:messageText messageBinding="doName@errors@servletRequest" messageType="error"/>
                		</uix:stackLayout>
              	   	    </uix:rowLayout>
	
			    <uix:rowLayout>
                		<uix:cellFormat hAlign="right">
                   			<uix:messagePrompt labeledNodeId="doPath" promptBinding="PATH@uixDBObjectBundle@servletRequest" required="yes"/>
               			 </uix:cellFormat>
			
     	       			 <uix:stackLayout>   
             			        <uix:tableLayout>
						<uix:rowLayout>
                                                       <uix:cellFormat>
                      						<uix:textInput id="doPath" name="doPath" textBinding="doPath@objectBean@servletRequest" columns="50" shortDescBinding="PATH@uixDBObjectBundle@servletRequest"/>
							</uix:cellFormat>
							<uix:spacer width="8" />
							<uix:cellFormat>
    					     			 <uix:submitButton textBinding="TEST_FILE_SYSTEM@uixDirectoryObjectBundle@servletRequest" name="event" value = "testFileSystem" shortDescBinding="TEST_FILE_SYSTEM@uixDirectoryObjectBundle@servletRequest"/>
							</uix:cellFormat>
						</uix:rowLayout>      
					</uix:tableLayout>                		
					<uix:messageText messageBinding="doPath@errors@servletRequest" messageType="error"/>
                                       
                		</uix:stackLayout>
              		   </uix:rowLayout>
			</uix:tableLayout>
				<uix:spacer width="8" />
		</uix:subTabLayout>
		<uix:pageButtons>
         <uix:pageButtonBar>
           <jsp:include page="/database/schema/pageButtonInclude.jsp" />
            <uix:ref refID="pageButtonInclude" />
         </uix:pageButtonBar>
       </uix:pageButtons>
     	   </uix:pageLayout>
	</db:form>
      </uix:body>  
   </uix:document>
</uix:renderingContext>  










