<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>
<% oracle.cabo.share.util.CaboHttpUtils.setNoCacheHeaders(response); %>


<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>
    <uix:metaContainer>
      <uix:head titleBinding="title@objectBean@servletRequest" />
  
      <script language="JavaScript">
      	<%@ include file="/database/utils.js"%>
      </script>
     
    </uix:metaContainer>
    <uix:body>
	<db:form name="dirobj" method="POST" destination="/console/database/security/dirObject" copyParams="target,type,cancelURL,oname,otype">
     	   <uix:pageLayout titleBinding="header@objectBean@servletRequest" >
		<uix:formValue name="pageName" value="/database/security/dirobject/loginPage"/>
		 <%@ include file="/database/global.jspf" %>

		<oem:messageBox messageType="info" errorTableBinding="info@servletRequest"
                             titleTextKey="titleText" mainTextKey="mainText"/>
        	<oem:messageBox messageType="error" errorTableBinding="errors@servletRequest"
                             titleTextKey="titleText" mainTextKey="mainText"/>

		  <uix:labeledFieldLayout width="51%">
 	  		<uix:messagePrompt promptBinding="HOST_NAME@uixDBMsgBundle@servletRequest" />
          		<uix:styledText styleClass="OraDataText" textBinding="hostName@credsBean@servletRequest"/>
        	 </uix:labeledFieldLayout>
        	<uix:labeledFieldLayout width="51%">
	  		<uix:messagePrompt promptBinding="ORACLE_HOME@uixDBMsgBundle@servletRequest" />
          		<uix:styledText styleClass="OraDataText" textBinding="oracleHome@credsBean@servletRequest"/>
        	</uix:labeledFieldLayout>

       		<%@ include file="/credentials.jspf" %>
             	<uix:pageButtons>
	     		<uix:pageButtonBar>
	              		<uix:submitButton textBinding="CANCEL@uixDBObjectBundle@servletRequest"  name="event" value="cancel" shortDescBinding="CANCEL@uixDBObjectBundle@servletRequest"/>
	              		<uix:submitButton textBinding="LOGIN@uixDBObjectBundle@servletRequest"  name="event" value="dirHostLogin" shortDescBinding="LOGIN@uixDBObjectBundle@servletRequest"/> 
              		</uix:pageButtonBar>
	      </uix:pageButtons>
	   </uix:pageLayout>
	</db:form>
    </uix:body>
   </uix:document>
</uix:renderingContext>