<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>
<% oracle.cabo.share.util.CaboHttpUtils.setNoCacheHeaders(response); %>


<uix:renderingContext id="renderingContext">
<uix:bundle name="streamsBundle" class="oracle.sysman.db.rsc.streams.StreamsMsg"/>
<uix:bundle name="dbBundle" class="oracle.sysman.db.rsc.DBObjectMsg"/>
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>
    <uix:metaContainer>
      <uix:head titleBinding="title@objectBean@servletRequest" />
  
      <script language="JavaScript">
      	<%@ include file="/database/utils.js"%>
      </script>
     
    </uix:metaContainer>
    <uix:body>
	<db:form name="dirobj" method="POST" destination="/console/database/security/dirObject" copyParams="target,type,cancelURL,oname,otype">
     	   <uix:pageLayout titleBinding="header@objectBean@servletRequest" >
		<uix:formValue name="pageName" value="/database/security/dirobject/privilegePage"/>
		 <%@ include file="/database/global.jspf" %>

		<oem:messageBox messageType="info" errorTableBinding="info@servletRequest"
                             titleTextKey="titleText" mainTextKey="mainText"/>
        	<oem:messageBox messageType="error" errorTableBinding="errors@servletRequest"
                             titleTextKey="titleText" mainTextKey="mainText"/>
		
		<uix:subTabLayout>
          		<uix:subTabs>
           			 <uix:subTabBar selectedIndex="1">
              
                			<uix:link textBinding="GENERAL_TAB@uixDirectoryObjectBundle@servletRequest"
							onClick="submitForm('dirobj', true, {event:'generalTab'})"/> 
                			<uix:link textBinding="PRIVILEGE_TAB@uixDirectoryObjectBundle@servletRequest"/>
                 			
            			</uix:subTabBar>
          		</uix:subTabs>
			<uix:styledText textBinding = "USER_LIST_MSG@uixDirectoryObjectBundle@servletRequest" styleClass="OraPromptText"/>
				<uix:spacer width="8" />
				<uix:tableLayout width="80%">
               				 <uix:rowLayout hAlign="right" >

                 				 <uix:submitButton textBinding="ADD@uixDBObjectBundle@servletRequest" name="event" value="addDirUsers" shortDescBinding="ADD@uixDBObjectBundle@servletRequest" />
                			</uix:rowLayout>  
                			<uix:rowLayout>
                
                    				<oem:table name="dirObjUsersTableUI" beanKey="userDataSource"
             						blockSize="10"  formSubmitted="true"
            	 					dataSourceProp="dirObjectUsersTableUI" 
							alternateTextBinding="NO_SEARCH_DONE@streamsBundle"
                                                        summaryBinding="VIEW_PRIVILEGE_SUMMARY@uixDBObjectBundle@servletRequest"
							width="100%" copyParams="target,type">
							
							<uix:tableSelection>
								<uix:multipleSelection textBinding="SELECT@dbBundle" shortDescBinding="SELECT_SHORTDESC@uixDBObjectBundle@servletRequest">
									<uix:contents>
										<uix:submitButton textBinding="REMOVE@uixDirectoryObjectBundle@servletRequest" 
											name="event" value="removeDirUsers" shortDescBinding="REMOVE@uixDirectoryObjectBundle@servletRequest"/>
									</uix:contents>
								</uix:multipleSelection>
							</uix:tableSelection>
						</oem:table>
                			 </uix:rowLayout>

            			</uix:tableLayout>

		</uix:subTabLayout>
		<uix:pageButtons>
          		<uix:pageButtonBar>
                    		<uix:submitButton textBinding="SHOWSQL@uixDBObjectBundle@servletRequest" name="event" value="showSql" shortDescBinding="SHOWSQL@uixDBObjectBundle@servletRequest"/>
            			<uix:switcher childNameBinding="creating@objectBean@servletRequest">
             			 	<uix:case name="true">
                
                  				<uix:submitButton textBinding="CANCEL@uixDBObjectBundle@servletRequest" name="event" value="cancel" shortDescBinding="CANCEL@uixDBObjectBundle@servletRequest"/>
                  
             				 </uix:case>
              				<uix:case name="false">
                
                  				<uix:submitButton textBinding="REVERT@uixDBObjectBundle@servletRequest" name="event" value="revert" unvalidated="true" shortDescBinding="REVERT@uixDBObjectBundle@servletRequest"/>
                  
              				</uix:case>
            			</uix:switcher>
            			<uix:switcher childNameBinding="creating@objectBean@servletRequest">
              				<uix:case name="true">
                
                  				<uix:submitButton textBinding="OK@uixDBObjectBundle@servletRequest" name="event" value="apply" shortDescBinding="OK@uixDBObjectBundle@servletRequest"/>
                  
                
              				</uix:case>
              				<uix:case name="false">
                
                  				<uix:submitButton textBinding="APPLY@uixDBObjectBundle@servletRequest" name="event" value="apply" shortDescBinding="APPLY@uixDBObjectBundle@servletRequest"/>
                
              				</uix:case>
           			 </uix:switcher>
            
          		 </uix:pageButtonBar>
        	</uix:pageButtons>
     	   </uix:pageLayout>
	</db:form>
      </uix:body>  
   </uix:document>
</uix:renderingContext>  
